/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.service.RequestParameter;

class RequestParameterMerger {
    private final Map<String, RequestParameter> destination;
    private final Map<String, RequestParameter> source;

    RequestParameterMerger(Collection<RequestParameter> destination, Collection<RequestParameter> source) {
        this.destination = destination.stream().collect(Collectors.toMap(RequestParameter::getName, Function.identity()));
        this.source = source.stream().collect(Collectors.toMap(RequestParameter::getName, Function.identity(), this::mergeWithPrecedence));
    }

    public List<RequestParameter> merge() {
        ArrayList<RequestParameter> merged = new ArrayList<RequestParameter>();
        Set<String> asIsParams = this.destination.keySet().stream().filter(entry -> !this.source.containsKey(entry)).collect(Collectors.toSet());
        Set<String> missingParamNames = this.source.keySet().stream().filter(entry -> !this.destination.containsKey(entry)).collect(Collectors.toSet());
        Set<String> paramsToMerge = this.source.keySet().stream().filter(this.destination::containsKey).collect(Collectors.toSet());
        merged.addAll(this.parametersNotRequiringMerging(asIsParams, this.destination.values()));
        merged.addAll(this.parametersNotRequiringMerging(missingParamNames, this.source.values()));
        merged.addAll(this.mergedParameters(paramsToMerge));
        return merged;
    }

    private List<RequestParameter> parametersNotRequiringMerging(Set<String> asIsParams, Collection<RequestParameter> source) {
        ArrayList<RequestParameter> parameters = new ArrayList<RequestParameter>();
        for (RequestParameter each : source) {
            if (!asIsParams.contains(each.getName())) continue;
            parameters.add(each);
        }
        return parameters;
    }

    private List<RequestParameter> mergedParameters(Set<String> paramsToMerge) {
        ArrayList<RequestParameter> parameters = new ArrayList<RequestParameter>();
        for (String each : paramsToMerge) {
            RequestParameter original = this.destination.get(each);
            RequestParameter newParam = this.source.get(each);
            parameters.add(this.mergeWithPrecedence(newParam, original));
        }
        return parameters;
    }

    private RequestParameter merge(RequestParameter destination, RequestParameter source) {
        return new RequestParameterBuilder().copyOf(destination).copyOf(source).build();
    }

    private RequestParameter mergeWithPrecedence(RequestParameter first, RequestParameter second) {
        if (first.getPrecedence() > second.getPrecedence()) {
            return this.merge(first, second);
        }
        return this.merge(second, first);
    }
}

