/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;

@Internal
public final class ChangelogStateHandleStreamImpl
implements ChangelogStateHandle {
    private static final long serialVersionUID = -8070326169926626355L;
    private final KeyGroupRange keyGroupRange;
    private final List<Tuple2<StreamStateHandle, Long>> handlesAndOffsets;
    private transient SharedStateRegistry stateRegistry;
    private final long size;

    public ChangelogStateHandleStreamImpl(List<Tuple2<StreamStateHandle, Long>> handlesAndOffsets, KeyGroupRange keyGroupRange, long size) {
        this.handlesAndOffsets = handlesAndOffsets;
        this.keyGroupRange = keyGroupRange;
        this.size = size;
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
        this.stateRegistry = stateRegistry;
        this.handlesAndOffsets.forEach(handleAndOffset -> stateRegistry.registerReference(ChangelogStateHandleStreamImpl.getKey((StreamStateHandle)handleAndOffset.f0), (StreamStateHandle)handleAndOffset.f0));
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    @Nullable
    public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
        KeyGroupRange offsets = keyGroupRange.getIntersection(keyGroupRange);
        if (offsets.getNumberOfKeyGroups() == 0) {
            return null;
        }
        return new ChangelogStateHandleStreamImpl(this.handlesAndOffsets, offsets, 0L);
    }

    @Override
    public void discardState() {
        if (this.stateRegistry != null) {
            this.handlesAndOffsets.forEach(handleAndOffset -> this.stateRegistry.unregisterReference(ChangelogStateHandleStreamImpl.getKey((StreamStateHandle)handleAndOffset.f0)));
        }
    }

    @Override
    public long getStateSize() {
        return this.size;
    }

    private static SharedStateRegistryKey getKey(StreamStateHandle stateHandle) {
        if (stateHandle instanceof FileStateHandle) {
            return new SharedStateRegistryKey(((FileStateHandle)stateHandle).getFilePath().toString());
        }
        if (stateHandle instanceof ByteStreamStateHandle) {
            return new SharedStateRegistryKey(((ByteStreamStateHandle)stateHandle).getHandleName());
        }
        return new SharedStateRegistryKey(Integer.toString(System.identityHashCode(stateHandle)));
    }

    public List<Tuple2<StreamStateHandle, Long>> getHandlesAndOffsets() {
        return Collections.unmodifiableList(this.handlesAndOffsets);
    }
}

