/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes;

import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBuilder;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluent;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluentImpl;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpecFluent;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.InOutCreateable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.flink.client.program.ClusterClient;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.kubernetes.IngressController$;
import org.apache.streampark.flink.kubernetes.IngressMeta;
import org.apache.streampark.flink.kubernetes.IngressMeta$;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class IngressController$
implements org.apache.streampark.common.util.Logger {
    public static final IngressController$ MODULE$;
    private transient Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new IngressController$();
    }

    public Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public String logName() {
        return Logger.class.logName((org.apache.streampark.common.util.Logger)this);
    }

    public Logger logger() {
        return Logger.class.logger((org.apache.streampark.common.util.Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.class.logInfo((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.class.logInfo((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.class.logDebug((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.class.logDebug((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.class.logTrace((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.class.logTrace((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.class.logWarn((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.class.logWarn((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.class.logError((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.class.logError((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger.class.initializeLogIfNecessary((org.apache.streampark.common.util.Logger)this, (boolean)isInterpreter);
    }

    public void configureIngress(String domainName, String clusterId, String nameSpace) {
        Try try_ = Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DefaultKubernetesClient apply() {
                return new DefaultKubernetesClient();
            }
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DefaultKubernetesClient client = (DefaultKubernetesClient)success.value();
            scala.collection.immutable.Map annotMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/rewrite-target"), (Object)"/$2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/proxy-body-size"), (Object)"1024m"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nginx.ingress.kubernetes.io/configuration-snippet"), (Object)new StringBuilder().append((Object)"rewrite ^(/").append((Object)clusterId).append((Object)")$ $1/ permanent;").toString())}));
            scala.collection.immutable.Map labelsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"app"), (Object)clusterId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"flink-native-kubernetes"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"component"), (Object)"ingress")}));
            io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress ingress = ((IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((HTTPIngressRuleValueFluent)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressFluentImpl)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName(clusterId).addToAnnotations((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)annotMap).asJava()).addToLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)labelsMap).asJava())).endMetadata()).withNewSpec().addNewRule().withHost(domainName).withNewHttp().addNewPath().withPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "/", "/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nameSpace, clusterId}))).withNewBackend().withServiceName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-rest"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clusterId}))).withServicePort(new IntOrString("rest"))).endBackend()).endPath()).addNewPath().withPath(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nameSpace, clusterId}))).append((Object)"(/|$)(.*)").toString()).withNewBackend().withServiceName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-rest"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clusterId}))).withServicePort(new IntOrString("rest"))).endBackend()).endPath()).endHttp()).endRule()).endSpec()).build();
            ((InOutCreateable)client.network().ingress().inNamespace(nameSpace)).create((Object)ingress);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void configureIngress(String ingressOutput) {
        void var3_2;
        DefaultKubernetesClient[] defaultKubernetesClientArray = new DefaultKubernetesClient[1];
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        ((Gettable)client.network().ingress().load(Files.newInputStream(Paths.get(ingressOutput, new String[0]), new OpenOption[0]))).get();
        defaultKubernetesClientArray[0] = var3_2;
        Seq x$1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])defaultKubernetesClientArray));
        Function1 x$2 = Utils$.MODULE$.close$default$2(x$1);
        Utils$.MODULE$.close(x$1, x$2);
    }

    public void deleteIngress(String ingressName, String nameSpace) {
        if (this.determineThePodSurvivalStatus(ingressName, nameSpace)) {
            DefaultKubernetesClient[] defaultKubernetesClientArray = new DefaultKubernetesClient[1];
            DefaultKubernetesClient client = new DefaultKubernetesClient();
            ((Deletable)((Nameable)client.network().ingress().inNamespace(nameSpace)).withName(ingressName)).delete();
            defaultKubernetesClientArray[0] = client;
            Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])defaultKubernetesClientArray));
            Function1 x$4 = Utils$.MODULE$.close$default$2(x$3);
            Utils$.MODULE$.close(x$3, x$4);
        }
    }

    private boolean determineThePodSurvivalStatus(String name, String nameSpace) {
        KubernetesClient x$5 = KubernetesRetriever$.MODULE$.newK8sClient();
        Serializable x$6 = new Serializable(name, nameSpace){
            public static final long serialVersionUID = 0L;
            public final String name$1;
            public final String nameSpace$1;

            public final boolean apply(KubernetesClient client) {
                return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, client){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.2 $outer;
                    private final KubernetesClient client$1;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        ((Deployment)((Gettable)((Nameable)this.client$1.apps().deployments().inNamespace(this.$outer.nameSpace$1)).withName(this.$outer.name$1)).get()).getSpec().getSelector().getMatchLabels();
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.client$1 = client$1;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                }));
            }
            {
                this.name$1 = name$1;
                this.nameSpace$1 = nameSpace$1;
            }
        };
        Utils$.MODULE$.tryWithResource$default$3((AutoCloseable)x$5, (Function1)x$6);
        Object x$7 = null;
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithResource((AutoCloseable)x$5, (Function1)x$6, null));
    }

    /*
     * Enabled aggressive block sorting
     */
    public String ingressUrlAddress(String nameSpace, String clusterId, ClusterClient<?> clusterClient) {
        String string;
        if (!this.determineIfIngressExists(nameSpace, clusterId)) {
            string = clusterClient.getWebInterfaceURL();
            return string;
        }
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress ingress = (io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress)((Gettable)((Nameable)client.network().ingress().inNamespace(nameSpace)).withName(clusterId)).get();
        String publicEndpoints = (String)ingress.getMetadata().getAnnotations().get("field.cattle.io/publicEndpoints");
        Option<List<IngressMeta>> option = IngressMeta$.MODULE$.as(publicEndpoints);
        if (option instanceof Some) {
            String string2;
            Some some = (Some)option;
            List metas = (List)some.x();
            IngressMeta ingressMeta = (IngressMeta)metas.head();
            String hostname = ingressMeta.hostname();
            String path = ingressMeta.path();
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrieve flink cluster ", " successfully, JobManager Web Interface: https://", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clusterId, hostname, path})));
            string = string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https://", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostname, path}));
            return string;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new RuntimeException("[StreamPark] get ingressUrlAddress error.");
    }

    public boolean determineIfIngressExists(String nameSpace, String clusterId) {
        KubernetesClient x$8 = KubernetesRetriever$.MODULE$.newK8sClient();
        Serializable x$9 = new Serializable(nameSpace, clusterId){
            public static final long serialVersionUID = 0L;
            public final String nameSpace$2;
            public final String clusterId$1;

            public final boolean apply(KubernetesClient client) {
                return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(this, client){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;
                    private final KubernetesClient client$2;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        ((Ingress)((Gettable)((Nameable)this.client$2.extensions().ingresses().inNamespace(this.$outer.nameSpace$2)).withName(this.$outer.clusterId$1)).get()).getMetadata().getName();
                        return true;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.client$2 = client$2;
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                }));
            }
            {
                this.nameSpace$2 = nameSpace$2;
                this.clusterId$1 = clusterId$1;
            }
        };
        Utils$.MODULE$.tryWithResource$default$3((AutoCloseable)x$8, (Function1)x$9);
        Object x$10 = null;
        return BoxesRunTime.unboxToBoolean((Object)Utils$.MODULE$.tryWithResource((AutoCloseable)x$8, (Function1)x$9, null));
    }

    public String prepareIngressTemplateFiles(String buildWorkspace, String ingressTemplates) throws IOException {
        String string;
        File workspaceDir = new File(buildWorkspace);
        Object object = workspaceDir.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)workspaceDir.mkdir());
        if (ingressTemplates.isEmpty()) {
            string = null;
        } else {
            String outputPath = new StringBuilder().append((Object)buildWorkspace).append((Object)"/ingress.yaml").toString();
            File outputFile = new File(outputPath);
            FileUtils.write((File)outputFile, (CharSequence)ingressTemplates, (String)"UTF-8");
            string = outputPath;
        }
        return string;
    }

    private IngressController$() {
        MODULE$ = this;
        Logger.class.$init$((org.apache.streampark.common.util.Logger)this);
    }
}

