/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class IfExprLongColumnLongColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int arg1Column;
    private int arg2Column;
    private int arg3Column;
    private int outputColumn;

    public IfExprLongColumnLongColumn(int arg1Column, int arg2Column, int arg3Column, int outputColumn) {
        this.arg1Column = arg1Column;
        this.arg2Column = arg2Column;
        this.arg3Column = arg3Column;
        this.outputColumn = outputColumn;
    }

    public IfExprLongColumnLongColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        LongColumnVector arg2ColVector = (LongColumnVector)batch.cols[this.arg2Column];
        LongColumnVector arg3ColVector = (LongColumnVector)batch.cols[this.arg3Column];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = arg2ColVector.noNulls && arg3ColVector.noNulls;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        long[] vector2 = arg2ColVector.vector;
        long[] vector3 = arg3ColVector.vector;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        if (arg1ColVector.isRepeating) {
            if (vector1[0] == 1L) {
                arg2ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            } else {
                arg3ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            }
            return;
        }
        arg2ColVector.flatten(batch.selectedInUse, sel, n);
        arg3ColVector.flatten(batch.selectedInUse, sel, n);
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = (vector1[i] - 1L ^ 0xFFFFFFFFFFFFFFFFL) & vector2[i] | vector1[i] - 1L & vector3[i];
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = (vector1[i] - 1L ^ 0xFFFFFFFFFFFFFFFFL) & vector2[i] | vector1[i] - 1L & vector3[i];
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? vector2[i] : vector3[i];
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? vector2[i] : vector3[i];
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
            }
        }
        arg2ColVector.unFlatten();
        arg3ColVector.unFlatten();
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "long";
    }

    public int getArg1Column() {
        return this.arg1Column;
    }

    public void setArg1Column(int colNum) {
        this.arg1Column = colNum;
    }

    public int getArg2Column() {
        return this.arg2Column;
    }

    public void setArg2Column(int colNum) {
        this.arg2Column = colNum;
    }

    public int getArg3Column() {
        return this.arg3Column;
    }

    public void setArg3Column(int colNum) {
        this.arg3Column = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.arg1Column + ", col " + this.arg2Column + ", col " + this.arg3Column;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("int_date_interval_year_month"), VectorExpressionDescriptor.ArgumentType.getType("int_date_interval_year_month")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

