/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.sparkproject.dmg.pmml.Extension;
import org.sparkproject.dmg.pmml.FieldName;
import org.sparkproject.dmg.pmml.HasExtensions;
import org.sparkproject.dmg.pmml.HasFieldReference;
import org.sparkproject.dmg.pmml.Indexable;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.dmg.pmml.Visitor;
import org.sparkproject.dmg.pmml.VisitorAction;
import org.sparkproject.dmg.pmml.adapters.FieldNameAdapter;
import org.sparkproject.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="VerificationField", namespace="http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"field", "column", "precision", "zeroThreshold", "extensions"})
public class VerificationField
extends PMMLObject
implements HasExtensions<VerificationField>,
HasFieldReference<VerificationField>,
Indexable<FieldName> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="field")
    private FieldName field;
    @XmlAttribute(name="column")
    @JsonProperty(value="column")
    private String column;
    @XmlAttribute(name="precision")
    @JsonProperty(value="precision")
    private Double precision;
    @XmlAttribute(name="zeroThreshold")
    @JsonProperty(value="zeroThreshold")
    private Double zeroThreshold;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    private static final Double DEFAULT_PRECISION = 1.0E-6;
    private static final Double DEFAULT_ZERO_THRESHOLD = 1.0E-16;
    private static final long serialVersionUID = 67305485L;

    public VerificationField() {
    }

    public VerificationField(@Property(value="field") FieldName field) {
        this.field = field;
    }

    @Override
    public FieldName getKey() {
        return this.getField();
    }

    @Override
    public FieldName getField() {
        return this.field;
    }

    @Override
    public VerificationField setField(@Property(value="field") FieldName field) {
        this.field = field;
        return this;
    }

    public String getColumn() {
        return this.column;
    }

    public VerificationField setColumn(@Property(value="column") String column) {
        this.column = column;
        return this;
    }

    public Double getPrecision() {
        if (this.precision == null) {
            return DEFAULT_PRECISION;
        }
        return this.precision;
    }

    public VerificationField setPrecision(@Property(value="precision") Double precision) {
        this.precision = precision;
        return this;
    }

    public Double getZeroThreshold() {
        if (this.zeroThreshold == null) {
            return DEFAULT_ZERO_THRESHOLD;
        }
        return this.zeroThreshold;
    }

    public VerificationField setZeroThreshold(@Property(value="zeroThreshold") Double zeroThreshold) {
        this.zeroThreshold = zeroThreshold;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public VerificationField addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

