/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContextHolder;
import com.linecorp.armeria.common.DefaultContextAwareExecutor;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import java.util.Objects;
import java.util.concurrent.Executor;

public interface ContextAwareExecutor
extends ContextHolder,
Executor {
    public static ContextAwareExecutor of(RequestContext context, Executor executor) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(executor, "executor");
        if (executor instanceof ContextAwareExecutor) {
            RequestContextUtil.ensureSameCtx(context, (ContextAwareExecutor)executor, ContextAwareExecutor.class);
            return (ContextAwareExecutor)executor;
        }
        return new DefaultContextAwareExecutor(context, executor);
    }

    @Override
    public RequestContext context();

    public Executor withoutContext();
}

