/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataLabel;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class DataTable
implements StorageDataComplexObject<DataTable> {
    private HashMap<String, Long> data;

    public DataTable() {
        this.data = new HashMap();
    }

    public DataTable(int initialCapacity) {
        this.data = new HashMap(initialCapacity);
    }

    public DataTable(String data) {
        this();
        this.toObject(data);
    }

    public Long get(String key) {
        return this.data.get(key);
    }

    public void put(String key, Long value) {
        this.data.put(key, value);
    }

    public void put(DataLabel labels, Long value) {
        this.data.put(labels.toString(), value);
    }

    public void valueAccumulation(String key, Long value) {
        this.valueAccumulation(key, value, 0);
    }

    public void valueAccumulation(String key, Long value, int maxDataSize) {
        Long element = this.data.get(key);
        if (element == null) {
            if (maxDataSize > 0 && this.data.size() >= maxDataSize) {
                return;
            }
            element = value;
        } else {
            element = element + value;
        }
        this.data.put(key, element);
    }

    public long sumOfValues() {
        return this.data.values().stream().mapToLong(element -> element).sum();
    }

    public boolean keysEqual(DataTable that) {
        if (this.data.keySet().size() != that.data.keySet().size()) {
            return false;
        }
        return this.data.keySet().equals(that.data.keySet());
    }

    public List<String> sortedKeys(Comparator<String> keyComparator) {
        return this.data.keySet().stream().sorted(keyComparator).collect(Collectors.toList());
    }

    public List<Long> sortedValues(Comparator<String> keyComparator) {
        List<String> collect = this.data.keySet().stream().sorted(keyComparator).collect(Collectors.toList());
        ArrayList<Long> values = new ArrayList<Long>(collect.size());
        collect.forEach(key -> values.add(this.data.get(key)));
        return values;
    }

    public Set<String> keys() {
        return this.data.keySet();
    }

    public boolean hasData() {
        return !this.data.isEmpty();
    }

    public boolean hasKey(String key) {
        return this.data.containsKey(key);
    }

    public int size() {
        return this.data.size();
    }

    @Override
    public String toStorageData() {
        StringBuilder builder = new StringBuilder();
        this.data.forEach((key, value) -> {
            if (builder.length() != 0) {
                builder.append("|");
            }
            builder.append((String)key).append(",").append(value);
        });
        return builder.toString();
    }

    @Override
    public void toObject(String data) {
        String[] keyValues;
        for (String keyValue : keyValues = data.split("\\|")) {
            int i = keyValue.lastIndexOf(",");
            if (i <= 0) continue;
            String key = keyValue.substring(0, i);
            String value = keyValue.substring(i + 1);
            if (!StringUtil.isNotEmpty((String)key) || !StringUtil.isNotEmpty((String)value)) continue;
            this.data.put(key, Long.parseLong(value));
        }
    }

    @Override
    public void copyFrom(DataTable source) {
        this.append(source);
    }

    public DataTable append(DataTable dataTable) {
        return this.append(dataTable, 0);
    }

    public DataTable append(DataTable dataTable, int maxDataSize) {
        dataTable.data.forEach((key, value) -> {
            Long current = this.data.get(key);
            if (current == null) {
                if (maxDataSize > 0 && this.data.size() >= maxDataSize) {
                    return;
                }
                current = value;
            } else {
                current = current + value;
            }
            this.data.put((String)key, current);
        });
        return this;
    }

    public DataTable setMaxValue(DataTable dataTable) {
        dataTable.data.forEach((key, value) -> {
            Long current = this.data.get(key);
            if (current == null) {
                current = value;
            } else if (current < value) {
                current = value;
            }
            this.data.put((String)key, current);
        });
        return this;
    }

    public DataTable setMinValue(DataTable dataTable) {
        dataTable.data.forEach((key, value) -> {
            Long current = this.data.get(key);
            if (current == null) {
                current = value;
            } else if (current > value) {
                current = value;
            }
            this.data.put((String)key, current);
        });
        return this;
    }

    public Map<String, Set<String>> buildLabelIndex() {
        HashMap<String, Set<String>> labelIndex = new HashMap<String, Set<String>>();
        for (String key : this.data.keySet()) {
            if (key.startsWith("{")) {
                String[] labelsArr;
                String labels = key.substring(1, key.length() - 1);
                if (!StringUtil.isNotEmpty((String)labels)) continue;
                for (String label : labelsArr = labels.split(",")) {
                    labelIndex.computeIfAbsent(label, keys -> new HashSet()).add(key);
                }
                continue;
            }
            labelIndex.computeIfAbsent("_=" + key, keys -> new HashSet()).add(key);
        }
        return labelIndex;
    }

    @Generated
    public String toString() {
        return "DataTable(data=" + this.data + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataTable)) {
            return false;
        }
        DataTable other = (DataTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HashMap<String, Long> this$data = this.data;
        HashMap<String, Long> other$data = other.data;
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataTable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HashMap<String, Long> $data = this.data;
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }
}

