/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.rt.parser;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.BooleanValueFilterMatcher;
import org.apache.skywalking.oap.server.core.analysis.metrics.annotation.FilterMatcher;

public enum FilterMatchers {
    INSTANCE;

    private final Map<String, MatcherInfo> matchersKeyedByType = new HashMap<String, MatcherInfo>();

    private FilterMatchers() {
        try {
            this.init();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void init() throws IOException {
        ClassPath classpath = ClassPath.from((ClassLoader)FilterMatchers.class.getClassLoader());
        ImmutableSet classes = classpath.getTopLevelClassesRecursive("org.apache.skywalking");
        for (ClassPath.ClassInfo classInfo : classes) {
            Class clazz = classInfo.load();
            FilterMatcher plainFilterMatcher = clazz.getAnnotation(FilterMatcher.class);
            BooleanValueFilterMatcher booleanFilterMatcher = clazz.getAnnotation(BooleanValueFilterMatcher.class);
            if (plainFilterMatcher != null && booleanFilterMatcher != null) {
                throw new IllegalStateException("A matcher class can not be annotated with both @FilterMatcher and @BooleanValueFilterMatcher");
            }
            if (plainFilterMatcher != null) {
                for (String type : plainFilterMatcher.value()) {
                    this.matchersKeyedByType.put(type, new MatcherInfo(clazz, false));
                }
                if (plainFilterMatcher.value().length == 0) {
                    String string = StringUtils.uncapitalize((String)clazz.getSimpleName());
                    this.matchersKeyedByType.put(string, new MatcherInfo(clazz, false));
                }
            }
            if (booleanFilterMatcher == null) continue;
            for (String type : booleanFilterMatcher.value()) {
                this.matchersKeyedByType.put(type, new MatcherInfo(clazz, true));
            }
            if (booleanFilterMatcher.value().length != 0) continue;
            String string = StringUtils.uncapitalize((String)clazz.getSimpleName());
            this.matchersKeyedByType.put(string, new MatcherInfo(clazz, true));
        }
    }

    public MatcherInfo find(String type) {
        if (!this.matchersKeyedByType.containsKey(type)) {
            throw new IllegalArgumentException("filter expression [" + type + "] not found");
        }
        return this.matchersKeyedByType.get(type);
    }

    public static class MatcherInfo {
        private final Class<?> matcher;
        private final boolean isBooleanType;

        @Generated
        public Class<?> getMatcher() {
            return this.matcher;
        }

        @Generated
        public boolean isBooleanType() {
            return this.isBooleanType;
        }

        @Generated
        public MatcherInfo(Class<?> matcher, boolean isBooleanType) {
            this.matcher = matcher;
            this.isBooleanType = isBooleanType;
        }
    }
}

