/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.RowEntity;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventTraceType;
import org.apache.skywalking.oap.server.core.storage.query.ISpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBSpanAttachedEventQueryDAO
extends AbstractBanyanDBDAO
implements ISpanAttachedEventQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"start_time_second", (Object)"start_time_nanos", (Object)"event", (Object)"end_time_second", (Object)"end_time_nanos", (Object)"trace_ref_type", (Object[])new String[]{"related_trace_id", "trace_segment_id", "trace_span_id", "data_binary", "timestamp"});
    private final int batchSize;

    public BanyanDBSpanAttachedEventQueryDAO(BanyanDBStorageClient client, int profileDataQueryBatchSize) {
        super(client);
        this.batchSize = profileDataQueryBatchSize;
    }

    public List<SpanAttachedEventRecord> querySpanAttachedEvents(final SpanAttachedEventTraceType type, final List<String> traceIds) throws IOException {
        StreamQueryResponse resp = this.queryDebuggable("span_attached_event_record", TAGS, null, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            protected void apply(StreamQuery query) {
                query.and(this.in("related_trace_id", traceIds));
                query.and(this.eq("trace_ref_type", type.value()));
                query.setOrderBy(new AbstractQuery.OrderBy(AbstractQuery.Sort.ASC));
                query.setLimit(BanyanDBSpanAttachedEventQueryDAO.this.batchSize);
            }
        });
        return resp.getElements().stream().map(this::buildRecord).collect(Collectors.toList());
    }

    private SpanAttachedEventRecord buildRecord(RowEntity row) {
        SpanAttachedEventRecord.Builder builder = new SpanAttachedEventRecord.Builder();
        return builder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToStream("span_attached_event_record", row));
    }
}

