/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.stream;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.Element;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLog;
import org.apache.skywalking.oap.server.core.query.type.ProfileTaskLogOperationType;
import org.apache.skywalking.oap.server.core.storage.profiling.trace.IProfileTaskLogQueryDAO;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBProfileTaskLogQueryDAO
extends AbstractBanyanDBDAO
implements IProfileTaskLogQueryDAO {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"operation_time", (Object)"instance_id", (Object)"task_id", (Object)"operation_type");
    private final int queryMaxSize;

    public BanyanDBProfileTaskLogQueryDAO(BanyanDBStorageClient client, int profileTaskQueryMaxSize) {
        super(client);
        this.queryMaxSize = profileTaskQueryMaxSize * 50;
    }

    public List<ProfileTaskLog> getTaskLogList() throws IOException {
        StreamQueryResponse resp = this.query("profile_task_log", TAGS, new AbstractBanyanDBDAO.QueryBuilder<StreamQuery>(){

            @Override
            public void apply(StreamQuery query) {
                query.setLimit(BanyanDBProfileTaskLogQueryDAO.this.queryMaxSize);
            }
        });
        LinkedList<ProfileTaskLog> tasks = new LinkedList<ProfileTaskLog>();
        for (Element element : resp.getElements()) {
            tasks.add(this.buildProfileTaskLog(element));
        }
        return tasks;
    }

    private ProfileTaskLog buildProfileTaskLog(Element data) {
        return ProfileTaskLog.builder().id(data.getId()).taskId((String)data.getTagValue("task_id")).instanceId((String)data.getTagValue("instance_id")).operationType(ProfileTaskLogOperationType.parse((int)((Number)data.getTagValue("operation_type")).intValue())).operationTime(((Number)data.getTagValue("operation_time")).longValue()).build();
    }
}

