/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.FunctionCategory;
import org.apache.skywalking.oap.server.core.storage.model.Model;
import org.apache.skywalking.oap.server.core.storage.model.ModelColumn;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum IndexController {
    INSTANCE;

    @Generated
    private static final Logger log;
    private boolean logicSharding = false;
    private boolean enableCustomRouting = false;

    public String getTableName(Model model) {
        if (!model.isTimeSeries()) {
            return "management";
        }
        if (!this.logicSharding) {
            return model.isMetric() ? "metrics-all" : (model.isRecord() && !model.isSuperDataset() ? "records-all" : model.getName());
        }
        String aggFuncName = FunctionCategory.uniqueFunctionName((Class)model.getStreamClass());
        return StringUtil.isNotBlank((String)aggFuncName) ? aggFuncName : model.getName();
    }

    public String generateDocId(Model model, String originalID) {
        if (!model.isTimeSeries()) {
            return this.generateDocId(model.getName(), originalID);
        }
        if (!this.logicSharding && model.isRecord() && !model.isSuperDataset()) {
            return this.generateDocId(model.getName(), originalID);
        }
        if (!model.isMetric()) {
            return originalID;
        }
        if (this.logicSharding && !this.isFunctionMetric(model)) {
            return originalID;
        }
        return this.generateDocId(model.getName(), originalID);
    }

    public String generateDocId(String logicTableName, String originalID) {
        return logicTableName + "_" + originalID;
    }

    public boolean isFunctionMetric(Model model) {
        return StringUtil.isNotBlank((String)FunctionCategory.uniqueFunctionName((Class)model.getStreamClass()));
    }

    public Map<String, Object> appendTableColumn(Model model, Map<String, Object> columns) {
        if (!this.isLogicSharding() && model.isMetric() || this.isLogicSharding() && this.isFunctionMetric(model)) {
            columns.put("metric_table", model.getName());
        }
        if (!this.logicSharding && model.isRecord() && !model.isSuperDataset()) {
            columns.put("record_table", model.getName());
        }
        return columns;
    }

    public Map<String, Object> appendTableColumn4ManagementData(String modelName, Map<String, Object> columns) {
        columns.put("management_table", modelName);
        return columns;
    }

    @Generated
    public void setLogicSharding(boolean logicSharding) {
        this.logicSharding = logicSharding;
    }

    @Generated
    public boolean isLogicSharding() {
        return this.logicSharding;
    }

    @Generated
    public void setEnableCustomRouting(boolean enableCustomRouting) {
        this.enableCustomRouting = enableCustomRouting;
    }

    @Generated
    public boolean isEnableCustomRouting() {
        return this.enableCustomRouting;
    }

    static {
        log = LoggerFactory.getLogger(IndexController.class);
    }

    public static class LogicIndicesRegister {
        private static final Map<String, String> LOGIC_INDICES_CATALOG = new HashMap<String, String>();
        private static final Map<String, Map<String, ModelColumn>> PHYSICAL_INDICES_COLUMNS = new HashMap<String, Map<String, ModelColumn>>();
        private static final Map<String, Map<String, String>> LEGACY_COLUMNS_NAMES = new HashMap<String, Map<String, String>>();
        public static final String METRIC_TABLE_NAME = "metric_table";
        public static final String RECORD_TABLE_NAME = "record_table";
        public static final String MANAGEMENT_TABLE_NAME = "management_table";

        public static String getPhysicalTableName(String logicName) {
            return Optional.ofNullable(LOGIC_INDICES_CATALOG.get(logicName)).orElse(logicName);
        }

        public static void registerRelation(Model model, String physicalName) {
            LOGIC_INDICES_CATALOG.put(model.getName(), physicalName);
            Map columns = PHYSICAL_INDICES_COLUMNS.computeIfAbsent(physicalName, v -> new HashMap());
            if (!IndexController.INSTANCE.logicSharding || !model.isTimeSeries()) {
                model.getColumns().forEach(modelColumn -> {
                    String columnName = modelColumn.getColumnName().getName();
                    if (columns.containsKey(columnName)) {
                        LogicIndicesRegister.checkModelColumnConflicts((ModelColumn)columns.get(columnName), modelColumn, physicalName);
                    } else {
                        columns.put(columnName, modelColumn);
                    }
                });
            } else {
                model.getColumns().forEach(modelColumn -> {
                    String columnName = modelColumn.getColumnName().getName();
                    String legacyName = modelColumn.getElasticSearchExtension().getLegacyColumnName();
                    if (!Strings.isNullOrEmpty((String)legacyName)) {
                        Map legacyNames = LEGACY_COLUMNS_NAMES.computeIfAbsent(model.getName(), v -> new HashMap());
                        legacyNames.put(modelColumn.getColumnName().getName(), legacyName);
                        columnName = legacyName;
                    }
                    if (columns.containsKey(columnName)) {
                        LogicIndicesRegister.checkModelColumnConflicts((ModelColumn)columns.get(columnName), modelColumn, physicalName);
                    } else {
                        columns.put(columnName, modelColumn);
                    }
                });
            }
        }

        public static boolean isMergedTable(String logicName) {
            return !LogicIndicesRegister.getPhysicalTableName(logicName).equals(logicName);
        }

        public static List<ModelColumn> getPhysicalTableColumns(Model model) {
            String tableName = LogicIndicesRegister.getPhysicalTableName(model.getName());
            return new ArrayList<ModelColumn>(PHYSICAL_INDICES_COLUMNS.get(tableName).values());
        }

        @Deprecated
        public static String getPhysicalColumnName(String modelName, String columnName) {
            if (!IndexController.INSTANCE.logicSharding) {
                return columnName;
            }
            Map<String, String> legacyNames = LEGACY_COLUMNS_NAMES.get(modelName);
            if (CollectionUtils.isEmpty(legacyNames)) {
                return columnName;
            }
            return legacyNames.getOrDefault(columnName, columnName);
        }

        private static void checkModelColumnConflicts(ModelColumn mc1, ModelColumn mc2, String physicalName) {
            if (mc1.isIndexOnly() != mc2.isIndexOnly()) {
                throw new IllegalArgumentException(mc1.getColumnName() + " and " + mc2.getColumnName() + " isIndexOnly conflict in index: " + physicalName);
            }
            if (mc1.isStorageOnly() != mc2.isStorageOnly()) {
                throw new IllegalArgumentException(mc1.getColumnName() + " and " + mc2.getColumnName() + " isStorageOnly conflict in index: " + physicalName);
            }
            if (!mc1.getType().equals(mc2.getType())) {
                throw new IllegalArgumentException(mc1.getColumnName() + " and " + mc2.getColumnName() + " Class type conflict in index: " + physicalName);
            }
            if (mc1.getElasticSearchExtension().needMatchQuery() != mc2.getElasticSearchExtension().needMatchQuery()) {
                throw new IllegalArgumentException(mc1.getColumnName() + " and " + mc2.getColumnName() + " needMatchQuery conflict in index: " + physicalName);
            }
        }
    }
}

