/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.extension.visualizationEffect;

import java.awt.Color;
import org.apache.log4j.Logger;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.sedona.viz.core.VisualizationOperator;
import org.apache.sedona.viz.extension.photoFilter.GaussianBlur;
import org.apache.sedona.viz.utils.ColorizeOption;
import org.apache.spark.api.java.JavaSparkContext;
import org.locationtech.jts.geom.Envelope;

public class HeatMap
extends VisualizationOperator {
    static final Logger logger = Logger.getLogger(HeatMap.class);

    public HeatMap(int resolutionX, int resolutionY, Envelope datasetBoundary, boolean reverseSpatialCoordinate, int blurRadius) {
        super(resolutionX, resolutionY, datasetBoundary, ColorizeOption.SPATIALAGGREGATION, reverseSpatialCoordinate, -1, -1, false, false, false);
        GaussianBlur gaussianBlur = new GaussianBlur(blurRadius);
        this.InitPhotoFilterWeightMatrix(gaussianBlur);
    }

    public HeatMap(int resolutionX, int resolutionY, Envelope datasetBoundary, boolean reverseSpatialCoordinate, int blurRadius, int partitionX, int partitionY, boolean parallelPhotoFilter, boolean parallelRenderImage) {
        super(resolutionX, resolutionY, datasetBoundary, ColorizeOption.SPATIALAGGREGATION, reverseSpatialCoordinate, partitionX, partitionY, parallelPhotoFilter, parallelRenderImage, false);
        GaussianBlur gaussianBlur = new GaussianBlur(blurRadius);
        this.InitPhotoFilterWeightMatrix(gaussianBlur);
    }

    @Override
    protected Integer EncodeToRGB(int normalizedCount) throws Exception {
        int alpha = 150;
        Color[] colors = new Color[]{new Color(153, 255, 0, alpha), new Color(204, 255, 0, alpha), new Color(255, 255, 0, alpha), new Color(255, 204, 0, alpha), new Color(255, 153, 0, alpha), new Color(255, 102, 0, alpha), new Color(255, 51, 0, alpha), new Color(255, 0, 0, alpha)};
        if (normalizedCount < 1) {
            return new Color(255, 255, 255, 0).getRGB();
        }
        if (normalizedCount < 30) {
            return colors[0].getRGB();
        }
        if (normalizedCount < 50) {
            return colors[1].getRGB();
        }
        if (normalizedCount < 70) {
            return colors[2].getRGB();
        }
        if (normalizedCount < 100) {
            return colors[3].getRGB();
        }
        if (normalizedCount < 130) {
            return colors[4].getRGB();
        }
        if (normalizedCount < 160) {
            return colors[5].getRGB();
        }
        if (normalizedCount < 190) {
            return colors[6].getRGB();
        }
        return colors[7].getRGB();
    }

    public boolean Visualize(JavaSparkContext sparkContext, SpatialRDD spatialRDD) throws Exception {
        logger.info((Object)"[Sedona-Viz][Visualize][Start]");
        this.CustomizeColor(255, 255, 0, 255, Color.GREEN, true);
        this.Rasterize(sparkContext, spatialRDD, true);
        this.ApplyPhotoFilter(sparkContext);
        this.Colorize();
        this.RenderImage(sparkContext);
        logger.info((Object)"[Sedona-Viz][Visualize][Stop]");
        return true;
    }
}

