/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.datasources.shapefile;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.sedona.core.formatMapper.shapefileParser.parseUtils.dbf.FieldDescriptor;
import org.apache.sedona.sql.datasources.shapefile.ShapefileReadOptions;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ShapefileUtils$ {
    public static ShapefileUtils$ MODULE$;
    private final Set<String> shapeFileExtensions;
    private final Set<String> mandatoryFileExtensions;

    static {
        new ShapefileUtils$();
    }

    public Set<String> shapeFileExtensions() {
        return this.shapeFileExtensions;
    }

    public Set<String> mandatoryFileExtensions() {
        return this.mandatoryFileExtensions;
    }

    public Option<StructType> mergeSchemas(Seq<StructType> schemas) {
        None$ none$;
        if (schemas.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            ObjectRef mergedSchema = ObjectRef.create((Object)((StructType)schemas.head()));
            ((IterableLike)schemas.tail()).foreach((Function1 & Serializable & scala.Serializable)schema -> {
                ShapefileUtils$.$anonfun$mergeSchemas$1(mergedSchema, schema);
                return BoxedUnit.UNIT;
            });
            none$ = new Some((Object)((StructType)mergedSchema.elem));
        }
        return none$;
    }

    private StructType mergeSchema(StructType schema1, StructType schema2) {
        Map fieldMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema1.fields())).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name().toLowerCase(Locale.ROOT)), f), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        ObjectRef newFields = ObjectRef.create((Object)schema1.fields());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema2.fields())).foreach((Function1 & Serializable & scala.Serializable)f -> {
            ShapefileUtils$.$anonfun$mergeSchema$2(fieldMap, newFields, f);
            return BoxedUnit.UNIT;
        });
        return new StructType((StructField[])newFields.elem);
    }

    public Seq<StructField> fieldDescriptorsToStructFields(Seq<FieldDescriptor> fieldDescriptors) {
        return (Seq)fieldDescriptors.map((Function1 & Serializable & scala.Serializable)desc -> {
            StringType$ stringType$;
            String name = desc.getFieldName();
            byte by = desc.getFieldType();
            switch (by) {
                case 67: {
                    stringType$ = StringType$.MODULE$;
                    break;
                }
                case 70: 
                case 78: {
                    byte scale = desc.getFieldDecimalCount();
                    if (scale == 0) {
                        stringType$ = LongType$.MODULE$;
                        break;
                    }
                    int precision = desc.getFieldLength();
                    stringType$ = new DecimalType(precision, (int)scale);
                    break;
                }
                case 76: {
                    stringType$ = BooleanType$.MODULE$;
                    break;
                }
                case 68: {
                    stringType$ = DateType$.MODULE$;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Unsupported field type ").append(desc.getFieldType()).toString());
                }
            }
            StringType$ dataType = stringType$;
            return new StructField(name, (DataType)dataType, true, StructField$.MODULE$.apply$default$4());
        }, Seq$.MODULE$.canBuildFrom());
    }

    public StructType fieldDescriptorsToSchema(Seq<FieldDescriptor> fieldDescriptors) {
        Seq<StructField> structFields = this.fieldDescriptorsToStructFields(fieldDescriptors);
        return StructType$.MODULE$.apply(structFields);
    }

    public StructType fieldDescriptorsToSchema(Seq<FieldDescriptor> fieldDescriptors, ShapefileReadOptions options, Function2<String, String, Object> resolver) {
        String geometryFieldName;
        Seq<StructField> structFields = this.fieldDescriptorsToStructFields(fieldDescriptors);
        if (structFields.exists(arg_0 -> ShapefileUtils$.$anonfun$fieldDescriptorsToSchema$1$adapted(resolver, geometryFieldName = options.geometryFieldName(), arg_0))) {
            throw new IllegalArgumentException(new StringBuilder(160).append("Field name ").append(geometryFieldName).append(" is reserved for geometry but appears in non-spatial attributes. ").append("Please specify a different field name for geometry using the 'geometry.name' option.").toString());
        }
        options.keyFieldName().foreach((Function1 & Serializable & scala.Serializable)name -> {
            ShapefileUtils$.$anonfun$fieldDescriptorsToSchema$2(structFields, resolver, name);
            return BoxedUnit.UNIT;
        });
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.baseSchema(options, (Option<Function2<String, String, Object>>)new Some(resolver)).fields())).$plus$plus(structFields, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public StructType baseSchema(ShapefileReadOptions options, Option<Function2<String, String, Object>> resolver) {
        StructType structType;
        Option<String> option = options.keyFieldName();
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            if (resolver.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ShapefileUtils$.$anonfun$baseSchema$1(name, options, x$1)))) {
                throw new IllegalArgumentException("geometry.name and key.name cannot be the same");
            }
            structType = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField(options.geometryFieldName(), (DataType)GeometryUDT$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField(name, (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)));
        } else {
            StructField structField = new StructField(options.geometryFieldName(), (DataType)GeometryUDT$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            structType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
        }
        return structType;
    }

    public Option<Function2<String, String, Object>> baseSchema$default$2() {
        return None$.MODULE$;
    }

    public Function1<byte[], Object> fieldValueConverter(FieldDescriptor desc, Option<String> cpg) {
        Function1 & Serializable & scala.Serializable intersect;
        byte by = desc.getFieldType();
        switch (by) {
            case 67: {
                String encoding = (String)cpg.getOrElse((Function0 & Serializable & scala.Serializable)() -> "ISO-8859-1");
                String string = encoding.toLowerCase(Locale.ROOT);
                String string2 = "utf-8";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    intersect = (Function1 & Serializable & scala.Serializable)bytes -> UTF8String.fromBytes((byte[])bytes).trimRight();
                    break;
                }
                intersect = (Function1 & Serializable & scala.Serializable)bytes -> {
                    String str = new String((byte[])bytes, encoding);
                    return UTF8String.fromString((String)str).trimRight();
                };
                break;
            }
            case 70: 
            case 78: {
                byte scale = desc.getFieldDecimalCount();
                if (scale == 0) {
                    intersect = (Function1 & Serializable & scala.Serializable)bytes -> {
                        Long l;
                        try {
                            l = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(new String((byte[])bytes, StandardCharsets.ISO_8859_1).trim())).toLong());
                        }
                        catch (Exception exception) {
                            l = null;
                        }
                        return l;
                    };
                    break;
                }
                intersect = (Function1 & Serializable & scala.Serializable)bytes -> {
                    Decimal decimal;
                    try {
                        decimal = Decimal$.MODULE$.fromString(UTF8String.fromBytes((byte[])bytes));
                    }
                    catch (Exception exception) {
                        decimal = null;
                    }
                    return decimal;
                };
                break;
            }
            case 76: {
                intersect = (Function1 & Serializable & scala.Serializable)bytes -> {
                    Boolean bl;
                    if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
                        bl = null;
                    } else {
                        byte by = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).head());
                        switch (by) {
                            case 84: 
                            case 89: 
                            case 116: 
                            case 121: {
                                bl = BoxesRunTime.boxToBoolean((boolean)true);
                                break;
                            }
                            case 70: 
                            case 78: 
                            case 102: 
                            case 110: {
                                bl = BoxesRunTime.boxToBoolean((boolean)false);
                                break;
                            }
                            default: {
                                bl = null;
                                break;
                            }
                        }
                    }
                    return bl;
                };
                break;
            }
            case 68: {
                intersect = (Function1 & Serializable & scala.Serializable)bytes -> {
                    Integer n;
                    try {
                        String dateString = new String((byte[])bytes, StandardCharsets.ISO_8859_1);
                        DateTimeFormatter formatter = DateTimeFormatter.BASIC_ISO_DATE;
                        LocalDate date = LocalDate.parse(dateString, formatter);
                        n = BoxesRunTime.boxToInteger((int)((int)date.toEpochDay()));
                    }
                    catch (Exception exception) {
                        n = null;
                    }
                    return n;
                };
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(23).append("Unsupported field type ").append(desc.getFieldType()).toString());
            }
        }
        return intersect;
    }

    public static final /* synthetic */ void $anonfun$mergeSchemas$1(ObjectRef mergedSchema$1, StructType schema) {
        try {
            mergedSchema$1.elem = MODULE$.mergeSchema((StructType)mergedSchema$1.elem, schema);
        }
        catch (IllegalArgumentException cause) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Failed to merge schema ").append((StructType)mergedSchema$1.elem).append(" with ").append(schema).toString(), cause);
        }
    }

    public static final /* synthetic */ void $anonfun$mergeSchema$2(Map fieldMap$1, ObjectRef newFields$1, StructField f) {
        Option option = fieldMap$1.get((Object)f.name().toLowerCase(Locale.ROOT));
        if (option instanceof Some) {
            Some some = (Some)option;
            StructField existingField = (StructField)some.value();
            DataType dataType = existingField.dataType();
            DataType dataType2 = f.dataType();
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                throw new IllegalArgumentException(new StringBuilder(74).append("Failed to merge fields ").append(existingField.name()).append(" and ").append(f.name()).append(" because they have different data types: ").append(existingField.dataType()).append(" and ").append(f.dataType()).toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            newFields$1.elem = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((StructField[])newFields$1.elem))).$colon$plus((Object)f, ClassTag$.MODULE$.apply(StructField.class));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$fieldDescriptorsToSchema$1(Function2 resolver$1, String geometryFieldName$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)geometryFieldName$1));
    }

    public static final /* synthetic */ boolean $anonfun$fieldDescriptorsToSchema$3(Function2 resolver$1, String name$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)name$1));
    }

    public static final /* synthetic */ void $anonfun$fieldDescriptorsToSchema$2(Seq structFields$1, Function2 resolver$1, String name) {
        if (structFields$1.exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ShapefileUtils$.$anonfun$fieldDescriptorsToSchema$3(resolver$1, name, f)))) {
            throw new IllegalArgumentException(new StringBuilder(157).append("Field name ").append(name).append(" is reserved for shape key but appears in non-spatial attributes. ").append("Please specify a different field name for shape key using the 'key.name' option.").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$baseSchema$1(String name$2, ShapefileReadOptions options$1, Function2 x$1) {
        return BoxesRunTime.unboxToBoolean((Object)x$1.apply((Object)name$2, (Object)options$1.geometryFieldName()));
    }

    private ShapefileUtils$() {
        MODULE$ = this;
        this.shapeFileExtensions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"shp", "shx", "dbf", "cpg", "prj"}));
        this.mandatoryFileExtensions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"shp"}));
    }

    public static final /* synthetic */ Object $anonfun$fieldDescriptorsToSchema$1$adapted(Function2 resolver$1, String geometryFieldName$1, StructField f) {
        return BoxesRunTime.boxToBoolean((boolean)ShapefileUtils$.$anonfun$fieldDescriptorsToSchema$1(resolver$1, geometryFieldName$1, f));
    }
}

