/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.units.requests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.internal.scopes.ASFileScope;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.scopes.IASScope;
import org.apache.royale.compiler.units.requests.IFileScopeRequestResult;

public class FileScopeRequestResultBase
implements IFileScopeRequestResult {
    private static IASScope[] EMPTY_SCOPES = new IASScope[0];
    private static ASFileScope[] EMPTY_FILE_SCOPES = new ASFileScope[0];
    private Collection<ICompilerProblem> problems;
    private final IASScope[] scopes;
    private final ASFileScope[] fileScopes;
    protected final Collection<IDefinition> definitions;

    private static Collection<ICompilerProblem> getProblemCollection(Collection<ICompilerProblem> problems) {
        if (problems != null && !problems.isEmpty()) {
            return problems;
        }
        return Collections.emptyList();
    }

    private static IASScope[] getScopesArray(Collection<? extends IASScope> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            return EMPTY_SCOPES;
        }
        return scopes.toArray(new IASScope[scopes.size()]);
    }

    private static ASFileScope[] getFileScopesArray(Collection<? extends IASScope> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            return EMPTY_FILE_SCOPES;
        }
        LinkedList<ASFileScope> fileScopes = new LinkedList<ASFileScope>();
        for (IASScope iASScope : scopes) {
            if (!(iASScope instanceof ASFileScope)) continue;
            fileScopes.add((ASFileScope)iASScope);
        }
        return fileScopes.toArray(new ASFileScope[fileScopes.size()]);
    }

    public FileScopeRequestResultBase(Collection<ICompilerProblem> problems, Collection<? extends IASScope> scopes) {
        this.problems = FileScopeRequestResultBase.getProblemCollection(problems);
        this.scopes = FileScopeRequestResultBase.getScopesArray(scopes);
        this.fileScopes = FileScopeRequestResultBase.getFileScopesArray(scopes);
        this.definitions = new HashSet<IDefinition>();
        for (ASFileScope scope : this.fileScopes) {
            scope.collectExternallyVisibleDefinitions(this.definitions, false);
        }
    }

    @Override
    public ICompilerProblem[] getProblems() {
        return this.problems.toArray(new ICompilerProblem[this.problems.size()]);
    }

    @Override
    public IASScope[] getScopes() {
        return this.scopes;
    }

    public ASFileScope[] getFileScopes() {
        return this.fileScopes;
    }

    @Override
    public IDefinition getMainDefinition(String qname) {
        return null;
    }

    @Override
    public Collection<IDefinition> getExternallyVisibleDefinitions() {
        return this.definitions;
    }

    protected void addProblems(Collection<ICompilerProblem> newProblems) {
        if (this.problems.isEmpty()) {
            this.problems = new ArrayList<ICompilerProblem>(newProblems.size());
        }
        this.problems.addAll(newProblems);
    }

    @Override
    public Collection<ICompilerProblem> checkExternallyVisibleDefinitions(String dottedQName) {
        return Collections.emptyList();
    }
}

