/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.ServerMessageMutator;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MessageDeliveryPriority;
import org.apache.qpid.server.protocol.v0_10.transport.MessageProperties;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;

public class MessageTransferMessageMutator
implements ServerMessageMutator<MessageTransferMessage> {
    private final MessageTransferMessage _message;
    private final MessageStore _messageStore;
    private final MessageProperties _messageProperties;
    private DeliveryProperties _deliveryProperties;

    MessageTransferMessageMutator(MessageTransferMessage message, MessageStore messageStore) {
        this._message = message;
        this._messageStore = messageStore;
        MessageProperties messageProperties = message.getHeader().getMessageProperties();
        this._messageProperties = messageProperties == null ? null : new MessageProperties(messageProperties);
        DeliveryProperties deliveryProperties = this._message.getHeader().getDeliveryProperties();
        DeliveryProperties properties = null;
        if (deliveryProperties != null) {
            properties = new DeliveryProperties();
            if (deliveryProperties.hasDeliveryMode()) {
                properties.setDeliveryMode(deliveryProperties.getDeliveryMode());
            }
            if (deliveryProperties.hasDiscardUnroutable()) {
                properties.setDiscardUnroutable(deliveryProperties.getDiscardUnroutable());
            }
            if (deliveryProperties.hasExchange()) {
                properties.setExchange(deliveryProperties.getExchange());
            }
            if (deliveryProperties.hasExpiration()) {
                properties.setExpiration(deliveryProperties.getExpiration());
            }
            if (deliveryProperties.hasTtl()) {
                properties.setTtl(deliveryProperties.getTtl());
            }
            if (deliveryProperties.hasImmediate()) {
                properties.setImmediate(deliveryProperties.getImmediate());
            }
            if (deliveryProperties.hasPriority()) {
                properties.setPriority(deliveryProperties.getPriority());
            }
            if (deliveryProperties.hasRedelivered()) {
                properties.setRedelivered(deliveryProperties.getRedelivered());
            }
            if (deliveryProperties.hasResumeId()) {
                properties.setResumeId(deliveryProperties.getResumeId());
            }
            if (deliveryProperties.hasResumeTtl()) {
                properties.setResumeTtl(deliveryProperties.getResumeTtl());
            }
            if (deliveryProperties.hasRoutingKey()) {
                properties.setRoutingKey(deliveryProperties.getRoutingKey());
            }
            if (deliveryProperties.hasTimestamp()) {
                properties.setTimestamp(deliveryProperties.getTimestamp());
            }
        }
        this._deliveryProperties = properties;
    }

    public void setPriority(byte priority) {
        if (this._deliveryProperties == null) {
            this._deliveryProperties = new DeliveryProperties();
        }
        this._deliveryProperties.setPriority(MessageDeliveryPriority.get(priority));
    }

    public byte getPriority() {
        MessageDeliveryPriority priority = this._deliveryProperties == null || !this._deliveryProperties.hasPriority() ? MessageDeliveryPriority.MEDIUM : this._deliveryProperties.getPriority();
        return (byte)priority.getValue();
    }

    public MessageTransferMessage create() {
        Header header = new Header(this._deliveryProperties, this._messageProperties);
        MessageMetaData_0_10 messageMetaData = new MessageMetaData_0_10(header, (int)this._message.getSize(), this._message.getArrivalTime());
        QpidByteBuffer content = this._message.getContent();
        MessageHandle addedMessage = this._messageStore.addMessage((StorableMessageMetaData)messageMetaData);
        if (content != null) {
            addedMessage.addContent(content);
        }
        return new MessageTransferMessage((StoredMessage<MessageMetaData_0_10>)addedMessage.allContentAdded(), this._message.getConnectionReference());
    }
}

