/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.Reader;
import org.apache.derby.iapi.services.io.Limit;

public final class LimitReader
extends Reader
implements Limit {
    private int remainingCharacters;
    private boolean limitInPlace;
    private Reader reader;

    public LimitReader(Reader reader) {
        this.reader = reader;
        this.clearLimit();
    }

    @Override
    public int read() throws IOException {
        if (!this.limitInPlace) {
            return this.reader.read();
        }
        if (this.remainingCharacters == 0) {
            return -1;
        }
        int n = this.reader.read();
        if (n >= 0) {
            --this.remainingCharacters;
        }
        return n;
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (!this.limitInPlace) {
            return this.reader.read(cArray, n, n2);
        }
        if (this.remainingCharacters == 0) {
            return -1;
        }
        if (this.remainingCharacters < n2) {
            n2 = this.remainingCharacters;
        }
        if ((n2 = this.reader.read(cArray, n, n2)) >= 0) {
            this.remainingCharacters -= n2;
        }
        return n2;
    }

    @Override
    public long skip(long l) throws IOException {
        if (!this.limitInPlace) {
            return this.reader.skip(l);
        }
        if (this.remainingCharacters == 0) {
            return 0L;
        }
        if ((long)this.remainingCharacters < l) {
            l = this.remainingCharacters;
        }
        l = this.reader.skip(l);
        this.remainingCharacters = (int)((long)this.remainingCharacters - l);
        return l;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public void setLimit(int n) {
        this.remainingCharacters = n;
        this.limitInPlace = true;
    }

    public final int getLimit() {
        return this.remainingCharacters;
    }

    @Override
    public int clearLimit() {
        int n = this.remainingCharacters;
        this.limitInPlace = false;
        this.remainingCharacters = -1;
        return n;
    }
}

