/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.transport.AMQBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.transport.ByteBufferSender;

public class AMQFrame
extends AMQDataBlock
implements EncodableAMQDataBlock {
    private static final int HEADER_SIZE = 7;
    private final int _channel;
    private final AMQBody _bodyFrame;
    public static final byte FRAME_END_BYTE = -50;
    private static final QpidByteBuffer FRAME_END_BYTE_BUFFER = QpidByteBuffer.allocateDirect((int)1);

    public AMQFrame(int channel, AMQBody bodyFrame) {
        this._channel = channel;
        this._bodyFrame = bodyFrame;
    }

    @Override
    public long getSize() {
        return 7 + this._bodyFrame.getSize() + 1;
    }

    public static final int getFrameOverhead() {
        return 8;
    }

    @Override
    public long writePayload(ByteBufferSender sender) {
        try (QpidByteBuffer frameHeader = QpidByteBuffer.allocate((boolean)sender.isDirectBufferPreferred(), (int)7);){
            frameHeader.put(this._bodyFrame.getFrameType());
            frameHeader.putUnsignedShort(this._channel);
            frameHeader.putUnsignedInt((long)this._bodyFrame.getSize());
            frameHeader.flip();
            sender.send(frameHeader);
        }
        long size = 8L + this._bodyFrame.writePayload(sender);
        try (QpidByteBuffer endFrame = FRAME_END_BYTE_BUFFER.duplicate();){
            sender.send(endFrame);
        }
        return size;
    }

    public final int getChannel() {
        return this._channel;
    }

    public final AMQBody getBodyFrame() {
        return this._bodyFrame;
    }

    public String toString() {
        return "Frame channelId: " + this._channel + ", bodyFrame: " + String.valueOf(this._bodyFrame);
    }

    static {
        FRAME_END_BYTE_BUFFER.put((byte)-50);
        FRAME_END_BYTE_BUFFER.flip();
    }
}

