/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.base.Strings;
import java.util.Optional;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsTag;

public final class DecayRpcSchedulerUtil {
    private DecayRpcSchedulerUtil() {
    }

    public static String splitMetricNameIfNeeded(String recordName, String metricName) {
        if (recordName.toLowerCase().contains("decayrpcscheduler") && metricName.toLowerCase().contains("caller(")) {
            String[] names = metricName.split("[.]");
            return names[1];
        }
        return metricName;
    }

    public static String checkMetricNameForUsername(String recordName, String metricName) {
        if (recordName.toLowerCase().contains("decayrpcscheduler") && metricName.toLowerCase().contains("caller(")) {
            String[] names = metricName.split("[.]");
            String caller = names[0];
            String[] subStrings = caller.split("[()]");
            String username = subStrings[1];
            return username;
        }
        return null;
    }

    public static Optional<MetricsTag> createUsernameTag(String username) {
        if (Strings.isNullOrEmpty((String)username)) {
            return Optional.empty();
        }
        String name = "username";
        String description = "caller username";
        MetricsInfo metricsInfo = new MetricsInfo(){

            public String name() {
                return "username";
            }

            public String description() {
                return "caller username";
            }
        };
        MetricsTag metricsTag = new MetricsTag(metricsInfo, username);
        return Optional.of(metricsTag);
    }
}

