/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootCaRotationPoller
implements Runnable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RootCaRotationPoller.class);
    private final List<Function<List<X509Certificate>, CompletableFuture<Void>>> rootCARotationProcessors;
    private final ScheduledExecutorService poller;
    private final Duration pollingInterval;
    private Set<X509Certificate> knownRootCerts;
    private final SCMSecurityProtocolClientSideTranslatorPB scmSecureClient;
    private final AtomicBoolean certificateRenewalError;

    public RootCaRotationPoller(SecurityConfig securityConfig, Set<X509Certificate> initiallyKnownRootCaCerts, SCMSecurityProtocolClientSideTranslatorPB scmSecureClient, String threadNamePrefix) {
        this.scmSecureClient = scmSecureClient;
        this.knownRootCerts = initiallyKnownRootCaCerts;
        this.poller = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + this.getClass().getSimpleName()).setDaemon(true).build());
        this.pollingInterval = securityConfig.getRootCaCertificatePollingInterval();
        this.rootCARotationProcessors = new ArrayList<Function<List<X509Certificate>, CompletableFuture<Void>>>();
        this.certificateRenewalError = new AtomicBoolean(false);
    }

    void pollRootCas() {
        try {
            List<String> pemEncodedRootCaList = this.scmSecureClient.getAllRootCaCertificates();
            List rootCAsFromSCM = OzoneSecurityUtil.convertToX509(pemEncodedRootCaList);
            ArrayList<X509Certificate> scmCertsWithoutKnownCerts = new ArrayList<X509Certificate>(rootCAsFromSCM);
            scmCertsWithoutKnownCerts.removeAll(this.knownRootCerts);
            if (scmCertsWithoutKnownCerts.isEmpty()) {
                return;
            }
            LOG.info("Some root CAs are not known to the client out of the root CAs known to the SCMs. Root CA Cert ids known to the client: " + this.getPrintableCertIds(this.knownRootCerts) + ". Root CA Cert ids from SCM not known by the client: " + this.getPrintableCertIds(scmCertsWithoutKnownCerts));
            this.certificateRenewalError.set(false);
            CompletableFuture<Void> allRootCAProcessorFutures = CompletableFuture.allOf((CompletableFuture[])this.rootCARotationProcessors.stream().map(c -> (CompletableFuture)c.apply(rootCAsFromSCM)).toArray(CompletableFuture[]::new));
            allRootCAProcessorFutures.whenComplete((unused, throwable) -> {
                if (throwable == null && !this.certificateRenewalError.get()) {
                    this.knownRootCerts = new HashSet<X509Certificate>(rootCAsFromSCM);
                    LOG.info("Certificate processing was successful.");
                } else {
                    LOG.info("Certificate consumption was unsuccessful. " + (this.certificateRenewalError.get() ? "There was a caught exception when trying to sign the certificate" : "There was an unexpected error during cert rotation" + throwable));
                }
            });
        }
        catch (IOException e) {
            LOG.error("Error while trying to poll root ca certificate", (Throwable)e);
        }
    }

    public void addRootCARotationProcessor(Function<List<X509Certificate>, CompletableFuture<Void>> processor) {
        this.rootCARotationProcessors.add(processor);
    }

    @Override
    public void run() {
        this.poller.scheduleAtFixedRate(this::pollRootCas, 0L, this.pollingInterval.getSeconds(), TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        this.executorServiceShutdownGraceful(this.poller);
    }

    private void executorServiceShutdownGraceful(ExecutorService executor) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                LOG.warn("{} couldn't be shut down gracefully", (Object)this.getClass().getSimpleName());
            }
        }
        catch (InterruptedException e) {
            LOG.warn("{} couldn't be stopped gracefully", (Object)this.getClass().getSimpleName());
            Thread.currentThread().interrupt();
        }
    }

    public void setCertificateRenewalError() {
        this.certificateRenewalError.set(true);
    }

    private String getPrintableCertIds(Collection<X509Certificate> certs) {
        return certs.stream().map(X509Certificate::getSerialNumber).map(BigInteger::toString).collect(Collectors.joining(", "));
    }
}

