/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import java.time.Instant;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.security.symmetric.ManagedSecretKey;
import org.apache.hadoop.hdds.security.symmetric.SecretKeySignerClient;
import org.apache.hadoop.hdds.security.token.ShortLivedTokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class ShortLivedTokenSecretManager<T extends ShortLivedTokenIdentifier> {
    private final long tokenMaxLifetime;
    private SecretKeySignerClient secretKeyClient;

    protected ShortLivedTokenSecretManager(long tokenLifetime, SecretKeySignerClient secretKeyClient) {
        this.tokenMaxLifetime = tokenLifetime;
        this.secretKeyClient = secretKeyClient;
    }

    protected byte[] createPassword(T tokenId) {
        ManagedSecretKey secretKey = this.secretKeyClient.getCurrentSecretKey();
        tokenId.setSecretKeyId(secretKey.getId());
        return secretKey.sign((TokenIdentifier)tokenId);
    }

    protected Instant getTokenExpiryTime() {
        return Instant.now().plusMillis(this.tokenMaxLifetime);
    }

    public Token<T> generateToken(T tokenIdentifier) {
        byte[] password = this.createPassword(tokenIdentifier);
        return new Token(tokenIdentifier.getBytes(), password, tokenIdentifier.getKind(), new Text(tokenIdentifier.getService()));
    }

    public void setSecretKeyClient(SecretKeySignerClient client) {
        this.secretKeyClient = client;
    }
}

