/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.ha.SCMContext;
import org.apache.hadoop.hdds.scm.ha.SCMHAManager;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineManager;
import org.apache.hadoop.hdds.scm.server.SCMStorageConfig;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationCheckpoint;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationManager;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationStateManager;
import org.apache.hadoop.hdds.scm.server.upgrade.FinalizationStateManagerImpl;
import org.apache.hadoop.hdds.scm.server.upgrade.SCMUpgradeFinalizationContext;
import org.apache.hadoop.hdds.scm.server.upgrade.SCMUpgradeFinalizer;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.upgrade.BasicUpgradeFinalizer;
import org.apache.hadoop.ozone.upgrade.DefaultUpgradeFinalizationExecutor;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizationExecutor;
import org.apache.ratis.util.ExitUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalizationManagerImpl
implements FinalizationManager {
    private static final Logger LOG = LoggerFactory.getLogger(FinalizationManagerImpl.class);
    private SCMUpgradeFinalizer upgradeFinalizer;
    private SCMUpgradeFinalizationContext context;
    private SCMStorageConfig storage;
    private OzoneConfiguration conf;
    private HDDSLayoutVersionManager versionManager;
    private final FinalizationStateManager finalizationStateManager;
    private ThreadFactory threadFactory;

    @VisibleForTesting
    protected FinalizationManagerImpl(Builder builder, FinalizationStateManager stateManager) throws IOException {
        this.initCommonFields(builder);
        this.finalizationStateManager = stateManager;
    }

    private FinalizationManagerImpl(Builder builder) throws IOException {
        this.initCommonFields(builder);
        this.finalizationStateManager = new FinalizationStateManagerImpl.Builder().setUpgradeFinalizer(this.upgradeFinalizer).setFinalizationStore((Table<String, String>)builder.finalizationStore).setTransactionBuffer(builder.scmHAManager.getDBTransactionBuffer()).setRatisServer(builder.scmHAManager.getRatisServer()).build();
    }

    private void initCommonFields(Builder builder) {
        this.storage = builder.storage;
        this.versionManager = builder.versionManager;
        this.conf = builder.conf;
        this.upgradeFinalizer = new SCMUpgradeFinalizer(this.versionManager, (UpgradeFinalizationExecutor<SCMUpgradeFinalizationContext>)builder.executor);
    }

    @Override
    public void buildUpgradeContext(NodeManager nodeManager, PipelineManager pipelineManager, SCMContext scmContext) {
        this.context = new SCMUpgradeFinalizationContext.Builder().setStorage(this.storage).setFinalizationStateManager(this.finalizationStateManager).setConfiguration(this.conf).setNodeManager(nodeManager).setPipelineManager(pipelineManager).setLayoutVersionManager(this.versionManager).setSCMContext(scmContext).build();
        this.finalizationStateManager.setUpgradeContext(this.context);
        String prefix = scmContext != null ? scmContext.threadNamePrefix() : "";
        this.threadFactory = new ThreadFactoryBuilder().setNameFormat(prefix + "FinalizationManager-%d").build();
    }

    @Override
    public UpgradeFinalization.StatusAndMessages finalizeUpgrade(String upgradeClientID) throws IOException {
        Preconditions.checkNotNull((Object)this.context, (Object)"Cannot finalize upgrade without first building the upgrade context.");
        return this.upgradeFinalizer.finalize(upgradeClientID, this.context);
    }

    @Override
    public UpgradeFinalization.StatusAndMessages queryUpgradeFinalizationProgress(String upgradeClientID, boolean takeover, boolean readonly) throws IOException {
        if (readonly) {
            return new UpgradeFinalization.StatusAndMessages(this.upgradeFinalizer.getStatus(), Collections.emptyList());
        }
        return this.upgradeFinalizer.reportStatus(upgradeClientID, takeover);
    }

    @Override
    public BasicUpgradeFinalizer<SCMUpgradeFinalizationContext, HDDSLayoutVersionManager> getUpgradeFinalizer() {
        return this.upgradeFinalizer;
    }

    @Override
    public void runPrefinalizeStateActions() throws IOException {
        this.upgradeFinalizer.runPrefinalizeStateActions((Storage)this.storage, this.context);
    }

    @Override
    public boolean crossedCheckpoint(FinalizationCheckpoint checkpoint) {
        return this.finalizationStateManager.crossedCheckpoint(checkpoint);
    }

    @Override
    public FinalizationCheckpoint getCheckpoint() {
        return this.finalizationStateManager.getFinalizationCheckpoint();
    }

    @Override
    public void reinitialize(Table<String, String> finalizationStore) throws IOException {
        this.finalizationStateManager.reinitialize(finalizationStore);
    }

    @Override
    public void onLeaderReady() {
        Executors.newSingleThreadExecutor(this.threadFactory).submit(() -> {
            FinalizationCheckpoint currentCheckpoint = this.getCheckpoint();
            if (currentCheckpoint.hasCrossed(FinalizationCheckpoint.FINALIZATION_STARTED) && !currentCheckpoint.hasCrossed(FinalizationCheckpoint.FINALIZATION_COMPLETE)) {
                LOG.info("SCM became leader. Resuming upgrade finalization from current checkpoint {}.", (Object)currentCheckpoint);
                try {
                    this.finalizeUpgrade("resume-finalization-as-leader");
                }
                catch (IOException ex) {
                    ExitUtils.terminate((int)1, (String)"Resuming upgrade finalization failed on SCM leader change.", (Throwable)ex, (boolean)true, (Logger)LOG);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("SCM became leader. No upgrade finalization action required for current checkpoint {}", (Object)currentCheckpoint);
            }
        });
    }

    public static class Builder {
        private OzoneConfiguration conf;
        private HDDSLayoutVersionManager versionManager;
        private SCMStorageConfig storage;
        private SCMHAManager scmHAManager;
        private Table<String, String> finalizationStore;
        private UpgradeFinalizationExecutor<SCMUpgradeFinalizationContext> executor = new DefaultUpgradeFinalizationExecutor();

        public Builder setConfiguration(OzoneConfiguration configuration) {
            this.conf = configuration;
            return this;
        }

        public Builder setLayoutVersionManager(HDDSLayoutVersionManager layoutVersionManager) {
            this.versionManager = layoutVersionManager;
            return this;
        }

        public Builder setStorage(SCMStorageConfig storage) {
            this.storage = storage;
            return this;
        }

        public Builder setHAManager(SCMHAManager haManager) {
            this.scmHAManager = haManager;
            return this;
        }

        public Builder setFinalizationStore(Table<String, String> finalizationStore) {
            this.finalizationStore = finalizationStore;
            return this;
        }

        public Builder setFinalizationExecutor(UpgradeFinalizationExecutor<SCMUpgradeFinalizationContext> finalizationExecutor) {
            this.executor = finalizationExecutor;
            return this;
        }

        public FinalizationManagerImpl build() throws IOException {
            Preconditions.checkNotNull((Object)this.conf);
            Preconditions.checkNotNull((Object)this.versionManager);
            Preconditions.checkNotNull((Object)((Object)this.storage));
            Preconditions.checkNotNull((Object)this.scmHAManager);
            Preconditions.checkNotNull(this.finalizationStore);
            Preconditions.checkNotNull(this.executor);
            return new FinalizationManagerImpl(this);
        }
    }
}

