/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.server;

import com.google.common.base.Preconditions;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.events.SCMEvents;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.hdds.server.events.IEventInfo;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.ozone.container.upgrade.UpgradeUtils;
import org.apache.hadoop.ozone.protocol.commands.ReregisterCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCMDatanodeHeartbeatDispatcher {
    public static final Logger LOG = LoggerFactory.getLogger(SCMDatanodeHeartbeatDispatcher.class);
    private final NodeManager nodeManager;
    private final EventPublisher eventPublisher;

    public SCMDatanodeHeartbeatDispatcher(NodeManager nodeManager, EventPublisher eventPublisher) {
        Preconditions.checkNotNull((Object)nodeManager);
        Preconditions.checkNotNull((Object)eventPublisher);
        this.nodeManager = nodeManager;
        this.eventPublisher = eventPublisher;
    }

    public List<SCMCommand<?>> dispatch(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto heartbeat) {
        List commands;
        DatanodeDetails datanodeDetails = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)heartbeat.getDatanodeDetails());
        if (!this.nodeManager.isNodeRegistered(datanodeDetails).booleanValue()) {
            LOG.info("SCM received heartbeat from an unregistered datanode {}. Asking datanode to re-register.", (Object)datanodeDetails);
            UUID dnID = datanodeDetails.getUuid();
            this.nodeManager.addDatanodeCommand(dnID, (SCMCommand<?>)new ReregisterCommand());
            commands = this.nodeManager.getCommandQueue(dnID);
        } else {
            List icrs;
            StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutVersion = null;
            layoutVersion = !heartbeat.hasDataNodeLayoutVersion() ? UpgradeUtils.toLayoutVersionProto((int)HDDSLayoutFeature.INITIAL_VERSION.layoutVersion(), (int)HDDSLayoutFeature.INITIAL_VERSION.layoutVersion()) : heartbeat.getDataNodeLayoutVersion();
            LOG.debug("Processing DataNode Layout Report.");
            this.nodeManager.processLayoutVersionReport(datanodeDetails, layoutVersion);
            StorageContainerDatanodeProtocolProtos.CommandQueueReportProto commandQueueReport = null;
            if (heartbeat.hasCommandQueueReport()) {
                commandQueueReport = heartbeat.getCommandQueueReport();
            }
            commands = this.nodeManager.processHeartbeat(datanodeDetails, commandQueueReport);
            if (heartbeat.hasNodeReport()) {
                LOG.debug("Dispatching Node Report.");
                this.eventPublisher.fireEvent(SCMEvents.NODE_REPORT, (Object)new NodeReportFromDatanode(datanodeDetails, heartbeat.getNodeReport()));
            }
            if (heartbeat.hasContainerReport()) {
                LOG.debug("Dispatching Container Report.");
                this.eventPublisher.fireEvent(SCMEvents.CONTAINER_REPORT, (Object)new ContainerReportFromDatanode(datanodeDetails, heartbeat.getContainerReport()));
            }
            if (!(icrs = heartbeat.getIncrementalContainerReportList()).isEmpty()) {
                LOG.debug("Dispatching ICRs.");
                for (StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto icr : icrs) {
                    this.eventPublisher.fireEvent(SCMEvents.INCREMENTAL_CONTAINER_REPORT, (Object)new IncrementalContainerReportFromDatanode(datanodeDetails, icr));
                }
            }
            if (heartbeat.hasContainerActions()) {
                LOG.debug("Dispatching Container Actions.");
                this.eventPublisher.fireEvent(SCMEvents.CONTAINER_ACTIONS, (Object)new ContainerActionsFromDatanode(datanodeDetails, heartbeat.getContainerActions()));
            }
            if (heartbeat.hasPipelineReports()) {
                LOG.debug("Dispatching Pipeline Report.");
                this.eventPublisher.fireEvent(SCMEvents.PIPELINE_REPORT, (Object)new PipelineReportFromDatanode(datanodeDetails, heartbeat.getPipelineReports()));
            }
            if (heartbeat.hasPipelineActions()) {
                LOG.debug("Dispatching Pipeline Actions.");
                this.eventPublisher.fireEvent(SCMEvents.PIPELINE_ACTIONS, (Object)new PipelineActionsFromDatanode(datanodeDetails, heartbeat.getPipelineActions()));
            }
            if (heartbeat.getCommandStatusReportsCount() != 0) {
                LOG.debug("Dispatching Command Status Report.");
                for (StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto commandStatusReport : heartbeat.getCommandStatusReportsList()) {
                    this.eventPublisher.fireEvent(SCMEvents.CMD_STATUS_REPORT, (Object)new CommandStatusReportFromDatanode(datanodeDetails, commandStatusReport));
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Heartbeat dispatched: datanode=" + datanodeDetails.getUuid() + ", Commands= " + commands);
        }
        return commands;
    }

    public static class CommandStatusReportFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto> {
        public CommandStatusReportFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto report) {
            super(datanodeDetails, report);
        }
    }

    public static class PipelineActionsFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.PipelineActionsProto> {
        public PipelineActionsFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.PipelineActionsProto actions) {
            super(datanodeDetails, actions);
        }
    }

    public static class PipelineReportFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.PipelineReportsProto> {
        public PipelineReportFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.PipelineReportsProto report) {
            super(datanodeDetails, report);
        }
    }

    public static class ContainerActionsFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.ContainerActionsProto> {
        public ContainerActionsFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.ContainerActionsProto actions) {
            super(datanodeDetails, actions);
        }
    }

    public static class IncrementalContainerReportFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto>
    implements ContainerReport,
    IEventInfo {
        private long createTime = Time.monotonicNow();

        public IncrementalContainerReportFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto report) {
            super(datanodeDetails, report);
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return this.getDatanodeDetails().getUuid().hashCode();
        }

        @Override
        public ContainerReportType getType() {
            return ContainerReportType.ICR;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public String getEventId() {
            return this.getDatanodeDetails().toString() + ", {type: " + (Object)((Object)this.getType()) + ", size: " + ((StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto)this.getReport()).getReportList().size() + "}";
        }

        @Override
        public void mergeReport(ContainerReport nextReport) {
            if (nextReport.getType() == ContainerReportType.ICR) {
                StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto reportProto = ((StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto)this.getReport()).toBuilder().addAllReport((Iterable)((StorageContainerDatanodeProtocolProtos.IncrementalContainerReportProto)((ReportFromDatanode)((Object)nextReport)).getReport()).getReportList()).build();
                this.setReport(reportProto);
            }
        }
    }

    public static class ContainerReportFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.ContainerReportsProto>
    implements ContainerReport,
    IEventInfo {
        private long createTime = Time.monotonicNow();
        private boolean isRegister = false;

        public ContainerReportFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.ContainerReportsProto report) {
            super(datanodeDetails, report);
        }

        public ContainerReportFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.ContainerReportsProto report, boolean isRegister) {
            super(datanodeDetails, report);
            this.isRegister = isRegister;
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return this.getDatanodeDetails().getUuid().hashCode();
        }

        @Override
        public ContainerReportType getType() {
            return ContainerReportType.FCR;
        }

        public long getCreateTime() {
            return this.createTime;
        }

        public boolean isRegister() {
            return this.isRegister;
        }

        public String getEventId() {
            return this.getDatanodeDetails().toString() + ", {type: " + (Object)((Object)this.getType()) + ", size: " + ((StorageContainerDatanodeProtocolProtos.ContainerReportsProto)this.getReport()).getReportsList().size() + "}";
        }

        @Override
        public void mergeReport(ContainerReport nextReport) {
        }
    }

    public static enum ContainerReportType {
        ICR,
        FCR;

    }

    public static interface ContainerReport {
        public DatanodeDetails getDatanodeDetails();

        public ContainerReportType getType();

        public void mergeReport(ContainerReport var1);
    }

    public static class LayoutReportFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.LayoutVersionProto> {
        public LayoutReportFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.LayoutVersionProto report) {
            super(datanodeDetails, report);
        }
    }

    public static class CommandQueueReportFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.CommandQueueReportProto> {
        private final Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> commandsToBeSent;

        public CommandQueueReportFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.CommandQueueReportProto report, Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> commandsToBeSent) {
            super(datanodeDetails, report);
            this.commandsToBeSent = commandsToBeSent;
        }

        public Map<StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type, Integer> getCommandsToBeSent() {
            return this.commandsToBeSent;
        }
    }

    public static class NodeReportFromDatanode
    extends ReportFromDatanode<StorageContainerDatanodeProtocolProtos.NodeReportProto> {
        public NodeReportFromDatanode(DatanodeDetails datanodeDetails, StorageContainerDatanodeProtocolProtos.NodeReportProto report) {
            super(datanodeDetails, report);
        }
    }

    public static class ReportFromDatanode<T extends Message> {
        private final DatanodeDetails datanodeDetails;
        private T report;

        public ReportFromDatanode(DatanodeDetails datanodeDetails, T report) {
            this.datanodeDetails = datanodeDetails;
            this.report = report;
        }

        public DatanodeDetails getDatanodeDetails() {
            return this.datanodeDetails;
        }

        public T getReport() {
            return this.report;
        }

        public void setReport(T report) {
            this.report = report;
        }
    }
}

