/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline.leader.choose.algorithms;

import java.lang.reflect.Constructor;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.apache.hadoop.hdds.scm.pipeline.PipelineStateManager;
import org.apache.hadoop.hdds.scm.pipeline.leader.choose.algorithms.LeaderChoosePolicy;
import org.apache.hadoop.hdds.scm.pipeline.leader.choose.algorithms.MinLeaderCountChoosePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LeaderChoosePolicyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderChoosePolicyFactory.class);
    private static final Class<? extends LeaderChoosePolicy> OZONE_SCM_PIPELINE_LEADER_CHOOSING_POLICY_DEFAULT = MinLeaderCountChoosePolicy.class;

    private LeaderChoosePolicyFactory() {
    }

    public static LeaderChoosePolicy getPolicy(ConfigurationSource conf, NodeManager nodeManager, PipelineStateManager pipelineStateManager) throws SCMException {
        Constructor constructor;
        Class policyClass = conf.getClass("ozone.scm.pipeline.leader-choose.policy", OZONE_SCM_PIPELINE_LEADER_CHOOSING_POLICY_DEFAULT, LeaderChoosePolicy.class);
        try {
            constructor = policyClass.getDeclaredConstructor(NodeManager.class, PipelineStateManager.class);
            LOG.info("Create leader choose policy of type {}", (Object)policyClass.getCanonicalName());
        }
        catch (NoSuchMethodException e) {
            String msg = "Failed to find constructor(NodeManager, PipelineStateManagerImpl) for class " + policyClass.getCanonicalName();
            LOG.error(msg);
            throw new SCMException(msg, SCMException.ResultCodes.FAILED_TO_INIT_LEADER_CHOOSE_POLICY);
        }
        try {
            return (LeaderChoosePolicy)constructor.newInstance(nodeManager, pipelineStateManager);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate class " + policyClass.getCanonicalName() + " for " + e.getMessage());
        }
    }
}

