/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.multitenant;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.om.multitenant.InMemoryMultiTenantAccessController;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.ratis.util.ReflectionUtils;

public interface MultiTenantAccessController {
    public Policy createPolicy(Policy var1) throws IOException;

    public Policy getPolicy(String var1) throws IOException;

    public List<Policy> getLabeledPolicies(String var1) throws IOException;

    public Policy updatePolicy(Policy var1) throws IOException;

    public void deletePolicy(String var1) throws IOException;

    public Role createRole(Role var1) throws IOException;

    public Role getRole(String var1) throws IOException;

    public Role updateRole(long var1, Role var3) throws IOException;

    public void deleteRole(String var1) throws IOException;

    public long getRangerServicePolicyVersion() throws IOException;

    public static Map<IAccessAuthorizer.ACLType, String> getRangerAclStrings() {
        EnumMap<IAccessAuthorizer.ACLType, String> rangerAclStrings = new EnumMap<IAccessAuthorizer.ACLType, String>(IAccessAuthorizer.ACLType.class);
        rangerAclStrings.put(IAccessAuthorizer.ACLType.ALL, "all");
        rangerAclStrings.put(IAccessAuthorizer.ACLType.LIST, "list");
        rangerAclStrings.put(IAccessAuthorizer.ACLType.READ, "read");
        rangerAclStrings.put(IAccessAuthorizer.ACLType.WRITE, "write");
        rangerAclStrings.put(IAccessAuthorizer.ACLType.CREATE, "create");
        rangerAclStrings.put(IAccessAuthorizer.ACLType.DELETE, "delete");
        rangerAclStrings.put(IAccessAuthorizer.ACLType.READ_ACL, "read_acl");
        rangerAclStrings.put(IAccessAuthorizer.ACLType.WRITE_ACL, "write_acl");
        return rangerAclStrings;
    }

    public static MultiTenantAccessController create(ConfigurationSource conf) {
        if (conf.getBoolean("ozone.om.tenant.dev.skip.ranger", false)) {
            return new InMemoryMultiTenantAccessController();
        }
        return (MultiTenantAccessController)ReflectionUtils.newInstance((Class)ReflectionUtils.getClass((String)"org.apache.hadoop.ozone.om.multitenant.RangerClientMultiTenantAccessController", MultiTenantAccessController.class), (Class[])new Class[]{ConfigurationSource.class}, (Object[])new Object[]{conf});
    }

    public static class Acl {
        private final boolean isAllowed;
        private final IAccessAuthorizer.ACLType acl;

        private Acl(IAccessAuthorizer.ACLType acl, boolean isAllowed) {
            this.isAllowed = isAllowed;
            this.acl = acl;
        }

        public static Acl allow(IAccessAuthorizer.ACLType acl) {
            return new Acl(acl, true);
        }

        public static Acl deny(IAccessAuthorizer.ACLType acl) {
            return new Acl(acl, false);
        }

        public IAccessAuthorizer.ACLType getAclType() {
            return this.acl;
        }

        public boolean isAllowed() {
            return this.isAllowed;
        }

        public int hashCode() {
            return Objects.hash(this.acl);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Acl otherAcl = (Acl)other;
            return this.isAllowed() == otherAcl.isAllowed() && this.acl == otherAcl.acl;
        }
    }

    public static class Policy {
        private final long id;
        private final String name;
        private final Set<String> volumes;
        private final Set<String> buckets;
        private final Set<String> keys;
        private final String description;
        private final Map<String, Collection<Acl>> userAcls;
        private final Map<String, Collection<Acl>> roleAcls;
        private final Set<String> labels;
        private final boolean isEnabled;

        private Policy(Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
            this.volumes = builder.volumes;
            this.buckets = builder.buckets;
            this.keys = builder.keys;
            this.description = builder.description;
            this.userAcls = builder.userAcls;
            this.roleAcls = builder.roleAcls;
            this.labels = builder.labels;
            this.isEnabled = builder.isEnabled;
        }

        public Set<String> getVolumes() {
            return this.volumes;
        }

        public Set<String> getBuckets() {
            return this.buckets;
        }

        public Set<String> getKeys() {
            return this.keys;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        public Set<String> getLabels() {
            return this.labels;
        }

        public Map<String, Collection<Acl>> getUserAcls() {
            return this.userAcls;
        }

        public Map<String, Collection<Acl>> getRoleAcls() {
            return this.roleAcls;
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Policy policy = (Policy)other;
            return Objects.equals(this.getName(), policy.getName()) && Objects.equals(this.getVolumes(), policy.getVolumes()) && Objects.equals(this.getBuckets(), policy.getBuckets()) && Objects.equals(this.getKeys(), policy.getKeys()) && Objects.equals(this.getDescription(), policy.getDescription()) && Objects.equals(this.getUserAcls(), policy.getUserAcls()) && Objects.equals(this.getRoleAcls(), policy.getRoleAcls()) && Objects.equals(this.getLabels(), policy.getLabels());
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public static final class Builder {
            private long id;
            private String name;
            private final Set<String> volumes = new HashSet<String>();
            private final Set<String> buckets = new HashSet<String>();
            private final Set<String> keys = new HashSet<String>();
            private String description;
            private final Map<String, Collection<Acl>> userAcls = new HashMap<String, Collection<Acl>>();
            private final Map<String, Collection<Acl>> roleAcls = new HashMap<String, Collection<Acl>>();
            private final Set<String> labels = new HashSet<String>();
            private boolean isEnabled;

            public Builder setId(Long policyId) {
                this.id = policyId;
                return this;
            }

            public Builder setName(String policyName) {
                this.name = policyName;
                return this;
            }

            public Builder setEnabled(boolean enabled) {
                this.isEnabled = enabled;
                return this;
            }

            public Builder addVolume(String volume) {
                this.volumes.add(volume);
                return this;
            }

            public Builder addBucket(String bucket) {
                this.buckets.add(bucket);
                return this;
            }

            public Builder addKey(String key) {
                this.keys.add(key);
                return this;
            }

            public Builder addVolumes(Collection<String> volumeList) {
                this.volumes.addAll(volumeList);
                return this;
            }

            public Builder addBuckets(Collection<String> bucketList) {
                this.buckets.addAll(bucketList);
                return this;
            }

            public Builder addKeys(Collection<String> keyList) {
                this.keys.addAll(keyList);
                return this;
            }

            public Builder setDescription(String policyDescription) {
                this.description = policyDescription;
                return this;
            }

            public Builder addUserAcl(String userName, Collection<Acl> acls) {
                this.userAcls.put(userName, new ArrayList<Acl>(acls));
                return this;
            }

            public Builder addRoleAcl(String roleName, Collection<Acl> acls) {
                this.roleAcls.put(roleName, new ArrayList<Acl>(acls));
                return this;
            }

            public Builder addLabel(String label) {
                this.labels.add(label);
                return this;
            }

            public Builder addLabels(Collection<String> labelsList) {
                this.labels.addAll(labelsList);
                return this;
            }

            public Policy build() {
                if (this.name == null || this.name.isEmpty()) {
                    throw new IllegalStateException("A policy must have a non-empty name.");
                }
                return new Policy(this);
            }
        }
    }

    public static class Role {
        private final String name;
        private final Map<String, Boolean> usersMap;
        private final Map<String, Boolean> rolesMap;
        private final String description;
        private final Long id;
        private final String createdByUser;

        private Role(Builder builder) {
            this.name = builder.name;
            this.usersMap = builder.usersMap;
            this.rolesMap = builder.rolesMap;
            this.description = builder.description;
            this.id = builder.id;
            this.createdByUser = builder.createdByUser;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Boolean> getUsersMap() {
            return this.usersMap;
        }

        public Map<String, Boolean> getRolesMap() {
            return this.rolesMap;
        }

        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        public Optional<Long> getId() {
            return Optional.ofNullable(this.id);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Role role = (Role)other;
            boolean roleIdsMatch = true;
            if (this.getId().isPresent() && role.getId().isPresent()) {
                roleIdsMatch = this.getId().equals(role.getId());
            }
            return Objects.equals(this.getName(), role.getName()) && Objects.equals(this.getUsersMap(), role.getUsersMap()) && Objects.equals(this.getDescription(), role.getDescription()) && roleIdsMatch;
        }

        public String getCreatedByUser() {
            return this.createdByUser;
        }

        public static final class Builder {
            private String name;
            private final Map<String, Boolean> usersMap;
            private final Map<String, Boolean> rolesMap;
            private String description;
            private Long id;
            private String createdByUser;

            public Builder() {
                this.usersMap = new HashMap<String, Boolean>();
                this.rolesMap = new HashMap<String, Boolean>();
            }

            public Builder(Role other) {
                this.name = other.getName();
                this.usersMap = new HashMap<String, Boolean>(other.getUsersMap());
                this.rolesMap = new HashMap<String, Boolean>(other.getRolesMap());
                other.getDescription().ifPresent(desc -> {
                    String string = this.description = desc;
                });
                other.getId().ifPresent(roleId -> {
                    Long l = this.id = roleId;
                });
                this.createdByUser = other.getCreatedByUser();
            }

            public Builder setName(String roleName) {
                this.name = roleName;
                return this;
            }

            public Builder addUser(String userName, boolean isRoleAdmin) {
                this.usersMap.put(userName, isRoleAdmin);
                return this;
            }

            public Builder addUsers(Collection<String> userNamesList) {
                userNamesList.forEach(userName -> {
                    Boolean bl = this.usersMap.put((String)userName, false);
                });
                return this;
            }

            public Builder addUsersMap(Map<String, Boolean> userNamesList) {
                this.usersMap.putAll(userNamesList);
                return this;
            }

            public Builder removeUser(String userName) {
                this.usersMap.remove(userName);
                return this;
            }

            public Builder clearUsers() {
                this.usersMap.clear();
                return this;
            }

            public Builder addRole(String roleName, boolean isRoleAdmin) {
                this.rolesMap.put(roleName, isRoleAdmin);
                return this;
            }

            public Builder addRoles(Collection<String> roleNamesList) {
                roleNamesList.forEach(userName -> {
                    Boolean bl = this.rolesMap.put((String)userName, false);
                });
                return this;
            }

            public Builder setDescription(String roleDescription) {
                this.description = roleDescription;
                return this;
            }

            public Builder setID(long roleId) {
                this.id = roleId;
                return this;
            }

            public Builder setCreatedByUser(String createdByUser) {
                this.createdByUser = createdByUser;
                return this;
            }

            public Role build() {
                return new Role(this);
            }
        }
    }
}

