/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.SnapshotChainInfo;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotChainManager {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotChainManager.class);
    private final Map<UUID, SnapshotChainInfo> globalSnapshotChain = Collections.synchronizedMap(new LinkedHashMap());
    private final ConcurrentMap<String, LinkedHashMap<UUID, SnapshotChainInfo>> snapshotChainByPath = new ConcurrentHashMap<String, LinkedHashMap<UUID, SnapshotChainInfo>>();
    private final ConcurrentMap<String, UUID> latestSnapshotIdByPath = new ConcurrentHashMap<String, UUID>();
    private final ConcurrentMap<UUID, String> snapshotIdToTableKey = new ConcurrentHashMap<UUID, String>();
    private UUID latestGlobalSnapshotId = null;
    private final boolean snapshotChainCorrupted;
    private UUID oldestGlobalSnapshotId;

    public SnapshotChainManager(OMMetadataManager metadataManager) {
        this.snapshotChainCorrupted = !this.loadFromSnapshotInfoTable(metadataManager);
    }

    private void addSnapshotGlobal(UUID snapshotID, UUID prevGlobalID) throws IOException {
        if (this.globalSnapshotChain.containsKey(snapshotID)) {
            throw new IOException(String.format("Global Snapshot chain corruption. Snapshot with snapshotId: %s is already present in the chain.", snapshotID));
        }
        if (!this.globalSnapshotChain.isEmpty() && prevGlobalID == null) {
            throw new IOException(String.format("Snapshot chain corruption. Adding snapshot %s as head node while there are %d snapshots in the global snapshot chain.", snapshotID, this.globalSnapshotChain.size()));
        }
        if (prevGlobalID != null && !this.globalSnapshotChain.containsKey(prevGlobalID)) {
            throw new IOException(String.format("Global Snapshot chain corruption. Previous snapshotId: %s is set for snapshotId: %s but no associated snapshot found in snapshot chain.", prevGlobalID, snapshotID));
        }
        if (prevGlobalID != null) {
            if (this.globalSnapshotChain.get(prevGlobalID).hasNextSnapshotId()) {
                throw new IOException(String.format("Global Snapshot chain corruption. Snapshot with snapshotId: %s already has the next snapshotId: %s. Adding snapshot %s with prevSnapshotId: %s will make the chain non linear.", prevGlobalID, this.globalSnapshotChain.get(prevGlobalID).getNextSnapshotId(), snapshotID, prevGlobalID));
            }
            this.globalSnapshotChain.get(prevGlobalID).setNextSnapshotId(snapshotID);
        } else {
            this.oldestGlobalSnapshotId = snapshotID;
        }
        this.globalSnapshotChain.put(snapshotID, new SnapshotChainInfo(snapshotID, prevGlobalID, null));
        this.latestGlobalSnapshotId = snapshotID;
    }

    private void addSnapshotPath(String snapshotPath, UUID snapshotID, UUID prevPathID) throws IOException {
        if (!(prevPathID == null || this.snapshotChainByPath.containsKey(snapshotPath) && ((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).containsKey(prevPathID))) {
            throw new IOException(String.format("Path Snapshot chain corruption. Previous snapshotId: %s is set for snapshotId: %s but no associated snapshot found in snapshot chain.", prevPathID, snapshotID));
        }
        if (prevPathID == null && this.snapshotChainByPath.containsKey(snapshotPath) && !((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).isEmpty()) {
            throw new IOException(String.format("Path Snapshot chain corruption. Error while adding snapshot with snapshotId %s with as the first snapshot in snapshot path: %s which already has %d snapshots.", snapshotID, snapshotPath, ((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).size()));
        }
        if (prevPathID != null && this.snapshotChainByPath.containsKey(snapshotPath)) {
            if (((SnapshotChainInfo)((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).get(prevPathID)).hasNextSnapshotId()) {
                throw new IOException(String.format("Path Snapshot chain corruption. Next snapshotId: %s is already set for snapshotId: %s. Adding snapshotId: %s with prevSnapshotId: %s will make the chain non linear.", ((SnapshotChainInfo)((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).get(prevPathID)).getNextSnapshotId(), prevPathID, snapshotID, prevPathID));
            }
            ((SnapshotChainInfo)((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).get(prevPathID)).setNextSnapshotId(snapshotID);
        }
        if (!this.snapshotChainByPath.containsKey(snapshotPath)) {
            this.snapshotChainByPath.put(snapshotPath, new LinkedHashMap());
        }
        ((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).put(snapshotID, new SnapshotChainInfo(snapshotID, prevPathID, null));
        this.latestSnapshotIdByPath.put(snapshotPath, snapshotID);
    }

    private boolean deleteSnapshotGlobal(UUID snapshotID) throws IOException {
        if (this.globalSnapshotChain.containsKey(snapshotID)) {
            UUID next = this.globalSnapshotChain.get(snapshotID).getNextSnapshotId();
            UUID prev = this.globalSnapshotChain.get(snapshotID).getPreviousSnapshotId();
            if (prev != null && !this.globalSnapshotChain.containsKey(prev)) {
                throw new IOException(String.format("Global snapshot chain corruption. SnapshotId: %s to be deleted has previous snapshotId: %s but associated snapshot is not found in snapshot chain.", snapshotID, prev));
            }
            if (next != null && !this.globalSnapshotChain.containsKey(next)) {
                throw new IOException(String.format("Global snapshot chain corruption. SnapshotId: {%s} to be deleted has next snapshotId: %s but associated snapshot is not found in snapshot chain.", snapshotID, next));
            }
            this.globalSnapshotChain.remove(snapshotID);
            if (next != null) {
                this.globalSnapshotChain.get(next).setPreviousSnapshotId(prev);
            }
            if (prev != null) {
                this.globalSnapshotChain.get(prev).setNextSnapshotId(next);
            }
            if (this.latestGlobalSnapshotId.equals(snapshotID)) {
                this.latestGlobalSnapshotId = prev;
            }
            if (snapshotID.equals(this.oldestGlobalSnapshotId)) {
                this.oldestGlobalSnapshotId = next;
            }
            return true;
        }
        LOG.warn("Snapshot chain corruption. SnapshotID: {} is not found in snapshot chain.", (Object)snapshotID);
        return false;
    }

    private boolean deleteSnapshotPath(String snapshotPath, UUID snapshotId) throws IOException {
        if (this.snapshotChainByPath.containsKey(snapshotPath) && ((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).containsKey(snapshotId)) {
            UUID nextSnapshotId = ((SnapshotChainInfo)((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).get(snapshotId)).getNextSnapshotId();
            UUID previousSnapshotId = ((SnapshotChainInfo)((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).get(snapshotId)).getPreviousSnapshotId();
            if (previousSnapshotId != null && !((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).containsKey(previousSnapshotId)) {
                throw new IOException(String.format("Path snapshot chain corruption. SnapshotId: %s at snapshotPath: %s to be deleted has previous snapshotId: %s but associated snapshot is not found in snapshot chain.", snapshotId, snapshotPath, previousSnapshotId));
            }
            if (nextSnapshotId != null && !((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).containsKey(nextSnapshotId)) {
                throw new IOException(String.format("Path snapshot chain corruption. SnapshotId: %s at snapshotPath: %s to be deleted has next snapshotId: %s but associated snapshot is not found in snapshot chain.", snapshotId, snapshotPath, nextSnapshotId));
            }
            ((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).remove(snapshotId);
            if (nextSnapshotId != null) {
                ((SnapshotChainInfo)((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).get(nextSnapshotId)).setPreviousSnapshotId(previousSnapshotId);
            }
            if (previousSnapshotId != null) {
                ((SnapshotChainInfo)((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).get(previousSnapshotId)).setNextSnapshotId(nextSnapshotId);
            }
            if (((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).isEmpty()) {
                this.snapshotChainByPath.remove(snapshotPath);
            }
            if (((UUID)this.latestSnapshotIdByPath.get(snapshotPath)).equals(snapshotId)) {
                this.latestSnapshotIdByPath.remove(snapshotPath);
                if (previousSnapshotId != null) {
                    this.latestSnapshotIdByPath.put(snapshotPath, previousSnapshotId);
                }
            }
            return true;
        }
        LOG.warn("Snapshot chain corruption. SnapshotId: {} is not in chain found for snapshot path {}.", (Object)snapshotId, (Object)snapshotPath);
        return false;
    }

    private boolean loadFromSnapshotInfoTable(OMMetadataManager metadataManager) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (TableIterator keyIter = metadataManager.getSnapshotInfoTable().iterator();){
                HashMap<UUID, SnapshotInfo> snaps = new HashMap<UUID, SnapshotInfo>();
                HashMap<UUID, UUID> snapshotToNextSnapshotMap = new HashMap<UUID, UUID>();
                UUID head = null;
                this.globalSnapshotChain.clear();
                this.snapshotChainByPath.clear();
                this.latestSnapshotIdByPath.clear();
                this.snapshotIdToTableKey.clear();
                while (keyIter.hasNext()) {
                    Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                    SnapshotInfo snapshotInfo = (SnapshotInfo)kv.getValue();
                    snaps.put(((SnapshotInfo)kv.getValue()).getSnapshotId(), snapshotInfo);
                    if (snapshotInfo.getGlobalPreviousSnapshotId() != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Global Snapshot chain link {} -> {}", (Object)snapshotInfo.getGlobalPreviousSnapshotId(), (Object)snapshotInfo.getSnapshotId());
                        }
                        snapshotToNextSnapshotMap.put(snapshotInfo.getGlobalPreviousSnapshotId(), snapshotInfo.getSnapshotId());
                        continue;
                    }
                    head = snapshotInfo.getSnapshotId();
                }
                int size = 0;
                UUID prev = null;
                while (head != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding Snapshot Info: {}", snaps.get(head));
                    }
                    this.addSnapshot((SnapshotInfo)snaps.get(head));
                    ++size;
                    prev = head;
                    head = (UUID)snapshotToNextSnapshotMap.get(head);
                }
                if (size != snaps.size()) {
                    throw new IOException(String.format("Snapshot chain corruption. All snapshots have not been added to the snapshot chain. Last snapshot added to chain : %s", prev));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            LOG.error("Failure while loading snapshot chain.", (Throwable)exception);
            return false;
        }
        return true;
    }

    public synchronized void addSnapshot(SnapshotInfo snapshotInfo) throws IOException {
        this.validateSnapshotChain();
        this.addSnapshotGlobal(snapshotInfo.getSnapshotId(), snapshotInfo.getGlobalPreviousSnapshotId());
        this.addSnapshotPath(snapshotInfo.getSnapshotPath(), snapshotInfo.getSnapshotId(), snapshotInfo.getPathPreviousSnapshotId());
        this.snapshotIdToTableKey.put(snapshotInfo.getSnapshotId(), snapshotInfo.getTableKey());
    }

    public synchronized void updateSnapshot(SnapshotInfo snapshotInfo) {
        this.snapshotIdToTableKey.computeIfPresent(snapshotInfo.getSnapshotId(), (snapshotId, dbTableKey) -> snapshotInfo.getTableKey());
    }

    public synchronized boolean deleteSnapshot(SnapshotInfo snapshotInfo) throws IOException {
        this.validateSnapshotChain();
        return this.deleteSnapshotGlobal(snapshotInfo.getSnapshotId()) && this.deleteSnapshotPath(snapshotInfo.getSnapshotPath(), snapshotInfo.getSnapshotId());
    }

    public synchronized void removeFromSnapshotIdToTable(UUID snapshotId) throws IOException {
        this.validateSnapshotChain();
        this.snapshotIdToTableKey.remove(snapshotId);
    }

    public UUID getLatestGlobalSnapshotId() throws IOException {
        this.validateSnapshotChain();
        return this.latestGlobalSnapshotId;
    }

    public UUID getOldestGlobalSnapshotId() throws IOException {
        this.validateSnapshotChain();
        return this.oldestGlobalSnapshotId;
    }

    public Iterator<UUID> iterator(final boolean reverse) throws IOException {
        this.validateSnapshotChain();
        return new Iterator<UUID>(){
            private UUID currentSnapshotId;
            {
                this.currentSnapshotId = bl ? SnapshotChainManager.this.getLatestGlobalSnapshotId() : SnapshotChainManager.this.getOldestGlobalSnapshotId();
            }

            @Override
            public boolean hasNext() {
                return this.currentSnapshotId != null;
            }

            @Override
            public UUID next() {
                try {
                    UUID prevSnapshotId = this.currentSnapshotId;
                    this.currentSnapshotId = reverse && SnapshotChainManager.this.hasPreviousGlobalSnapshot(this.currentSnapshotId) || !reverse && SnapshotChainManager.this.hasNextGlobalSnapshot(this.currentSnapshotId) ? (reverse ? SnapshotChainManager.this.previousGlobalSnapshot(this.currentSnapshotId) : SnapshotChainManager.this.nextGlobalSnapshot(this.currentSnapshotId)) : null;
                    return prevSnapshotId;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error while getting next snapshot for " + this.currentSnapshotId, e);
                }
            }
        };
    }

    public UUID getLatestPathSnapshotId(String snapshotPath) throws IOException {
        this.validateSnapshotChain();
        return (UUID)this.latestSnapshotIdByPath.get(snapshotPath);
    }

    public boolean hasNextGlobalSnapshot(UUID snapshotId) throws IOException {
        this.validateSnapshotChain();
        if (!this.globalSnapshotChain.containsKey(snapshotId)) {
            LOG.error("No snapshot for provided snapshotId: {}", (Object)snapshotId);
            throw new NoSuchElementException(String.format("SnapshotId: %s is not found in snapshot chain.", snapshotId));
        }
        return this.globalSnapshotChain.get(snapshotId).getNextSnapshotId() != null;
    }

    public UUID nextGlobalSnapshot(UUID snapshotId) throws IOException {
        this.validateSnapshotChain();
        if (!this.hasNextGlobalSnapshot(snapshotId)) {
            LOG.error("No snapshot for provided snapshotId: {}", (Object)snapshotId);
            throw new NoSuchElementException(String.format("SnapshotId: %s is not found in snapshot chain.", snapshotId));
        }
        return this.globalSnapshotChain.get(snapshotId).getNextSnapshotId();
    }

    public boolean hasPreviousGlobalSnapshot(UUID snapshotId) throws IOException {
        this.validateSnapshotChain();
        if (!this.globalSnapshotChain.containsKey(snapshotId)) {
            LOG.error("No snapshot found in snapshot chain for provided snapshotId: {}.", (Object)snapshotId);
            throw new NoSuchElementException(String.format("SnapshotId: %s is not found in snapshot chain.", snapshotId));
        }
        return this.globalSnapshotChain.get(snapshotId).getPreviousSnapshotId() != null;
    }

    public UUID previousGlobalSnapshot(UUID snapshotId) throws IOException {
        this.validateSnapshotChain();
        if (!this.hasPreviousGlobalSnapshot(snapshotId)) {
            LOG.error("No preceding snapshot found in snapshot chain for provided snapshotId: {}.", (Object)snapshotId);
            throw new NoSuchElementException(String.format("SnapshotId: %s is not found in snapshot chain.", snapshotId));
        }
        return this.globalSnapshotChain.get(snapshotId).getPreviousSnapshotId();
    }

    public boolean hasNextPathSnapshot(String snapshotPath, UUID snapshotId) throws IOException {
        this.validateSnapshotChain();
        if (!this.snapshotChainByPath.containsKey(snapshotPath) || !((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).containsKey(snapshotId)) {
            LOG.error("No snapshot found for provided snapshotId: {} and snapshotPath: {}", (Object)snapshotId, (Object)snapshotPath);
            throw new NoSuchElementException(String.format("SnapshotId: %s is not found in snapshot chain for snapshotPath: %s.", snapshotId, snapshotPath));
        }
        return ((SnapshotChainInfo)((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).get(snapshotId)).getNextSnapshotId() != null;
    }

    public UUID nextPathSnapshot(String snapshotPath, UUID snapshotId) throws IOException {
        this.validateSnapshotChain();
        if (!this.hasNextPathSnapshot(snapshotPath, snapshotId)) {
            LOG.error("No following snapshot for provided snapshotId {} and snapshotPath {}.", (Object)snapshotId, (Object)snapshotPath);
            throw new NoSuchElementException(String.format("No following snapshot found in snapshot chain for snapshotId: %s and snapshotPath: %s.", snapshotId, snapshotPath));
        }
        return ((SnapshotChainInfo)((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).get(snapshotId)).getNextSnapshotId();
    }

    public boolean hasPreviousPathSnapshot(String snapshotPath, UUID snapshotId) throws IOException {
        this.validateSnapshotChain();
        if (!this.snapshotChainByPath.containsKey(snapshotPath) || !((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).containsKey(snapshotId)) {
            LOG.error("No snapshot found for provided snapshotId: {} and snapshotPath: {}", (Object)snapshotId, (Object)snapshotPath);
            throw new NoSuchElementException(String.format("SnapshotId: %s is not found in snapshot chain for snapshotPath: %s.", snapshotId, snapshotPath));
        }
        return ((SnapshotChainInfo)((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).get(snapshotId)).getPreviousSnapshotId() != null;
    }

    public UUID previousPathSnapshot(String snapshotPath, UUID snapshotId) throws IOException {
        this.validateSnapshotChain();
        if (!this.hasPreviousPathSnapshot(snapshotPath, snapshotId)) {
            LOG.error("No preceding snapshot for provided snapshotId: {} and snapshotPath: {}", (Object)snapshotId, (Object)snapshotPath);
            throw new NoSuchElementException(String.format("No preceding snapshot found in snapshot chain for snapshotId: %s and snapshotPath: %s.", snapshotId, snapshotPath));
        }
        return ((SnapshotChainInfo)((LinkedHashMap)this.snapshotChainByPath.get(snapshotPath)).get(snapshotId)).getPreviousSnapshotId();
    }

    public String getTableKey(UUID snapshotId) {
        return (String)this.snapshotIdToTableKey.get(snapshotId);
    }

    public LinkedHashMap<UUID, SnapshotChainInfo> getSnapshotChainPath(String path) throws IOException {
        this.validateSnapshotChain();
        return (LinkedHashMap)this.snapshotChainByPath.get(path);
    }

    @VisibleForTesting
    public Map<UUID, SnapshotChainInfo> getGlobalSnapshotChain() throws IOException {
        this.validateSnapshotChain();
        return this.globalSnapshotChain;
    }

    @VisibleForTesting
    public Map<String, LinkedHashMap<UUID, SnapshotChainInfo>> getSnapshotChainByPath() throws IOException {
        this.validateSnapshotChain();
        return this.snapshotChainByPath;
    }

    private void validateSnapshotChain() throws IOException {
        if (this.snapshotChainCorrupted) {
            throw new IOException("Snapshot chain is corrupted.");
        }
    }

    public boolean isSnapshotChainCorrupted() {
        return this.snapshotChainCorrupted;
    }
}

