/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.security.token.Token;

public final class OzoneManagerUtils {
    private OzoneManagerUtils() {
    }

    public static OmBucketInfo getBucketInfo(OMMetadataManager metaMgr, String volName, String buckName) throws IOException {
        String buckKey = metaMgr.getBucketKey(volName, buckName);
        OmBucketInfo bucketInfo = (OmBucketInfo)metaMgr.getBucketTable().get((Object)buckKey);
        if (bucketInfo == null) {
            OzoneManagerUtils.reportNotFound(metaMgr, volName, buckName);
        }
        return bucketInfo;
    }

    private static void reportNotFound(OMMetadataManager metaMgr, String volName, String buckName) throws IOException {
        if (!metaMgr.getVolumeTable().isExist((Object)metaMgr.getVolumeKey(volName))) {
            throw new OMException("Volume not found: " + volName, OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        throw new OMException("Bucket not found: " + volName + "/" + buckName, OMException.ResultCodes.BUCKET_NOT_FOUND);
    }

    public static BucketLayout getBucketLayout(OMMetadataManager metadataManager, String volName, String buckName) throws IOException {
        return OzoneManagerUtils.getResolvedBucketInfo(metadataManager, volName, buckName).getBucketLayout();
    }

    public static OmBucketInfo getResolvedBucketInfo(OMMetadataManager metadataManager, String volName, String buckName) throws IOException {
        return OzoneManagerUtils.resolveBucketInfoLink(metadataManager, volName, buckName, new HashSet<Pair<String, String>>());
    }

    private static OmBucketInfo resolveBucketInfoLink(OMMetadataManager metadataManager, String volName, String buckName, Set<Pair<String, String>> visited) throws IOException {
        OmBucketInfo buckInfo = OzoneManagerUtils.getBucketInfo(metadataManager, volName, buckName);
        if (buckInfo.isLink()) {
            if (!visited.add((Pair<String, String>)Pair.of((Object)volName, (Object)buckName))) {
                throw new OMException("Detected loop in bucket links. Bucket name: " + buckName + ", Volume name: " + volName, OMException.ResultCodes.DETECTED_LOOP_IN_BUCKET_LINKS);
            }
            return OzoneManagerUtils.resolveBucketInfoLink(metadataManager, buckInfo.getSourceVolume(), buckInfo.getSourceBucket(), visited);
        }
        return buckInfo;
    }

    public static Map<String, String> buildTokenAuditMap(Token<OzoneTokenIdentifier> token) {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("kind", token.getKind() == null ? "" : token.getKind().toString());
        auditMap.put("service", token.getService() == null ? "" : token.getService().toString());
        return auditMap;
    }
}

