/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMultiTenantManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.TenantOp;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmDBAccessIdInfo;
import org.apache.hadoop.ozone.om.helpers.OmDBTenantState;
import org.apache.hadoop.ozone.om.helpers.OmDBUserPrincipalInfo;
import org.apache.hadoop.ozone.om.helpers.TenantUserList;
import org.apache.hadoop.ozone.om.multitenant.AuthorizerLock;
import org.apache.hadoop.ozone.om.multitenant.AuthorizerLockImpl;
import org.apache.hadoop.ozone.om.multitenant.BucketNameSpace;
import org.apache.hadoop.ozone.om.multitenant.CachedTenantState;
import org.apache.hadoop.ozone.om.multitenant.MultiTenantAccessController;
import org.apache.hadoop.ozone.om.multitenant.OzoneTenant;
import org.apache.hadoop.ozone.om.multitenant.Tenant;
import org.apache.hadoop.ozone.om.service.OMRangerBGSyncService;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMMultiTenantManagerImpl
implements OMMultiTenantManager {
    private static final Logger LOG = LoggerFactory.getLogger(OMMultiTenantManagerImpl.class);
    public static final String OZONE_OM_TENANT_DEV_SKIP_RANGER = "ozone.om.tenant.dev.skip.ranger";
    private final OzoneManager ozoneManager;
    private final OMMetadataManager omMetadataManager;
    private final OzoneConfiguration conf;
    private final Map<String, CachedTenantState> tenantCache;
    private final ReentrantReadWriteLock tenantCacheLock;
    private final OMRangerBGSyncService omRangerBGSyncService;
    private final MultiTenantAccessController accessController;
    private final AuthorizerLock authorizerLock;
    private final TenantOp authorizerOp;
    private final TenantOp cacheOp;

    public OMMultiTenantManagerImpl(OzoneManager ozoneManager, OzoneConfiguration conf) throws IOException {
        this.conf = conf;
        this.ozoneManager = ozoneManager;
        this.omMetadataManager = ozoneManager.getMetadataManager();
        this.tenantCache = new ConcurrentHashMap<String, CachedTenantState>();
        this.tenantCacheLock = new ReentrantReadWriteLock();
        this.authorizerLock = new AuthorizerLockImpl();
        this.loadTenantCacheFromDB();
        this.accessController = MultiTenantAccessController.create((ConfigurationSource)conf);
        this.cacheOp = new CacheOp(this.tenantCache, this.tenantCacheLock);
        this.authorizerOp = new AuthorizerOp(this.accessController, this.tenantCache, this.tenantCacheLock);
        TimeUnit internalTimeUnit = TimeUnit.SECONDS;
        long rangerSyncInterval = ozoneManager.getConfiguration().getTimeDuration("ozone.om.multitenancy.ranger.sync.interval", OMConfigKeys.OZONE_OM_MULTITENANCY_RANGER_SYNC_INTERVAL_DEFAULT.getDuration(), OMConfigKeys.OZONE_OM_MULTITENANCY_RANGER_SYNC_INTERVAL_DEFAULT.getUnit(), internalTimeUnit);
        long rangerSyncTimeout = ozoneManager.getConfiguration().getTimeDuration("ozone.om.multitenancy.ranger.sync.timeout", OMConfigKeys.OZONE_OM_MULTITENANCY_RANGER_SYNC_TIMEOUT_DEFAULT.getDuration(), OMConfigKeys.OZONE_OM_MULTITENANCY_RANGER_SYNC_TIMEOUT_DEFAULT.getUnit(), internalTimeUnit);
        this.omRangerBGSyncService = new OMRangerBGSyncService(ozoneManager, this, this.accessController, rangerSyncInterval, internalTimeUnit, rangerSyncTimeout);
        this.start();
    }

    @Override
    public OMRangerBGSyncService getOMRangerBGSyncService() {
        return this.omRangerBGSyncService;
    }

    @Override
    public void start() throws IOException {
        this.omRangerBGSyncService.start();
    }

    @Override
    public void stop() throws IOException {
        this.omRangerBGSyncService.shutdown();
    }

    @Override
    public OMMetadataManager getOmMetadataManager() {
        return this.omMetadataManager;
    }

    @Override
    public TenantOp getAuthorizerOp() {
        return this.authorizerOp;
    }

    @Override
    public TenantOp getCacheOp() {
        return this.cacheOp;
    }

    @Override
    public String getUserNameGivenAccessId(String accessId) {
        Preconditions.checkNotNull((Object)accessId);
        this.tenantCacheLock.readLock().lock();
        try {
            OmDBAccessIdInfo omDBAccessIdInfo = (OmDBAccessIdInfo)this.omMetadataManager.getTenantAccessIdTable().get((Object)accessId);
            if (omDBAccessIdInfo != null) {
                String userName = omDBAccessIdInfo.getUserPrincipal();
                LOG.debug("Username for accessId {} = {}", (Object)accessId, (Object)userName);
                String string = userName;
                return string;
            }
        }
        catch (IOException ioEx) {
            LOG.error("Unexpected error while obtaining DB Access Info for {}", (Object)accessId, (Object)ioEx);
        }
        finally {
            this.tenantCacheLock.readLock().unlock();
        }
        return null;
    }

    @Override
    public boolean isTenantAdmin(UserGroupInformation callerUgi, String tenantId, boolean delegated) {
        if (callerUgi == null) {
            return false;
        }
        return this.isTenantAdmin(callerUgi.getShortUserName(), tenantId, delegated) || this.isTenantAdmin(callerUgi.getUserName(), tenantId, delegated) || this.ozoneManager.isAdmin(callerUgi);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTenantAdmin(String username, String tenantId, boolean delegated) {
        if (StringUtils.isEmpty((CharSequence)username)) return false;
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            return false;
        }
        try {
            OmDBAccessIdInfo accessIdInfo;
            OmDBUserPrincipalInfo principalInfo = (OmDBUserPrincipalInfo)this.omMetadataManager.getPrincipalToAccessIdsTable().get((Object)username);
            if (principalInfo == null) {
                return false;
            }
            Iterator iterator = principalInfo.getAccessIds().iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                String accessId = (String)iterator.next();
                accessIdInfo = (OmDBAccessIdInfo)this.omMetadataManager.getTenantAccessIdTable().get((Object)accessId);
                if (accessIdInfo != null) continue;
                return false;
            } while (!tenantId.equals(accessIdInfo.getTenantId()));
            if (!delegated) {
                return accessIdInfo.getIsAdmin();
            }
            if (!accessIdInfo.getIsAdmin()) return false;
            if (!accessIdInfo.getIsDelegatedAdmin()) return false;
            return true;
        }
        catch (IOException iOException) {
            LOG.error("Error while retrieving value for key '" + username + "' in PrincipalToAccessIdsTable");
        }
        return false;
    }

    @Override
    public TenantUserList listUsersInTenant(String tenantID, String prefix) throws IOException {
        ArrayList userAccessIds = new ArrayList();
        this.tenantCacheLock.readLock().lock();
        try {
            if (!this.omMetadataManager.getTenantStateTable().isExist((Object)tenantID)) {
                throw new IOException("Tenant '" + tenantID + "' not found!");
            }
            CachedTenantState cachedTenantState = this.tenantCache.get(tenantID);
            if (cachedTenantState == null) {
                throw new IOException("Inconsistent in memory Tenant cache '" + tenantID + "' not found in cache, but present in OM DB!");
            }
            cachedTenantState.getAccessIdInfoMap().entrySet().stream().filter(k -> StringUtils.isEmpty((CharSequence)prefix) || ((CachedTenantState.CachedAccessIdInfo)k.getValue()).getUserPrincipal().startsWith(prefix)).forEach(k -> {
                String accessId = (String)k.getKey();
                CachedTenantState.CachedAccessIdInfo cacheEntry = (CachedTenantState.CachedAccessIdInfo)k.getValue();
                userAccessIds.add(OzoneManagerProtocolProtos.UserAccessIdInfo.newBuilder().setUserPrincipal(cacheEntry.getUserPrincipal()).setAccessId(accessId).build());
            });
        }
        finally {
            this.tenantCacheLock.readLock().unlock();
        }
        return new TenantUserList(userAccessIds);
    }

    @Override
    public Optional<String> getTenantForAccessID(String accessID) throws IOException {
        OmDBAccessIdInfo omDBAccessIdInfo = (OmDBAccessIdInfo)this.omMetadataManager.getTenantAccessIdTable().get((Object)accessID);
        if (omDBAccessIdInfo == null) {
            return Optional.empty();
        }
        return Optional.of(omDBAccessIdInfo.getTenantId());
    }

    private String getTenantForAccessIDThrowIfNotFound(String accessId) throws IOException {
        Optional<String> optionalTenant = this.getTenantForAccessID(accessId);
        if (!optionalTenant.isPresent()) {
            throw new OMException("No tenant found for access ID: " + accessId, OMException.ResultCodes.INVALID_ACCESS_ID);
        }
        return optionalTenant.get();
    }

    public OzoneConfiguration getConf() {
        return this.conf;
    }

    private void loadTenantCacheFromDB() {
        Object tenantStateTableIter;
        Table tenantStateTable = this.omMetadataManager.getTenantStateTable();
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try {
                tenantStateTableIter = tenantStateTable.iterator();
                try {
                    while (tenantStateTableIter.hasNext()) {
                        Table.KeyValue next = (Table.KeyValue)tenantStateTableIter.next();
                        String tenantId = (String)next.getKey();
                        OmDBTenantState tenantState = (OmDBTenantState)next.getValue();
                        this.tenantCache.put(tenantId, new CachedTenantState(tenantId, tenantState.getUserRoleName(), tenantState.getAdminRoleName()));
                    }
                }
                finally {
                    if (tenantStateTableIter != null) {
                        tenantStateTableIter.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while building tenant state cache from DB.", ex);
        }
        int userCount = 0;
        Table tenantAccessIdTable = this.omMetadataManager.getTenantAccessIdTable();
        try {
            tenantStateTableIter = null;
            Object var5_11 = null;
            try (TableIterator accessIdTableIter = tenantAccessIdTable.iterator();){
                while (accessIdTableIter.hasNext()) {
                    Table.KeyValue next = (Table.KeyValue)accessIdTableIter.next();
                    String accessId = (String)next.getKey();
                    OmDBAccessIdInfo value = (OmDBAccessIdInfo)next.getValue();
                    String tenantId = value.getTenantId();
                    String userPrincipal = value.getUserPrincipal();
                    boolean isAdmin = value.getIsAdmin();
                    CachedTenantState cachedTenantState = this.tenantCache.get(tenantId);
                    Preconditions.checkNotNull((Object)cachedTenantState, (Object)("OmDBTenantState should have existed for " + tenantId));
                    cachedTenantState.getAccessIdInfoMap().put(accessId, new CachedTenantState.CachedAccessIdInfo(userPrincipal, isAdmin));
                    ++userCount;
                }
                LOG.info("Loaded {} tenants and {} tenant users from the database", (Object)this.tenantCache.size(), (Object)userCount);
            }
            catch (Throwable throwable) {
                if (tenantStateTableIter == null) {
                    tenantStateTableIter = throwable;
                } else if (tenantStateTableIter != throwable) {
                    ((Throwable)tenantStateTableIter).addSuppressed(throwable);
                }
                throw tenantStateTableIter;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error while building tenant user cache from DB.", ex);
        }
    }

    @Override
    public void checkAdmin() throws OMException {
        UserGroupInformation ugi = ProtobufRpcEngine.Server.getRemoteUser();
        if (!this.ozoneManager.isAdmin(ugi)) {
            throw new OMException("User '" + ugi.getShortUserName() + "' is not an Ozone admin", OMException.ResultCodes.PERMISSION_DENIED);
        }
    }

    @Override
    public void checkTenantAdmin(String tenantId, boolean delegated) throws OMException {
        UserGroupInformation ugi = ProtobufRpcEngine.Server.getRemoteUser();
        if (!this.isTenantAdmin(ugi, tenantId, delegated)) {
            throw new OMException("User '" + ugi.getUserName() + "' is neither an Ozone admin nor a delegated admin of tenant '" + tenantId + "'.", OMException.ResultCodes.PERMISSION_DENIED);
        }
    }

    @Override
    public void checkTenantExistence(String tenantId) throws OMException {
        try {
            if (!this.omMetadataManager.getTenantStateTable().isExist((Object)tenantId)) {
                throw new OMException("Tenant '" + tenantId + "' doesn't exist.", OMException.ResultCodes.TENANT_NOT_FOUND);
            }
        }
        catch (IOException ex) {
            OMException omEx;
            if (ex instanceof OMException && (omEx = (OMException)((Object)ex)).getResult().equals((Object)OMException.ResultCodes.TENANT_NOT_FOUND)) {
                throw omEx;
            }
            throw new OMException("Error while retrieving OmDBTenantInfo for tenant '" + tenantId + "': " + ex.getMessage(), OMException.ResultCodes.METADATA_ERROR);
        }
    }

    @Override
    public String getTenantVolumeName(String tenantId) throws IOException {
        OmDBTenantState tenantState = (OmDBTenantState)this.omMetadataManager.getTenantStateTable().get((Object)tenantId);
        if (tenantState == null) {
            throw new OMException("Tenant '" + tenantId + "' does not exist", OMException.ResultCodes.TENANT_NOT_FOUND);
        }
        String volumeName = tenantState.getBucketNamespaceName();
        if (volumeName == null) {
            throw new OMException("Volume for tenant '" + tenantId + "' is not set!", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        return volumeName;
    }

    @Override
    public String getTenantUserRoleName(String tenantId) throws IOException {
        this.tenantCacheLock.readLock().lock();
        try {
            CachedTenantState cachedTenantState = this.tenantCache.get(tenantId);
            if (cachedTenantState == null) {
                throw new OMException("Tenant not found in cache: " + tenantId, OMException.ResultCodes.TENANT_NOT_FOUND);
            }
            String string = cachedTenantState.getTenantUserRoleName();
            return string;
        }
        finally {
            this.tenantCacheLock.readLock().unlock();
        }
    }

    @Override
    public String getTenantAdminRoleName(String tenantId) throws IOException {
        this.tenantCacheLock.readLock().lock();
        try {
            CachedTenantState cachedTenantState = this.tenantCache.get(tenantId);
            if (cachedTenantState == null) {
                throw new OMException("Tenant not found in cache: " + tenantId, OMException.ResultCodes.TENANT_NOT_FOUND);
            }
            String string = cachedTenantState.getTenantAdminRoleName();
            return string;
        }
        finally {
            this.tenantCacheLock.readLock().unlock();
        }
    }

    @Override
    public Tenant getTenantFromDBById(String tenantId) throws IOException {
        OmDBTenantState tenantState = (OmDBTenantState)this.omMetadataManager.getTenantStateTable().get((Object)tenantId);
        if (tenantState == null) {
            throw new OMException("Tenant '" + tenantId + "' does not exist", OMException.ResultCodes.TENANT_NOT_FOUND);
        }
        OzoneTenant tenantObj = new OzoneTenant(tenantState.getTenantId());
        tenantObj.addTenantAccessPolicy(tenantState.getBucketNamespacePolicyName());
        tenantObj.addTenantAccessPolicy(tenantState.getBucketPolicyName());
        tenantObj.addTenantAccessRole(tenantState.getUserRoleName());
        tenantObj.addTenantAccessRole(tenantState.getAdminRoleName());
        return tenantObj;
    }

    @Override
    public boolean isUserAccessIdPrincipalOrTenantAdmin(String accessId, UserGroupInformation ugi) throws IOException {
        OmDBAccessIdInfo accessIdInfo = (OmDBAccessIdInfo)this.omMetadataManager.getTenantAccessIdTable().get((Object)accessId);
        if (accessIdInfo == null) {
            return false;
        }
        String tenantId = accessIdInfo.getTenantId();
        if (tenantId == null) {
            throw new OMException("Unexpected error: OmDBAccessIdInfo tenantId field should not have been null", OMException.ResultCodes.METADATA_ERROR);
        }
        String accessIdPrincipal = accessIdInfo.getUserPrincipal();
        if (accessIdPrincipal == null) {
            throw new OMException("Unexpected error: OmDBAccessIdInfo kerberosPrincipal field should not have been null", OMException.ResultCodes.METADATA_ERROR);
        }
        if (ugi.getShortUserName().equals(accessIdPrincipal)) {
            return true;
        }
        return this.isTenantAdmin(ugi, tenantId, false);
    }

    @Override
    public boolean isTenantEmpty(String tenantId) throws IOException {
        if (!this.tenantCache.containsKey(tenantId)) {
            throw new OMException("Tenant does not exist for tenantId: " + tenantId, OMException.ResultCodes.TENANT_NOT_FOUND);
        }
        return this.tenantCache.get(tenantId).isTenantEmpty();
    }

    @VisibleForTesting
    public Map<String, CachedTenantState> getTenantCache() {
        return this.tenantCache;
    }

    public HashMap<String, HashSet<String>> getAllRolesFromCache() {
        HashMap<String, HashSet<String>> mtRoles = new HashMap<String, HashSet<String>>();
        this.tenantCacheLock.readLock().lock();
        try {
            for (Map.Entry<String, CachedTenantState> e1 : this.tenantCache.entrySet()) {
                CachedTenantState cachedTenantState = e1.getValue();
                String userRoleName = cachedTenantState.getTenantUserRoleName();
                mtRoles.computeIfAbsent(userRoleName, any -> new HashSet());
                String adminRoleName = cachedTenantState.getTenantAdminRoleName();
                mtRoles.computeIfAbsent(adminRoleName, any -> new HashSet());
                HashMap<String, CachedTenantState.CachedAccessIdInfo> accessIdInfoMap = cachedTenantState.getAccessIdInfoMap();
                for (Map.Entry e2 : accessIdInfoMap.entrySet()) {
                    CachedTenantState.CachedAccessIdInfo cachedAccessIdInfo = (CachedTenantState.CachedAccessIdInfo)e2.getValue();
                    String userPrincipal = cachedAccessIdInfo.getUserPrincipal();
                    boolean isAdmin = cachedAccessIdInfo.getIsAdmin();
                    this.addUserToMtRoles(mtRoles, userRoleName, userPrincipal);
                    if (!isAdmin) continue;
                    this.addUserToMtRoles(mtRoles, adminRoleName, userPrincipal);
                }
            }
        }
        finally {
            this.tenantCacheLock.readLock().unlock();
        }
        return mtRoles;
    }

    private void addUserToMtRoles(HashMap<String, HashSet<String>> mtRoles, String roleName, String userPrincipal) {
        if (!mtRoles.containsKey(roleName)) {
            mtRoles.put(roleName, new HashSet<String>(Collections.singletonList(userPrincipal)));
        } else {
            HashSet<String> usersInTheRole = mtRoles.get(roleName);
            usersInTheRole.add(userPrincipal);
        }
    }

    @Override
    public AuthorizerLock getAuthorizerLock() {
        return this.authorizerLock;
    }

    public class AuthorizerOp
    implements TenantOp {
        private final MultiTenantAccessController accessController;
        private final Map<String, CachedTenantState> tenantCache;
        private final ReentrantReadWriteLock tenantCacheLock;

        AuthorizerOp(MultiTenantAccessController accessController, Map<String, CachedTenantState> tenantCache, ReentrantReadWriteLock tenantCacheLock) {
            this.accessController = accessController;
            this.tenantCache = tenantCache;
            this.tenantCacheLock = tenantCacheLock;
        }

        private void checkAcquiredAuthorizerWriteLock() throws OMException {
            if (!OMMultiTenantManagerImpl.this.authorizerLock.isWriteLockHeldByCurrentThread()) {
                throw new OMException("Authorizer write lock must have been held before calling this", OMException.ResultCodes.INTERNAL_ERROR);
            }
        }

        @Override
        public void createTenant(String tenantId, String userRoleName, String adminRoleName) throws IOException {
            this.checkAcquiredAuthorizerWriteLock();
            OzoneTenant tenant = new OzoneTenant(tenantId);
            try {
                MultiTenantAccessController.Role adminRole = new MultiTenantAccessController.Role.Builder().setName(adminRoleName).setDescription("Managed by Ozone. WARNING: Changes will be overridden. Use Ozone tenant CLI to manage users in this tenant role instead.").build();
                adminRole = this.accessController.createRole(adminRole);
                Preconditions.checkState((boolean)adminRole.getName().equals(adminRoleName));
                tenant.addTenantAccessRole(adminRoleName);
                MultiTenantAccessController.Role userRole = new MultiTenantAccessController.Role.Builder().setName(userRoleName).addRole(adminRoleName, true).setDescription("Managed by Ozone. WARNING: Changes will be overridden. Use Ozone tenant CLI to manage users in this tenant role instead.").build();
                userRole = this.accessController.createRole(userRole);
                Preconditions.checkState((boolean)userRole.getName().equals(userRoleName));
                tenant.addTenantAccessRole(userRoleName);
                BucketNameSpace bucketNameSpace = tenant.getTenantBucketNameSpace();
                for (OzoneObj volume : bucketNameSpace.getBucketNameSpaceObjects()) {
                    String volumeName = volume.getVolumeName();
                    MultiTenantAccessController.Policy volumePolicy = OMMultiTenantManager.getDefaultVolumeAccessPolicy(tenantId, volumeName, userRoleName, adminRoleName);
                    volumePolicy = this.accessController.createPolicy(volumePolicy);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created volume policy: {}", (Object)volumePolicy);
                    }
                    tenant.addTenantAccessPolicy(volumePolicy.getName());
                    MultiTenantAccessController.Policy bucketPolicy = OMMultiTenantManager.getDefaultBucketAccessPolicy(tenantId, volumeName, userRoleName);
                    bucketPolicy = this.accessController.createPolicy(bucketPolicy);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created bucket policy: {}", (Object)bucketPolicy);
                    }
                    tenant.addTenantAccessPolicy(bucketPolicy.getName());
                }
            }
            catch (IOException e) {
                throw new OMException((Throwable)e, OMException.ResultCodes.TENANT_AUTHORIZER_ERROR);
            }
        }

        @Override
        public void deleteTenant(Tenant tenant) throws IOException {
            this.checkAcquiredAuthorizerWriteLock();
            LOG.info("Deleting tenant policies and roles from Ranger: {}", (Object)tenant);
            try {
                for (String policyName : tenant.getTenantAccessPolicies()) {
                    this.accessController.deletePolicy(policyName);
                }
                for (String roleName : tenant.getTenantRoles()) {
                    this.accessController.deleteRole(roleName);
                }
            }
            catch (IOException e) {
                throw new OMException((Throwable)e, OMException.ResultCodes.TENANT_AUTHORIZER_ERROR);
            }
        }

        private void checkRoleIdExistence(MultiTenantAccessController.Role role) throws IOException {
            if (!role.getId().isPresent()) {
                String errMsg = String.format("Received no role ID in: %s", role);
                LOG.error(errMsg);
                throw new IOException(errMsg);
            }
        }

        @Override
        public void assignUserToTenant(String userPrincipal, String tenantId, String accessId) throws IOException {
            this.checkAcquiredAuthorizerWriteLock();
            this.tenantCacheLock.readLock().lock();
            try {
                try {
                    CachedTenantState cachedTenantState = this.tenantCache.get(tenantId);
                    Preconditions.checkNotNull((Object)cachedTenantState, (Object)("Cache entry for tenant '" + tenantId + "' does not exist"));
                    String tenantUserRoleName = this.tenantCache.get(tenantId).getTenantUserRoleName();
                    MultiTenantAccessController.Role userRole = this.accessController.getRole(tenantUserRoleName);
                    this.checkRoleIdExistence(userRole);
                    long roleId = userRole.getId().get();
                    if (userRole.getUsersMap().containsKey(userPrincipal)) {
                        LOG.warn("User '{}' is already assigned to tenant '{}'", (Object)userPrincipal, (Object)tenantId);
                    }
                    userRole = new MultiTenantAccessController.Role.Builder(userRole).addUser(userPrincipal, false).build();
                    userRole = this.accessController.updateRole(roleId, userRole);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Updated user role: {}", (Object)userRole);
                    }
                }
                catch (IOException e) {
                    throw new OMException((Throwable)e, OMException.ResultCodes.TENANT_AUTHORIZER_ERROR);
                }
            }
            finally {
                this.tenantCacheLock.readLock().unlock();
            }
        }

        @Override
        public void revokeUserAccessId(String accessId, String tenantId) throws IOException {
            this.checkAcquiredAuthorizerWriteLock();
            this.tenantCacheLock.readLock().lock();
            try {
                try {
                    OmDBAccessIdInfo omDBAccessIdInfo = (OmDBAccessIdInfo)OMMultiTenantManagerImpl.this.omMetadataManager.getTenantAccessIdTable().get((Object)accessId);
                    if (omDBAccessIdInfo == null) {
                        throw new OMException(OMException.ResultCodes.INVALID_ACCESS_ID);
                    }
                    String tenantIdGot = omDBAccessIdInfo.getTenantId();
                    Preconditions.checkArgument((boolean)tenantIdGot.equals(tenantId));
                    String userPrincipal = omDBAccessIdInfo.getUserPrincipal();
                    String tenantUserRoleName = this.tenantCache.get(tenantId).getTenantUserRoleName();
                    MultiTenantAccessController.Role userRole = this.accessController.getRole(tenantUserRoleName);
                    this.checkRoleIdExistence(userRole);
                    long roleId = userRole.getId().get();
                    if (!userRole.getUsersMap().containsKey(userPrincipal)) {
                        LOG.warn("User '{}' is not assigned to tenant '{}'", (Object)userPrincipal, (Object)tenantId);
                    }
                    userRole = new MultiTenantAccessController.Role.Builder(userRole).removeUser(userPrincipal).build();
                    userRole = this.accessController.updateRole(roleId, userRole);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Updated user role: {}", (Object)userRole);
                    }
                }
                catch (IOException e) {
                    throw new OMException((Throwable)e, OMException.ResultCodes.TENANT_AUTHORIZER_ERROR);
                }
            }
            finally {
                this.tenantCacheLock.readLock().unlock();
            }
        }

        @Override
        public void assignTenantAdmin(String accessId, boolean delegated) throws IOException {
            this.checkAcquiredAuthorizerWriteLock();
            this.tenantCacheLock.readLock().lock();
            try {
                try {
                    String tenantId = OMMultiTenantManagerImpl.this.getTenantForAccessIDThrowIfNotFound(accessId);
                    CachedTenantState cachedTenantState = this.tenantCache.get(tenantId);
                    String tenantAdminRoleName = cachedTenantState.getTenantAdminRoleName();
                    String userPrincipal = OMMultiTenantManagerImpl.this.getUserNameGivenAccessId(accessId);
                    MultiTenantAccessController.Role adminRole = this.accessController.getRole(tenantAdminRoleName);
                    this.checkRoleIdExistence(adminRole);
                    if (adminRole.getUsersMap().containsKey(userPrincipal)) {
                        LOG.warn("User '{}' is already admin in tenant '{}'", (Object)userPrincipal, (Object)tenantId);
                    }
                    long roleId = adminRole.getId().get();
                    adminRole = new MultiTenantAccessController.Role.Builder(adminRole).addUser(userPrincipal, delegated).build();
                    adminRole = this.accessController.updateRole(roleId, adminRole);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Updated admin role: {}", (Object)adminRole);
                    }
                }
                catch (IOException e) {
                    throw new OMException((Throwable)e, OMException.ResultCodes.TENANT_AUTHORIZER_ERROR);
                }
            }
            finally {
                this.tenantCacheLock.readLock().unlock();
            }
        }

        @Override
        public void revokeTenantAdmin(String accessId) throws IOException {
            this.checkAcquiredAuthorizerWriteLock();
            this.tenantCacheLock.readLock().lock();
            try {
                try {
                    String tenantId = OMMultiTenantManagerImpl.this.getTenantForAccessIDThrowIfNotFound(accessId);
                    CachedTenantState cachedTenantState = this.tenantCache.get(tenantId);
                    String tenantAdminRoleName = cachedTenantState.getTenantAdminRoleName();
                    String userPrincipal = OMMultiTenantManagerImpl.this.getUserNameGivenAccessId(accessId);
                    MultiTenantAccessController.Role adminRole = this.accessController.getRole(tenantAdminRoleName);
                    this.checkRoleIdExistence(adminRole);
                    long roleId = adminRole.getId().get();
                    if (!adminRole.getUsersMap().containsKey(userPrincipal)) {
                        LOG.warn("User '{}' is not admin in tenant '{}'", (Object)userPrincipal, (Object)tenantId);
                    }
                    adminRole = new MultiTenantAccessController.Role.Builder(adminRole).removeUser(userPrincipal).build();
                    adminRole = this.accessController.updateRole(roleId, adminRole);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Updated admin role: {}", (Object)adminRole);
                    }
                }
                catch (IOException e) {
                    throw new OMException((Throwable)e, OMException.ResultCodes.TENANT_AUTHORIZER_ERROR);
                }
            }
            finally {
                this.tenantCacheLock.readLock().unlock();
            }
        }
    }

    public class CacheOp
    implements TenantOp {
        private final Map<String, CachedTenantState> tenantCache;
        private final ReentrantReadWriteLock tenantCacheLock;

        CacheOp(Map<String, CachedTenantState> tenantCache, ReentrantReadWriteLock tenantCacheLock) {
            this.tenantCache = tenantCache;
            this.tenantCacheLock = tenantCacheLock;
        }

        @Override
        public void createTenant(String tenantId, String userRoleName, String adminRoleName) {
            this.tenantCacheLock.writeLock().lock();
            try {
                if (this.tenantCache.containsKey(tenantId)) {
                    LOG.warn("Cache entry for tenant '{}' already exists, will be overwritten", (Object)tenantId);
                }
                this.tenantCache.put(tenantId, new CachedTenantState(tenantId, userRoleName, adminRoleName));
            }
            finally {
                this.tenantCacheLock.writeLock().unlock();
            }
        }

        @Override
        public void deleteTenant(Tenant tenant) throws IOException {
            block4: {
                String tenantId = tenant.getTenantName();
                this.tenantCacheLock.writeLock().lock();
                try {
                    if (this.tenantCache.containsKey(tenantId)) {
                        LOG.info("Removing tenant from in-memory cache: {}", (Object)tenantId);
                        this.tenantCache.remove(tenantId);
                        break block4;
                    }
                    throw new OMException("Tenant does not exist in cache: " + tenantId, OMException.ResultCodes.INTERNAL_ERROR);
                }
                finally {
                    this.tenantCacheLock.writeLock().unlock();
                }
            }
        }

        @Override
        public void assignUserToTenant(String userPrincipal, String tenantId, String accessId) {
            CachedTenantState.CachedAccessIdInfo cacheEntry = new CachedTenantState.CachedAccessIdInfo(userPrincipal, false);
            this.tenantCacheLock.writeLock().lock();
            try {
                CachedTenantState cachedTenantState = this.tenantCache.get(tenantId);
                Preconditions.checkNotNull((Object)cachedTenantState, (Object)("Cache entry for tenant '" + tenantId + "' does not exist"));
                LOG.info("Adding to cache: user '{}' accessId '{}' in tenant '{}'", new Object[]{userPrincipal, accessId, tenantId});
                cachedTenantState.getAccessIdInfoMap().put(accessId, cacheEntry);
            }
            finally {
                this.tenantCacheLock.writeLock().unlock();
            }
        }

        @Override
        public void revokeUserAccessId(String accessId, String tenantId) throws IOException {
            this.tenantCacheLock.writeLock().lock();
            try {
                LOG.info("Removing from cache: accessId '{}' in tenant '{}'", (Object)accessId, (Object)tenantId);
                if (!this.tenantCache.get(tenantId).getAccessIdInfoMap().containsKey(accessId)) {
                    throw new OMException("accessId '" + accessId + "' doesn't exist " + "in tenant cache!", OMException.ResultCodes.INTERNAL_ERROR);
                }
                this.tenantCache.get(tenantId).getAccessIdInfoMap().remove(accessId);
            }
            finally {
                this.tenantCacheLock.writeLock().unlock();
            }
        }

        @Override
        public void assignTenantAdmin(String accessId, boolean delegated) throws IOException {
            this.tenantCacheLock.writeLock().lock();
            try {
                String tenantId = OMMultiTenantManagerImpl.this.getTenantForAccessIDThrowIfNotFound(accessId);
                CachedTenantState cachedTenantState = this.tenantCache.get(tenantId);
                LOG.info("Updating cache: accessId '{}' isAdmin '{}' isDelegated '{}'", new Object[]{accessId, true, delegated});
                cachedTenantState.getAccessIdInfoMap().get(accessId).setIsAdmin(true);
            }
            finally {
                this.tenantCacheLock.writeLock().unlock();
            }
        }

        @Override
        public void revokeTenantAdmin(String accessId) throws IOException {
            this.tenantCacheLock.writeLock().lock();
            try {
                String tenantId = OMMultiTenantManagerImpl.this.getTenantForAccessIDThrowIfNotFound(accessId);
                CachedTenantState cachedTenantState = this.tenantCache.get(tenantId);
                LOG.info("Updating cache: accessId '{}' isAdmin '{}' isDelegated '{}'", new Object[]{accessId, false, false});
                cachedTenantState.getAccessIdInfoMap().get(accessId).setIsAdmin(false);
            }
            finally {
                this.tenantCacheLock.writeLock().unlock();
            }
        }
    }
}

