/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.repair.om.quota;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.repair.RepairTool;
import org.apache.hadoop.ozone.repair.om.quota.QuotaRepair;
import picocli.CommandLine;

@CommandLine.Command(name="start", description={"CLI to trigger quota repair."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class QuotaTrigger
extends RepairTool {
    @CommandLine.ParentCommand
    private QuotaRepair parent;
    @CommandLine.Option(names={"--service-id", "--om-service-id"}, description={"Ozone Manager Service ID"}, required=false)
    private String omServiceId;
    @CommandLine.Option(names={"--service-host"}, description={"Ozone Manager Host. If OM HA is enabled, use --service-id instead. If you must use --service-host with OM HA, this must point directly to the leader OM. This option is required when --service-id is not provided or when HA is not enabled."})
    private String omHost;
    @CommandLine.Option(names={"--buckets"}, required=false, description={"start quota repair for specific buckets. Input will be list of uri separated by comma as /<volume>/<bucket>[,...]"})
    private String buckets;

    @Override
    public void execute() throws Exception {
        List<Object> bucketList = Collections.emptyList();
        if (StringUtils.isNotEmpty((CharSequence)this.buckets)) {
            bucketList = Arrays.asList(this.buckets.split(","));
        }
        try (OzoneManagerProtocolClientSideTranslatorPB omClient = this.parent.createOmClient(this.omServiceId, this.omHost, false);){
            this.info("Triggering quota repair for %s", bucketList.isEmpty() ? "all buckets" : "buckets " + this.buckets);
            if (!this.isDryRun()) {
                omClient.startQuotaRepair(bucketList);
                this.info(omClient.getQuotaRepairStatus(), new Object[0]);
            }
        }
    }
}

