/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.conf;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.conf.OzoneGetConf;
import picocli.CommandLine;

@CommandLine.Command(name="storagecontainermanagers", aliases={"-storagecontainermanagers"}, description={"gets list of ozone storage container manager nodes in the cluster"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class StorageContainerManagersCommandHandler
implements Callable<Void> {
    @CommandLine.ParentCommand
    private OzoneGetConf tool;

    @Override
    public Void call() throws Exception {
        Collection addresses = HddsUtils.getScmAddressForClients((ConfigurationSource)OzoneConfiguration.of((OzoneConfiguration)this.tool.getConf()));
        for (InetSocketAddress addr : addresses) {
            this.tool.printOut(addr.getHostName());
        }
        return null;
    }
}

