/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.scm;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.hdds.server.JsonUtils;
import org.apache.hadoop.ozone.admin.scm.ScmAdmin;
import org.apache.hadoop.ozone.utils.FormattingCLIUtils;
import picocli.CommandLine;

@CommandLine.Command(name="roles", description={"List all SCMs, their respective Ratis server roles and RaftPeerIds"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class GetScmRatisRolesSubcommand
extends ScmSubcommand {
    @CommandLine.ParentCommand
    private ScmAdmin parent;
    @CommandLine.Option(names={"--json"}, defaultValue="false", description={"Format output as JSON"})
    private boolean json;
    @CommandLine.Option(names={"--table"}, defaultValue="false", description={"Format output as Table"})
    private boolean table;
    private static final String SCM_ROLES_TITLE = "Storage Container Manager Roles";
    private static final List<String> SCM_ROLES_HEADER = Arrays.asList("Host Name", "Ratis Port", "Role", "Node ID", "Host Address");

    public void execute(ScmClient scmClient) throws IOException {
        List peerRoles = scmClient.getScmRoles();
        if (this.json) {
            Map<String, Map<String, String>> scmRoles = this.parseScmRoles(peerRoles);
            System.out.print(JsonUtils.toJsonStringWithDefaultPrettyPrinter(scmRoles));
        } else if (this.table) {
            FormattingCLIUtils formattingCLIUtils = new FormattingCLIUtils(SCM_ROLES_TITLE);
            formattingCLIUtils.addHeaders(SCM_ROLES_HEADER);
            for (String role : peerRoles) {
                Object[] roleItems = role.split(":");
                if (roleItems.length < 2) {
                    System.err.println("Invalid response received for ScmRatisRoles.");
                }
                formattingCLIUtils.addLine(roleItems);
            }
            System.out.println(formattingCLIUtils.render());
        } else {
            for (String role : peerRoles) {
                System.out.println(role);
            }
        }
    }

    private Map<String, Map<String, String>> parseScmRoles(List<String> peerRoles) {
        HashMap<String, Map<String, String>> allRoles = new HashMap<String, Map<String, String>>();
        for (String role : peerRoles) {
            HashMap<String, String> roleDetails = new HashMap<String, String>();
            String[] roles = role.split(":");
            if (roles.length < 2) {
                System.err.println("Invalid response received for ScmRatisRoles.");
                return Collections.emptyMap();
            }
            roleDetails.put("address", roles[0].concat(":").concat(roles[1]));
            if (roles.length == 5) {
                roleDetails.put("raftPeerRole", roles[2]);
                roleDetails.put("ID", roles[3]);
                roleDetails.put("InetAddress", roles[4]);
            }
            allRoles.put(roles[0], roleDetails);
        }
        return allRoles;
    }
}

