/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.managed.ManagedDBOptions;
import org.apache.hadoop.ozone.container.metadata.AbstractRDBStore;
import org.apache.hadoop.ozone.container.metadata.WitnessedContainerDBDefinition;
import org.apache.hadoop.ozone.container.metadata.WitnessedContainerMetadataStore;

public final class WitnessedContainerMetadataStoreImpl
extends AbstractRDBStore<WitnessedContainerDBDefinition>
implements WitnessedContainerMetadataStore {
    private Table<Long, String> containerIdsTable;
    private static final ConcurrentMap<String, WitnessedContainerMetadataStore> INSTANCES = new ConcurrentHashMap<String, WitnessedContainerMetadataStore>();

    public static WitnessedContainerMetadataStore get(ConfigurationSource conf) throws IOException {
        String dbDirPath = DBStoreBuilder.getDBDirPath((DBDefinition)WitnessedContainerDBDefinition.get(), (ConfigurationSource)conf).getAbsolutePath();
        try {
            return INSTANCES.compute(dbDirPath, (k, v) -> {
                if (v == null || v.isClosed()) {
                    try {
                        return new WitnessedContainerMetadataStoreImpl(conf, false);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return v;
            });
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private WitnessedContainerMetadataStoreImpl(ConfigurationSource config, boolean openReadOnly) throws IOException {
        super(WitnessedContainerDBDefinition.get(), config, openReadOnly);
    }

    @Override
    protected DBStore initDBStore(DBStoreBuilder dbStoreBuilder, ManagedDBOptions options, ConfigurationSource config) throws IOException {
        DBStore dbStore = dbStoreBuilder.build();
        this.containerIdsTable = ((WitnessedContainerDBDefinition)((Object)this.getDbDef())).getContainerIdsTable().getTable(dbStore);
        return dbStore;
    }

    @Override
    public Table<Long, String> getContainerIdsTable() {
        return this.containerIdsTable;
    }
}

