/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.datanode.proto.XceiverClientProtocolServiceGrpc;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDispatcher;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.ratis.grpc.util.ZeroCopyMessageMarshaller;
import org.apache.ratis.thirdparty.com.google.protobuf.MessageLite;
import org.apache.ratis.thirdparty.io.grpc.MethodDescriptor;
import org.apache.ratis.thirdparty.io.grpc.ServerCallHandler;
import org.apache.ratis.thirdparty.io.grpc.ServerServiceDefinition;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcXceiverService
extends XceiverClientProtocolServiceGrpc.XceiverClientProtocolServiceImplBase {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcXceiverService.class);
    private final ContainerDispatcher dispatcher;
    private final ZeroCopyMessageMarshaller<ContainerProtos.ContainerCommandRequestProto> zeroCopyMessageMarshaller = new ZeroCopyMessageMarshaller((MessageLite)ContainerProtos.ContainerCommandRequestProto.getDefaultInstance());

    public GrpcXceiverService(ContainerDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public ServerServiceDefinition bindServiceWithZeroCopy() {
        ServerServiceDefinition orig = super.bindService();
        ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((String)orig.getServiceDescriptor().getName());
        GrpcXceiverService.addZeroCopyMethod(orig, builder, XceiverClientProtocolServiceGrpc.getSendMethod(), this.zeroCopyMessageMarshaller);
        orig.getMethods().stream().filter(x -> !x.getMethodDescriptor().getFullMethodName().equals(XceiverClientProtocolServiceGrpc.getSendMethod().getFullMethodName())).forEach(arg_0 -> ((ServerServiceDefinition.Builder)builder).addMethod(arg_0));
        return builder.build();
    }

    private static <Req extends MessageLite, Resp> void addZeroCopyMethod(ServerServiceDefinition orig, ServerServiceDefinition.Builder newServiceBuilder, MethodDescriptor<Req, Resp> origMethod, ZeroCopyMessageMarshaller<Req> zeroCopyMarshaller) {
        MethodDescriptor newMethod = origMethod.toBuilder().setRequestMarshaller(zeroCopyMarshaller).build();
        ServerCallHandler serverCallHandler = orig.getMethod(newMethod.getFullMethodName()).getServerCallHandler();
        newServiceBuilder.addMethod(newMethod, serverCallHandler);
    }

    public StreamObserver<ContainerProtos.ContainerCommandRequestProto> send(final StreamObserver<ContainerProtos.ContainerCommandResponseProto> responseObserver) {
        return new StreamObserver<ContainerProtos.ContainerCommandRequestProto>(){
            private final AtomicBoolean isClosed = new AtomicBoolean(false);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(ContainerProtos.ContainerCommandRequestProto request) {
                DispatcherContext context = request.getCmdType() != ContainerProtos.Type.ReadChunk ? null : DispatcherContext.newBuilder(DispatcherContext.Op.HANDLE_READ_CHUNK).setReleaseSupported(true).build();
                try {
                    ContainerProtos.ContainerCommandResponseProto resp = GrpcXceiverService.this.dispatcher.dispatch(request, context);
                    responseObserver.onNext((Object)resp);
                }
                catch (Throwable e) {
                    LOG.error("Got exception when processing ContainerCommandRequestProto {}", (Object)request, (Object)e);
                    this.isClosed.set(true);
                    responseObserver.onError(e);
                }
                finally {
                    GrpcXceiverService.this.zeroCopyMessageMarshaller.release((MessageLite)request);
                    if (context != null) {
                        context.release();
                    }
                }
            }

            public void onError(Throwable t) {
                LOG.error("ContainerCommand send on error. Exception: ", t);
            }

            public void onCompleted() {
                if (this.isClosed.compareAndSet(false, true)) {
                    LOG.debug("ContainerCommand send completed");
                    responseObserver.onCompleted();
                }
            }
        };
    }
}

