/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.ratis.conf.RatisClientConfig;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.ratis.protocol.exceptions.AlreadyClosedException;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.protocol.exceptions.NotReplicatedException;
import org.apache.ratis.protocol.exceptions.RaftRetryFailureException;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class HddsClientUtils {
    private static final List<Class<? extends Exception>> EXCEPTION_LIST = ImmutableList.builder().add(TimeoutException.class).add(StorageContainerException.class).add(RaftRetryFailureException.class).add(AlreadyClosedException.class).add(GroupMismatchException.class).add(NotReplicatedException.class).build();

    private HddsClientUtils() {
    }

    private static void doNameChecks(String resName, String resType) {
        if (resName == null) {
            throw new IllegalArgumentException(resType + " name is null");
        }
        if (resName.length() < 3 || resName.length() > 63) {
            throw new IllegalArgumentException(resType + " length is illegal, valid length is 3-63 characters");
        }
        if (resName.charAt(0) == '.' || resName.charAt(0) == '-') {
            throw new IllegalArgumentException(resType + " name cannot start with a period or dash");
        }
        if (resName.charAt(resName.length() - 1) == '.' || resName.charAt(resName.length() - 1) == '-') {
            throw new IllegalArgumentException(resType + " name cannot end with a period or dash");
        }
    }

    private static boolean isSupportedCharacter(char c, boolean isStrictS3) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c == '-' || c == '.') {
            return true;
        }
        return c == '_' && !isStrictS3;
    }

    private static void doCharacterChecks(char currChar, char prev, String resType, boolean isStrictS3) {
        if (Character.isUpperCase(currChar)) {
            throw new IllegalArgumentException(resType + " name does not support uppercase characters");
        }
        if (!HddsClientUtils.isSupportedCharacter(currChar, isStrictS3)) {
            throw new IllegalArgumentException(resType + " name has an unsupported character : " + currChar);
        }
        if (prev == '.' && currChar == '.') {
            throw new IllegalArgumentException(resType + " name should not have two contiguous periods");
        }
        if (prev == '-' && currChar == '.') {
            throw new IllegalArgumentException(resType + " name should not have period after dash");
        }
        if (prev == '.' && currChar == '-') {
            throw new IllegalArgumentException(resType + " name should not have dash after period");
        }
    }

    public static void verifyResourceName(String resName) {
        HddsClientUtils.verifyResourceName(resName, "resource", true);
    }

    public static void verifyResourceName(String resName, String resType) {
        HddsClientUtils.verifyResourceName(resName, resType, true);
    }

    public static void verifyResourceName(String resName, String resType, boolean isStrictS3) {
        HddsClientUtils.doNameChecks(resName, resType);
        boolean isIPv4 = true;
        char prev = '\u0000';
        for (int index = 0; index < resName.length(); ++index) {
            char currChar = resName.charAt(index);
            if (currChar != '.') {
                isIPv4 = currChar >= '0' && currChar <= '9' && isIPv4;
            }
            HddsClientUtils.doCharacterChecks(currChar, prev, resType, isStrictS3);
            prev = currChar;
        }
        if (isIPv4) {
            throw new IllegalArgumentException(resType + " name cannot be an IPv4 address or all numeric");
        }
    }

    public static void verifyKeyName(String keyName) {
        if (keyName == null) {
            throw new IllegalArgumentException("Key name is null");
        }
        if (!OzoneConsts.KEYNAME_ILLEGAL_CHARACTER_CHECK_REGEX.matcher(keyName).matches()) {
            throw new IllegalArgumentException("Invalid key name: " + keyName);
        }
    }

    public static <T> void checkNotNull(T ... references) {
        for (T ref : references) {
            Preconditions.checkNotNull(ref);
        }
    }

    public static int getListCacheSize(ConfigurationSource conf) {
        return conf.getInt("ozone.client.list.cache", 1000);
    }

    public static String getDefaultS3VolumeName(ConfigurationSource conf) {
        return conf.get("ozone.s3g.volume.name", "s3v");
    }

    public static int getMaxOutstandingRequests(ConfigurationSource config) {
        return ((RatisClientConfig.RaftConfig)config.getObject(RatisClientConfig.RaftConfig.class)).getMaxOutstandingRequests();
    }

    public static Throwable checkForException(Exception e) {
        Throwable t;
        for (t = e; t != null && t.getCause() != null; t = t.getCause()) {
            for (Class<? extends Exception> cls : HddsClientUtils.getExceptionList()) {
                if (!cls.isInstance(t)) continue;
                return t;
            }
        }
        return t;
    }

    public static Throwable containsException(Throwable t, Class<? extends Exception> expectedExceptionClass) {
        while (t != null) {
            if (expectedExceptionClass.isInstance(t)) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }

    public static RetryPolicy createRetryPolicy(int maxRetryCount, long retryInterval) {
        return RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)maxRetryCount, (long)retryInterval, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static Map<Class<? extends Throwable>, RetryPolicy> getRetryPolicyByException(int maxRetryCount, long retryInterval) {
        HashMap<Class<? extends Throwable>, RetryPolicy> policyMap = new HashMap<Class<? extends Throwable>, RetryPolicy>();
        for (Class<? extends Exception> ex : EXCEPTION_LIST) {
            if (ex == TimeoutException.class || ex == RaftRetryFailureException.class) {
                policyMap.put(ex, HddsClientUtils.createRetryPolicy(maxRetryCount, 0L));
                continue;
            }
            policyMap.put(ex, HddsClientUtils.createRetryPolicy(maxRetryCount, retryInterval));
        }
        policyMap.put(Exception.class, HddsClientUtils.createRetryPolicy(maxRetryCount, retryInterval));
        return policyMap;
    }

    public static List<Class<? extends Exception>> getExceptionList() {
        return EXCEPTION_LIST;
    }
}

