/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;

@Singleton
public final class FeatureProvider {
    private static EnumMap<Feature, Boolean> featureDisableMap = new EnumMap(Feature.class);

    private FeatureProvider() {
    }

    public static EnumMap<Feature, Boolean> getFeatureDisableMap() {
        return featureDisableMap;
    }

    public static List<Feature> getAllDisabledFeatures() {
        return FeatureProvider.getFeatureDisableMap().keySet().stream().filter(feature -> Boolean.TRUE.equals(FeatureProvider.getFeatureDisableMap().get(feature))).collect(Collectors.toList());
    }

    public static void initFeatureSupport(OzoneConfiguration ozoneConfiguration) {
        FeatureProvider.resetInitOfFeatureSupport();
        String heatMapProviderCls = ozoneConfiguration.get("ozone.recon.heatmap.provider");
        boolean heatMapEnabled = ozoneConfiguration.getBoolean("ozone.recon.heatmap.enable", false);
        if (!heatMapEnabled || StringUtils.isEmpty((CharSequence)heatMapProviderCls)) {
            FeatureProvider.getFeatureDisableMap().put(Feature.HEATMAP, true);
        }
    }

    private static void resetInitOfFeatureSupport() {
        FeatureProvider.getFeatureDisableMap().keySet().forEach(feature -> FeatureProvider.getFeatureDisableMap().put((Feature)((Object)feature), false));
    }

    public static enum Feature {
        HEATMAP("HeatMap");

        private String featureName;

        public String getFeatureName() {
            return this.featureName;
        }

        private Feature(String featureName) {
            this.featureName = featureName;
        }

        public static Feature of(String featureName) {
            Feature featureEnum = Arrays.stream(Feature.values()).filter(feature -> feature.getFeatureName().equals(featureName)).findFirst().get();
            if (null == featureEnum) {
                throw new IllegalArgumentException("Unrecognized value for Features enum: " + featureName);
            }
            return featureEnum;
        }
    }
}

