/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.recon.MetricsServiceProviderFactory;
import org.apache.hadoop.ozone.recon.api.types.PipelineMetadata;
import org.apache.hadoop.ozone.recon.api.types.PipelinesResponse;
import org.apache.hadoop.ozone.recon.metrics.Metric;
import org.apache.hadoop.ozone.recon.scm.ReconPipelineManager;
import org.apache.hadoop.ozone.recon.spi.MetricsServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/pipelines")
@Produces(value={"application/json"})
public class PipelineEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineEndpoint.class);
    private ReconPipelineManager pipelineManager;
    private MetricsServiceProvider metricsServiceProvider;

    @Inject
    PipelineEndpoint(OzoneStorageContainerManager reconSCM, MetricsServiceProviderFactory metricsServiceProviderFactory) {
        this.pipelineManager = (ReconPipelineManager)reconSCM.getPipelineManager();
        this.metricsServiceProvider = metricsServiceProviderFactory.getMetricsServiceProvider();
    }

    @GET
    public Response getPipelines() {
        ArrayList<PipelineMetadata> pipelinesList = new ArrayList<PipelineMetadata>();
        List pipelines = this.pipelineManager.getPipelines();
        pipelines.forEach(pipeline -> {
            UUID pipelineId = pipeline.getId().getId();
            ArrayList<DatanodeDetails> datanodes = new ArrayList<DatanodeDetails>();
            PipelineMetadata.Builder builder = PipelineMetadata.newBuilder();
            pipeline.getNodes().forEach(node -> datanodes.add((DatanodeDetails)node));
            long duration = Instant.now().toEpochMilli() - pipeline.getCreationTimestamp().toEpochMilli();
            try {
                String leaderNode = pipeline.getLeaderNode().getHostName();
                builder.setLeaderNode(leaderNode);
            }
            catch (IOException ioEx) {
                LOG.warn("Cannot get leader node for pipeline {}", (Object)pipelineId, (Object)ioEx);
            }
            try {
                int containers = this.pipelineManager.getNumberOfContainers(pipeline.getId());
                builder.setContainers(containers);
            }
            catch (IOException ioEx) {
                LOG.warn("Cannot get containers for pipeline {} ", (Object)pipelineId, (Object)ioEx);
            }
            PipelineMetadata.Builder pipelineBuilder = builder.setPipelineId(pipelineId).setDatanodes(datanodes).setDuration(duration).setStatus(pipeline.getPipelineState()).setReplicationConfig(pipeline.getReplicationConfig());
            if (this.metricsServiceProvider != null) {
                String[] splits = pipelineId.toString().split("-");
                String groupId = "group-" + splits[splits.length - 1].toUpperCase();
                Long leaderElectionCount = this.getElectionCountMetricValue(groupId);
                pipelineBuilder.setLeaderElections(leaderElectionCount);
                Long lastLeaderElectionElapsedTime = this.getLastLeaderElectionElapsedTimeMetricValue(groupId, pipeline.getLeaderId());
                pipelineBuilder.setLastLeaderElection(lastLeaderElectionElapsedTime);
            }
            pipelinesList.add(pipelineBuilder.build());
        });
        PipelinesResponse pipelinesResponse = new PipelinesResponse(pipelinesList.size(), pipelinesList);
        return Response.ok((Object)pipelinesResponse).build();
    }

    private Long getElectionCountMetricValue(String groupId) {
        Long electionCount;
        block4: {
            electionCount = 0L;
            String metricsQuery = String.format("query=ratis_leader_election_electionCount{group=\"%s\"}", groupId);
            try {
                List<Metric> metrics = this.metricsServiceProvider.getMetricsInstant(metricsQuery);
                if (!metrics.isEmpty()) {
                    for (Metric m : metrics) {
                        TreeMap values = (TreeMap)m.getValues();
                        if (values.isEmpty()) continue;
                        electionCount = electionCount + ((Double)values.firstEntry().getValue()).longValue();
                    }
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error("Unable to get metrics value for ratis_leader_election_electionCount", (Throwable)ex);
            }
        }
        return electionCount;
    }

    private Long getLastLeaderElectionElapsedTimeMetricValue(String groupId, UUID uuid) {
        block3: {
            String metricsQuery = String.format("query=ratis_leader_election_lastLeaderElectionElapsedTime{group=\"%s\",exported_instance=\"%s\"}", groupId, uuid.toString());
            try {
                TreeMap values;
                List<Metric> metrics = this.metricsServiceProvider.getMetricsInstant(metricsQuery);
                if (!metrics.isEmpty() && !(values = (TreeMap)metrics.get(0).getValues()).isEmpty()) {
                    return ((Double)values.firstEntry().getValue()).longValue();
                }
            }
            catch (Exception ex) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error("Unable to get metrics value for ratis_leader_election_lastLeaderElectionElapsedTime", (Throwable)ex);
            }
        }
        return 0L;
    }
}

