/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jooq.Catalog;
import org.jooq.Configuration;
import org.jooq.DataType;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Named;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.UniqueKey;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractMeta;
import org.jooq.impl.AbstractTable;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.IndexImpl;
import org.jooq.impl.Internal;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.SequenceImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tools;
import org.jooq.impl.UniqueKeyImpl;
import org.jooq.util.xml.jaxb.Column;
import org.jooq.util.xml.jaxb.IndexColumnUsage;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.KeyColumnUsage;
import org.jooq.util.xml.jaxb.ReferentialConstraint;
import org.jooq.util.xml.jaxb.TableConstraint;
import org.jooq.util.xml.jaxb.TableConstraintType;

final class InformationSchemaMetaImpl
extends AbstractMeta {
    private static final long serialVersionUID = -1623783405104005307L;
    private final Configuration configuration;
    private final InformationSchema source;
    private final List<Catalog> catalogs;
    private final Map<Name, Catalog> catalogsByName;
    private final List<Schema> schemas;
    private final Map<Name, Schema> schemasByName;
    private final Map<Catalog, List<Schema>> schemasPerCatalog;
    private final List<InformationSchemaTable> tables;
    private final Map<Name, InformationSchemaTable> tablesByName;
    private final Map<Schema, List<InformationSchemaTable>> tablesPerSchema;
    private final List<Sequence<?>> sequences;
    private final Map<Schema, List<Sequence<?>>> sequencesPerSchema;
    private final List<UniqueKeyImpl<Record>> primaryKeys;
    private final Map<Name, UniqueKeyImpl<Record>> uniqueKeysByName;
    private final Map<Name, Name> referentialKeys;
    private final Map<Name, IndexImpl> indexesByName;

    InformationSchemaMetaImpl(Configuration configuration, InformationSchema source) {
        this.configuration = configuration;
        this.source = source;
        this.catalogs = new ArrayList<Catalog>();
        this.catalogsByName = new HashMap<Name, Catalog>();
        this.schemas = new ArrayList<Schema>();
        this.schemasByName = new HashMap<Name, Schema>();
        this.schemasPerCatalog = new HashMap<Catalog, List<Schema>>();
        this.tables = new ArrayList<InformationSchemaTable>();
        this.tablesByName = new HashMap<Name, InformationSchemaTable>();
        this.tablesPerSchema = new HashMap<Schema, List<InformationSchemaTable>>();
        this.sequences = new ArrayList();
        this.sequencesPerSchema = new HashMap();
        this.primaryKeys = new ArrayList<UniqueKeyImpl<Record>>();
        this.uniqueKeysByName = new HashMap<Name, UniqueKeyImpl<Record>>();
        this.referentialKeys = new HashMap<Name, Name>();
        this.indexesByName = new HashMap<Name, IndexImpl>();
        this.init(source);
    }

    /*
     * WARNING - void declaration
     */
    private final void init(InformationSchema meta) {
        List<Named> list;
        List c;
        Name constraintName;
        InformationSchemaTable table;
        InformationSchemaCatalog ic;
        ArrayList<String> errors = new ArrayList<String>();
        boolean hasCatalogs = false;
        for (org.jooq.util.xml.jaxb.Catalog catalog : meta.getCatalogs()) {
            ic = new InformationSchemaCatalog(catalog.getCatalogName(), catalog.getComment());
            this.catalogs.add(ic);
            this.catalogsByName.put(DSL.name(catalog.getCatalogName()), ic);
            hasCatalogs = true;
        }
        for (org.jooq.util.xml.jaxb.Schema schema : meta.getSchemata()) {
            Name catalogName;
            Catalog catalog;
            if (!hasCatalogs && !this.catalogs.contains(ic = new InformationSchemaCatalog(schema.getCatalogName(), null))) {
                this.catalogs.add(ic);
                this.catalogsByName.put(DSL.name(schema.getCatalogName()), ic);
            }
            if ((catalog = this.catalogsByName.get(catalogName = DSL.name(schema.getCatalogName()))) == null) {
                errors.add(String.format("Catalog " + catalogName + " not defined for schema " + schema.getSchemaName(), new Object[0]));
                continue;
            }
            InformationSchemaSchema is = new InformationSchemaSchema(schema.getSchemaName(), catalog, schema.getComment());
            this.schemas.add(is);
            this.schemasByName.put(DSL.name(schema.getCatalogName(), schema.getSchemaName()), is);
        }
        for (org.jooq.util.xml.jaxb.Table table2 : meta.getTables()) {
            Name schemaName = DSL.name(table2.getTableCatalog(), table2.getTableSchema());
            Schema schema = this.schemasByName.get(schemaName);
            if (schema == null) {
                errors.add(String.format("Schema " + schemaName + " not defined for table " + table2.getTableName(), new Object[0]));
                continue;
            }
            InformationSchemaTable it = new InformationSchemaTable(table2.getTableName(), schema, table2.getComment());
            this.tables.add(it);
            this.tablesByName.put(DSL.name(table2.getTableCatalog(), table2.getTableSchema(), table2.getTableName()), it);
        }
        ArrayList<Column> columns = new ArrayList<Column>(meta.getColumns());
        Collections.sort(columns, new Comparator<Column>(){

            @Override
            public int compare(Column o1, Column o2) {
                Integer p2;
                Integer p1 = o1.getOrdinalPosition();
                if (p1 == (p2 = o2.getOrdinalPosition())) {
                    return 0;
                }
                if (p1 == null) {
                    return -1;
                }
                if (p2 == null) {
                    return 1;
                }
                return p1.compareTo(p2);
            }
        });
        for (Column xc : columns) {
            Iterator<org.jooq.util.xml.jaxb.Index> typeName = xc.getDataType();
            int length = xc.getCharacterMaximumLength() == null ? 0 : xc.getCharacterMaximumLength();
            int precision = xc.getNumericPrecision() == null ? 0 : xc.getNumericPrecision();
            int n = xc.getNumericScale() == null ? 0 : xc.getNumericScale();
            boolean nullable = xc.isIsNullable() == null ? true : xc.isIsNullable();
            Name tableName = DSL.name(xc.getTableCatalog(), xc.getTableSchema(), xc.getTableName());
            table = this.tablesByName.get(tableName);
            if (table == null) {
                errors.add(String.format("Table " + tableName + " not defined for column " + xc.getColumnName(), new Object[0]));
                continue;
            }
            AbstractTable.createField(xc.getColumnName(), this.type((String)((Object)typeName), length, precision, n, nullable), table, xc.getComment());
        }
        HashMap hashMap = new HashMap();
        ArrayList<IndexColumnUsage> indexColumnUsages = new ArrayList<IndexColumnUsage>(meta.getIndexColumnUsages());
        Collections.sort(indexColumnUsages, new Comparator<IndexColumnUsage>(){

            @Override
            public int compare(IndexColumnUsage o1, IndexColumnUsage o2) {
                int p2;
                int p1 = o1.getOrdinalPosition();
                return p1 < (p2 = o2.getOrdinalPosition()) ? -1 : (p1 == p2 ? 0 : 1);
            }
        });
        for (IndexColumnUsage ic2 : indexColumnUsages) {
            void var10_26;
            Name tableName;
            InformationSchemaTable table2;
            Name indexName = DSL.name(ic2.getIndexCatalog(), ic2.getIndexSchema(), ic2.getTableName(), ic2.getIndexName());
            List list2 = (List)hashMap.get(indexName);
            if (list2 == null) {
                ArrayList arrayList = new ArrayList();
                hashMap.put(indexName, arrayList);
            }
            if ((table2 = this.tablesByName.get(tableName = DSL.name(ic2.getTableCatalog(), ic2.getTableSchema(), ic2.getTableName()))) == null) {
                errors.add(String.format("Table " + tableName + " not defined for index " + indexName, new Object[0]));
                continue;
            }
            TableField field = (TableField)table2.field(ic2.getColumnName());
            if (field == null) {
                errors.add(String.format("Column " + ic2.getColumnName() + " not defined for table " + tableName, new Object[0]));
                continue;
            }
            var10_26.add(Boolean.TRUE.equals(ic2.isIsDescending()) ? field.desc() : field.asc());
        }
        for (org.jooq.util.xml.jaxb.Index i : meta.getIndexes()) {
            Name tableName = DSL.name(i.getTableCatalog(), i.getTableSchema(), i.getTableName());
            Name name = DSL.name(i.getIndexCatalog(), i.getIndexSchema(), i.getTableName(), i.getIndexName());
            InformationSchemaTable table3 = this.tablesByName.get(tableName);
            if (table3 == null) {
                errors.add(String.format("Table " + tableName + " not defined for index " + name, new Object[0]));
                continue;
            }
            List c2 = (List)hashMap.get(name);
            if (c2 == null || c2.isEmpty()) {
                errors.add(String.format("No columns defined for index " + name, new Object[0]));
                continue;
            }
            IndexImpl index = (IndexImpl)Internal.createIndex(i.getIndexName(), table3, (OrderField[])c2.toArray(Tools.EMPTY_SORTFIELD), Boolean.TRUE.equals(i.isIsUnique()));
            table3.indexes.add(index);
            this.indexesByName.put(name, index);
        }
        HashMap columnsByConstraint = new HashMap();
        ArrayList<KeyColumnUsage> keyColumnUsages = new ArrayList<KeyColumnUsage>(meta.getKeyColumnUsages());
        Collections.sort(keyColumnUsages, new Comparator<KeyColumnUsage>(){

            @Override
            public int compare(KeyColumnUsage o1, KeyColumnUsage o2) {
                int p2;
                int p1 = o1.getOrdinalPosition();
                return p1 < (p2 = o2.getOrdinalPosition()) ? -1 : (p1 == p2 ? 0 : 1);
            }
        });
        for (KeyColumnUsage keyColumnUsage : keyColumnUsages) {
            Name tableName;
            InformationSchemaTable table4;
            Name constraintName2 = DSL.name(keyColumnUsage.getConstraintCatalog(), keyColumnUsage.getConstraintSchema(), keyColumnUsage.getConstraintName());
            ArrayList<TableField> fields = (ArrayList<TableField>)columnsByConstraint.get(constraintName2);
            if (fields == null) {
                fields = new ArrayList<TableField>();
                columnsByConstraint.put(constraintName2, fields);
            }
            if ((table4 = this.tablesByName.get(tableName = DSL.name(keyColumnUsage.getTableCatalog(), keyColumnUsage.getTableSchema(), keyColumnUsage.getTableName()))) == null) {
                errors.add(String.format("Table " + tableName + " not defined for constraint " + constraintName2, new Object[0]));
                continue;
            }
            TableField field = (TableField)table4.field(keyColumnUsage.getColumnName());
            if (field == null) {
                errors.add(String.format("Column " + keyColumnUsage.getColumnName() + " not defined for table " + tableName, new Object[0]));
                continue;
            }
            fields.add(field);
        }
        for (TableConstraint tableConstraint : meta.getTableConstraints()) {
            switch (tableConstraint.getConstraintType()) {
                case PRIMARY_KEY: 
                case UNIQUE: {
                    Name tableName = DSL.name(tableConstraint.getTableCatalog(), tableConstraint.getTableSchema(), tableConstraint.getTableName());
                    constraintName = DSL.name(tableConstraint.getConstraintCatalog(), tableConstraint.getConstraintSchema(), tableConstraint.getConstraintName());
                    table = this.tablesByName.get(tableName);
                    if (table == null) {
                        errors.add(String.format("Table " + tableName + " not defined for constraint " + constraintName, new Object[0]));
                        break;
                    }
                    c = (List)columnsByConstraint.get(constraintName);
                    if (c == null || c.isEmpty()) {
                        errors.add(String.format("No columns defined for constraint " + constraintName, new Object[0]));
                        break;
                    }
                    UniqueKeyImpl key = (UniqueKeyImpl)Internal.createUniqueKey(table, tableConstraint.getConstraintName(), c.toArray(new TableField[0]));
                    if (tableConstraint.getConstraintType() == TableConstraintType.PRIMARY_KEY) {
                        table.primaryKey = key;
                        this.primaryKeys.add(key);
                    }
                    table.uniqueKeys.add(key);
                    this.uniqueKeysByName.put(constraintName, key);
                    break;
                }
            }
        }
        for (ReferentialConstraint referentialConstraint : meta.getReferentialConstraints()) {
            this.referentialKeys.put(DSL.name(referentialConstraint.getConstraintCatalog(), referentialConstraint.getConstraintSchema(), referentialConstraint.getConstraintName()), DSL.name(referentialConstraint.getUniqueConstraintCatalog(), referentialConstraint.getUniqueConstraintSchema(), referentialConstraint.getUniqueConstraintName()));
        }
        for (TableConstraint tableConstraint : meta.getTableConstraints()) {
            switch (tableConstraint.getConstraintType()) {
                case FOREIGN_KEY: {
                    Name tableName = DSL.name(tableConstraint.getTableCatalog(), tableConstraint.getTableSchema(), tableConstraint.getTableName());
                    constraintName = DSL.name(tableConstraint.getConstraintCatalog(), tableConstraint.getConstraintSchema(), tableConstraint.getConstraintName());
                    table = this.tablesByName.get(tableName);
                    if (table == null) {
                        errors.add(String.format("Table " + tableName + " not defined for constraint " + constraintName, new Object[0]));
                        break;
                    }
                    c = (List)columnsByConstraint.get(constraintName);
                    if (c == null || c.isEmpty()) {
                        errors.add(String.format("No columns defined for constraint " + constraintName, new Object[0]));
                        break;
                    }
                    UniqueKeyImpl<Record> uniqueKey = this.uniqueKeysByName.get(this.referentialKeys.get(constraintName));
                    if (uniqueKey == null) {
                        errors.add(String.format("No unique key defined for foreign key " + constraintName, new Object[0]));
                        break;
                    }
                    ForeignKey<Record, Record> key = Internal.createForeignKey(uniqueKey, table, tableConstraint.getConstraintName(), c.toArray(new TableField[0]));
                    table.foreignKeys.add(key);
                    break;
                }
            }
        }
        for (org.jooq.util.xml.jaxb.Sequence sequence : meta.getSequences()) {
            Name schemaName = DSL.name(sequence.getSequenceCatalog(), sequence.getSequenceSchema());
            Schema schema = this.schemasByName.get(schemaName);
            if (schema == null) {
                errors.add(String.format("Schema " + schemaName + " not defined for sequence " + sequence.getSequenceName(), new Object[0]));
                continue;
            }
            String typeName = sequence.getDataType();
            int length = sequence.getCharacterMaximumLength() == null ? 0 : sequence.getCharacterMaximumLength();
            int precision = sequence.getNumericPrecision() == null ? 0 : sequence.getNumericPrecision();
            int scale = sequence.getNumericScale() == null ? 0 : sequence.getNumericScale();
            boolean nullable = true;
            InformationSchemaSequence is = new InformationSchemaSequence(sequence.getSequenceName(), schema, this.type(typeName, length, precision, scale, nullable));
            this.sequences.add(is);
        }
        for (Schema schema : this.schemas) {
            Catalog c3 = schema.getCatalog();
            list = this.schemasPerCatalog.get(c3);
            if (list == null) {
                list = new ArrayList<Schema>();
                this.schemasPerCatalog.put(c3, list);
            }
            list.add(schema);
        }
        for (InformationSchemaTable informationSchemaTable : this.tables) {
            Schema s = informationSchemaTable.getSchema();
            list = this.tablesPerSchema.get(s);
            if (list == null) {
                list = new ArrayList();
                this.tablesPerSchema.put(s, list);
            }
            list.add((Schema)((Object)informationSchemaTable));
        }
        for (Sequence sequence : this.sequences) {
            Schema s = sequence.getSchema();
            list = this.sequencesPerSchema.get(s);
            if (list == null) {
                list = new ArrayList();
                this.sequencesPerSchema.put(s, list);
            }
            list.add(sequence);
        }
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(((Object)errors).toString());
        }
    }

    private final DataType<?> type(String typeName, int length, int precision, int scale, boolean nullable) {
        DataType<Object> type = null;
        try {
            type = DefaultDataType.getDataType(this.configuration.family(), typeName);
            type = type.nullable(nullable);
            if (length != 0) {
                type = type.length(length);
            } else if (precision != 0 || scale != 0) {
                type = type.precision(precision, scale);
            }
        }
        catch (SQLDialectNotSupportedException e) {
            type = SQLDataType.OTHER;
        }
        return type;
    }

    @Override
    public final List<Catalog> getCatalogs() {
        return Collections.unmodifiableList(this.catalogs);
    }

    @Override
    public final List<Schema> getSchemas() {
        return Collections.unmodifiableList(this.schemas);
    }

    @Override
    public final List<Table<?>> getTables() {
        return Collections.unmodifiableList(this.tables);
    }

    @Override
    public final List<Sequence<?>> getSequences() {
        return Collections.unmodifiableList(this.sequences);
    }

    @Override
    public final List<UniqueKey<?>> getPrimaryKeys() {
        return Collections.unmodifiableList(this.primaryKeys);
    }

    public String toString() {
        return "" + this.source;
    }

    private final class InformationSchemaSequence<N extends Number>
    extends SequenceImpl<N> {
        private static final long serialVersionUID = -1246697252597049756L;

        InformationSchemaSequence(String name, Schema schema, DataType<N> type) {
            super(name, schema, type);
        }
    }

    private final class InformationSchemaTable
    extends TableImpl<Record> {
        private static final long serialVersionUID = 4314110578549768267L;
        UniqueKey<Record> primaryKey;
        final List<UniqueKey<Record>> uniqueKeys;
        final List<ForeignKey<Record, Record>> foreignKeys;
        final List<Index> indexes;

        public InformationSchemaTable(String name, Schema schema, String comment) {
            super(name, schema, null, null, comment);
            this.uniqueKeys = new ArrayList<UniqueKey<Record>>();
            this.foreignKeys = new ArrayList<ForeignKey<Record, Record>>();
            this.indexes = new ArrayList<Index>();
        }

        @Override
        public List<Index> getIndexes() {
            return Collections.unmodifiableList(this.indexes);
        }

        @Override
        public UniqueKey<Record> getPrimaryKey() {
            return this.primaryKey;
        }

        @Override
        public List<UniqueKey<Record>> getKeys() {
            return Collections.unmodifiableList(this.uniqueKeys);
        }

        @Override
        public List<ForeignKey<Record, ?>> getReferences() {
            return Collections.unmodifiableList(this.foreignKeys);
        }
    }

    private final class InformationSchemaSchema
    extends SchemaImpl {
        private static final long serialVersionUID = 7290709749127378187L;

        public InformationSchemaSchema(String name, Catalog catalog, String comment) {
            super(name, catalog, comment);
        }

        @Override
        public final List<Table<?>> getTables() {
            return Collections.unmodifiableList((List)InformationSchemaMetaImpl.this.tablesPerSchema.get(this));
        }

        @Override
        public final List<Sequence<?>> getSequences() {
            return Collections.unmodifiableList((List)InformationSchemaMetaImpl.this.sequencesPerSchema.get(this));
        }
    }

    private final class InformationSchemaCatalog
    extends CatalogImpl {
        private static final long serialVersionUID = 87038321849045492L;

        InformationSchemaCatalog(String name, String comment) {
            super(name, comment);
        }

        @Override
        public final List<Schema> getSchemas() {
            return Collections.unmodifiableList((List)InformationSchemaMetaImpl.this.schemasPerCatalog.get(this));
        }
    }
}

