/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.EnumSet;
import java.util.Map;
import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractQueryPartMap;
import org.jooq.impl.Tools;

final class FieldMapForUpdate
extends AbstractQueryPartMap<Field<?>, Field<?>> {
    private static final long serialVersionUID = -6139709404698673799L;
    private static final EnumSet<SQLDialect> NO_SUPPORT_QUALIFY = EnumSet.of(SQLDialect.POSTGRES, SQLDialect.SQLITE);
    private final Table<?> table;
    private final Clause assignmentClause;

    FieldMapForUpdate(Table<?> table, Clause assignmentClause) {
        this.table = table;
        this.assignmentClause = assignmentClause;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.size() > 0) {
            String separator = "";
            boolean restoreQualify = ctx.qualify();
            boolean supportsQualify = NO_SUPPORT_QUALIFY.contains((Object)ctx.family()) ? false : restoreQualify;
            for (Map.Entry entry : this.entrySet()) {
                ctx.sql(separator);
                if (!"".equals(separator)) {
                    ctx.formatNewLine();
                }
                ctx.start(this.assignmentClause).qualify(supportsQualify).visit((QueryPart)entry.getKey()).qualify(restoreQualify).sql(" = ").visit((QueryPart)entry.getValue()).end(this.assignmentClause);
                separator = ", ";
            }
        } else {
            ctx.sql("[ no fields are updated ]");
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    final void set(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Field<?> field = Tools.tableField(this.table, entry.getKey());
            Object value = entry.getValue();
            this.put(field, Tools.field(value, field));
        }
    }
}

