/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.hive.metastore.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.kyuubi.shaded.hive.metastore.security.HadoopThriftAuthBridge23;
import org.apache.kyuubi.shaded.hive.metastore.security.TUGIAssumingTransport;
import org.apache.kyuubi.shaded.thrift.transport.TSaslClientTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransport;
import org.apache.kyuubi.shaded.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HadoopThriftAuthBridge {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopThriftAuthBridge.class);
    private static volatile HadoopThriftAuthBridge self = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HadoopThriftAuthBridge getBridge() {
        if (self != null) return self;
        Class<HadoopThriftAuthBridge> clazz = HadoopThriftAuthBridge.class;
        synchronized (HadoopThriftAuthBridge.class) {
            if (self != null) return self;
            self = new HadoopThriftAuthBridge23();
            // ** MonitorExit[var0] (shouldn't be in output)
            return self;
        }
    }

    public Client createClient() {
        return new Client();
    }

    public abstract Map<String, String> getHadoopSaslProperties(Configuration var1);

    public static class Client {
        public TTransport createClientTransport(String principalConfig, String host, String methodStr, String tokenStrForm, final TTransport underlyingTransport, final Map<String, String> saslProps) throws IOException {
            final SaslRpcServer.AuthMethod method = (SaslRpcServer.AuthMethod)SaslRpcServer.AuthMethod.valueOf(SaslRpcServer.AuthMethod.class, (String)methodStr);
            TSaslClientTransport saslTransport = null;
            switch (method) {
                case DIGEST: {
                    Token t = new Token();
                    t.decodeFromUrlString(tokenStrForm);
                    try {
                        saslTransport = new TSaslClientTransport(method.getMechanismName(), null, null, "default", saslProps, (CallbackHandler)new SaslClientCallbackHandler((Token<? extends TokenIdentifier>)t), underlyingTransport);
                    }
                    catch (TTransportException e) {
                        e.printStackTrace();
                    }
                    return new TUGIAssumingTransport((TTransport)saslTransport, UserGroupInformation.getCurrentUser());
                }
                case KERBEROS: {
                    String serverPrincipal = SecurityUtil.getServerPrincipal((String)principalConfig, (String)host);
                    final String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
                    if (names.length != 3) {
                        throw new IOException("Kerberos principal name does NOT have the expected hostname part: " + serverPrincipal);
                    }
                    try {
                        return (TTransport)UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TUGIAssumingTransport>(){

                            @Override
                            public TUGIAssumingTransport run() throws IOException, TTransportException {
                                TSaslClientTransport saslTransport = new TSaslClientTransport(method.getMechanismName(), null, names[0], names[1], saslProps, null, underlyingTransport);
                                return new TUGIAssumingTransport((TTransport)saslTransport, UserGroupInformation.getCurrentUser());
                            }
                        });
                    }
                    catch (InterruptedException | SaslException se) {
                        throw new IOException("Could not instantiate SASL transport", se);
                    }
                }
            }
            throw new IOException("Unsupported authentication method: " + method);
        }

        private static class SaslClientCallbackHandler
        implements CallbackHandler {
            private final String userName;
            private final char[] userPassword;

            public SaslClientCallbackHandler(Token<? extends TokenIdentifier> token) {
                this.userName = SaslClientCallbackHandler.encodeIdentifier(token.getIdentifier());
                this.userPassword = SaslClientCallbackHandler.encodePassword(token.getPassword());
            }

            @Override
            public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
                NameCallback nc = null;
                PasswordCallback pc = null;
                TextInputCallback rc = null;
                for (Callback callback : callbacks) {
                    if (callback instanceof RealmChoiceCallback) continue;
                    if (callback instanceof NameCallback) {
                        nc = (NameCallback)callback;
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        pc = (PasswordCallback)callback;
                        continue;
                    }
                    if (callback instanceof RealmCallback) {
                        rc = (RealmCallback)callback;
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
                }
                if (nc != null) {
                    LOG.debug("SASL client callback: setting username: {}", (Object)this.userName);
                    nc.setName(this.userName);
                }
                if (pc != null) {
                    LOG.debug("SASL client callback: setting userPassword");
                    pc.setPassword(this.userPassword);
                }
                if (rc != null) {
                    LOG.debug("SASL client callback: setting realm: {}", (Object)rc.getDefaultText());
                    rc.setText(rc.getDefaultText());
                }
            }

            static String encodeIdentifier(byte[] identifier) {
                return new String(Base64.getEncoder().encode(identifier), StandardCharsets.UTF_8);
            }

            static char[] encodePassword(byte[] password) {
                return Base64.getEncoder().encodeToString(password).toCharArray();
            }
        }
    }
}

