/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.net.impl.pool;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kyuubi.shade.io.netty.util.internal.PlatformDependent;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.pool.Executor;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.pool.Task;

public class CombinerExecutor<S>
implements Executor<S> {
    private final Queue<Executor.Action<S>> q = PlatformDependent.newMpscQueue();
    private final AtomicInteger s = new AtomicInteger();
    private final S state;

    public CombinerExecutor(S state) {
        this.state = state;
    }

    @Override
    public void submit(Executor.Action<S> action) {
        this.q.add(action);
        if (this.s.get() != 0 || !this.s.compareAndSet(0, 1)) {
            return;
        }
        Task head = null;
        do {
            try {
                head = this.pollAndExecute(head);
            }
            finally {
                this.s.set(0);
            }
        } while (!this.q.isEmpty() && this.s.compareAndSet(0, 1));
        while (head != null) {
            head.run();
            head = head.next;
        }
    }

    private Task pollAndExecute(Task head) {
        Executor.Action<S> a;
        while ((a = this.q.poll()) != null) {
            Task action = a.execute(this.state);
            if (action == null) continue;
            if (head == null) {
                head.prev = head = action;
                continue;
            }
            action.prev = head.prev;
            head.prev.next = action;
            head.prev = action;
        }
        return head;
    }
}

