/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.api;

import org.apache.kyuubi.shade.io.etcd.jetcd.api.WatchGrpc;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.WatchProgressRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.WatchRequest;
import org.apache.kyuubi.shade.io.etcd.jetcd.api.WatchResponse;
import org.apache.kyuubi.shade.io.grpc.BindableService;
import org.apache.kyuubi.shade.io.grpc.CallOptions;
import org.apache.kyuubi.shade.io.grpc.Channel;
import org.apache.kyuubi.shade.io.grpc.ServerServiceDefinition;
import org.apache.kyuubi.shade.io.grpc.Status;
import org.apache.kyuubi.shade.io.grpc.StatusRuntimeException;
import org.apache.kyuubi.shade.io.grpc.stub.AbstractStub;
import org.apache.kyuubi.shade.io.grpc.stub.ServerCalls;
import org.apache.kyuubi.shade.io.grpc.stub.StreamObserver;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Handler;
import org.apache.kyuubi.shade.io.vertx.core.Vertx;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextInternal;
import org.apache.kyuubi.shade.io.vertx.core.streams.ReadStream;
import org.apache.kyuubi.shade.io.vertx.core.streams.WriteStream;
import org.apache.kyuubi.shade.io.vertx.grpc.stub.ClientCalls;
import org.apache.kyuubi.shade.io.vertx.grpc.stub.ServerCalls;

public final class VertxWatchGrpc {
    private static final int METHODID_PROGRESS = 0;
    private static final int METHODID_WATCH = 1;

    private VertxWatchGrpc() {
    }

    public static WatchVertxStub newVertxStub(Channel channel) {
        return new WatchVertxStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final WatchVertxImplBase serviceImpl;
        private final int methodId;
        private final String compression;

        MethodHandlers(WatchVertxImplBase serviceImpl, int methodId, String compression) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
            this.compression = compression;
        }

        @Override
        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    ServerCalls.oneToOne((WatchProgressRequest)request, responseObserver, this.compression, this.serviceImpl::progress);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 1: {
                    return ServerCalls.manyToMany(responseObserver, this.compression, this.serviceImpl::watch);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class WatchVertxImplBase
    implements BindableService {
        private String compression;

        public WatchVertxImplBase withCompression(String compression) {
            this.compression = compression;
            return this;
        }

        public Future<WatchResponse> progress(WatchProgressRequest request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public void watch(ReadStream<WatchRequest> request, WriteStream<WatchResponse> response) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        @Override
        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder(WatchGrpc.getServiceDescriptor()).addMethod(WatchGrpc.getProgressMethod(), org.apache.kyuubi.shade.io.grpc.stub.ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0, this.compression))).addMethod(WatchGrpc.getWatchMethod(), org.apache.kyuubi.shade.io.grpc.stub.ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 1, this.compression))).build();
        }
    }

    public static final class WatchVertxStub
    extends AbstractStub<WatchVertxStub> {
        private final ContextInternal ctx;
        private WatchGrpc.WatchStub delegateStub;

        private WatchVertxStub(Channel channel) {
            super(channel);
            this.delegateStub = WatchGrpc.newStub(channel);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        private WatchVertxStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = WatchGrpc.newStub(channel).build(channel, callOptions);
            this.ctx = (ContextInternal)Vertx.currentContext();
        }

        @Override
        protected WatchVertxStub build(Channel channel, CallOptions callOptions) {
            return new WatchVertxStub(channel, callOptions);
        }

        public Future<WatchResponse> progress(WatchProgressRequest request) {
            return ClientCalls.oneToOne(this.ctx, request, this.delegateStub::progress);
        }

        public ReadStream<WatchResponse> watch(Handler<WriteStream<WatchRequest>> hdlr) {
            return ClientCalls.manyToMany(this.ctx, hdlr, this.delegateStub::watch);
        }
    }
}

