/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableCalc;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlCaseOperator;
import org.apache.calcite.tools.RelUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapFilterRel;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.relnode.OlapToEnumerableConverter;
import org.apache.kylin.query.relnode.OlapWindowRel;
import org.apache.kylin.query.schema.OlapTable;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.apache.kylin.query.util.RexToTblColRefTranslator;

public class OlapProjectRel
extends Project
implements OlapRel {
    private List<RexNode> rewriteProjects;
    private OlapContext context;
    private Set<OlapContext> subContexts = Sets.newHashSet();
    private boolean rewriting;
    private ColumnRowType columnRowType;
    private boolean afterAggregate;
    private boolean isMerelyPermutation = false;
    private int caseCount = 0;
    private boolean beforeTopPreCalcJoin = false;
    private boolean needPushInfoToSubCtx = false;

    public OlapProjectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType) {
        super(cluster, traitSet, child, exps, rowType);
        Preconditions.checkArgument((this.getConvention() == CONVENTION ? 1 : 0) != 0);
        this.rewriteProjects = exps;
        this.rowType = this.getRowType();
        for (RexNode exp : exps) {
            this.caseCount += RelUtils.countOperatorCall((SqlOperator)SqlCaseOperator.INSTANCE, (RexNode)exp);
        }
    }

    public List<RexNode> getProjects() {
        return this.rewriteProjects;
    }

    private ColumnRowType buildColumnRowType() {
        ArrayList columns = Lists.newArrayList();
        ArrayList sourceColumns = Lists.newArrayList();
        OlapRel olapChild = (OlapRel)this.getInput();
        ColumnRowType inputColumnRowType = olapChild.getColumnRowType();
        HashMap<RexNode, TblColRef> nodeAndTblColMap = new HashMap<RexNode, TblColRef>();
        for (int i = 0; i < this.rewriteProjects.size(); ++i) {
            HashSet sourceCollector;
            RelDataTypeField columnField;
            String fieldName;
            RexNode rex = this.rewriteProjects.get(i);
            TblColRef column = this.translateRexNode(rex, inputColumnRowType, fieldName = (columnField = (RelDataTypeField)this.rowType.getFieldList().get(i)).getName(), sourceCollector = Sets.newHashSet(), nodeAndTblColMap);
            if (column == null) {
                throw new IllegalStateException("No TblColRef found in " + rex);
            }
            columns.add(column);
            sourceColumns.add(sourceCollector);
        }
        return new ColumnRowType(columns, sourceColumns);
    }

    TblColRef translateRexNode(RexNode rexNode, ColumnRowType inputColumnRowType, String fieldName, Set<TblColRef> sourceCollector, Map<RexNode, TblColRef> nodeAndTblColMap) {
        if (!this.afterAggregate) {
            return RexToTblColRefTranslator.translateRexNode(rexNode, inputColumnRowType, fieldName, sourceCollector, nodeAndTblColMap);
        }
        return RexToTblColRefTranslator.translateRexNode(rexNode, inputColumnRowType, fieldName, nodeAndTblColMap);
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        if (this.getInput() instanceof OlapFilterRel) {
            OlapFilterRel filter = (OlapFilterRel)this.getInput();
            RelNode inputOfFilter = inputs.get(0).getInput(0);
            RexProgram program = RexProgram.create((RelDataType)inputOfFilter.getRowType(), this.rewriteProjects, (RexNode)filter.getCondition(), (RelDataType)this.rowType, (RexBuilder)this.getCluster().getRexBuilder());
            return new EnumerableCalc(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), inputOfFilter, program);
        }
        EnumerableRel input = (EnumerableRel)OlapProjectRel.sole(inputs);
        RexProgram program = RexProgram.create((RelDataType)input.getRowType(), this.rewriteProjects, null, (RelDataType)this.rowType, (RexBuilder)this.getCluster().getRexBuilder());
        return new EnumerableCalc(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), (RelNode)input, program);
    }

    @Override
    public boolean hasSubQuery() {
        OlapRel olapChild = (OlapRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public RelWriter explainTerms(RelWriter pw) {
        pw.input("input", this.getInput());
        if (pw.nest()) {
            pw.item("fields", (Object)this.rowType.getFieldNames());
            pw.item("exprs", this.rewriteProjects);
        } else {
            for (Ord field : Ord.zip((List)this.rowType.getFieldList())) {
                String fieldName = ((RelDataTypeField)field.e).getName();
                if (fieldName == null) {
                    fieldName = "field#" + field.i;
                }
                pw.item(fieldName, (Object)this.rewriteProjects.get(field.i));
            }
        }
        if (this.context != null) {
            pw.item("ctx", (Object)this.displayCtxId(this.context));
            if (this.context.getGroupByColumns() != null && this.context.getReturnTupleInfo() != null && this.context.getReturnTupleInfo().getColumnMap() != null) {
                List colIds = this.context.getGroupByColumns().stream().map(colRef -> (Integer)this.context.getReturnTupleInfo().getColumnMap().get(colRef)).collect(Collectors.toList());
                pw.item("groupByColumns", colIds);
            }
        } else {
            pw.item("ctx", (Object)"");
        }
        return pw;
    }

    @Override
    public void implementCutContext(ICutContextStrategy.ContextCutImpl contextCutImpl) {
        this.context = null;
        this.columnRowType = null;
        contextCutImpl.visitChild(this.getInput());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        boolean hasRexOver = RexOver.containsOver(this.getProjects(), null);
        RelOptCost relOptCost = super.computeSelfCost(planner, mq).multiplyBy(0.05).multiplyBy(this.getComplexity()).multiplyBy((double)this.getProjects().size() * (hasRexOver ? 50.0 : 1.0)).plus(planner.getCostFactory().makeCost(0.1 * (double)this.caseCount, 0.0, 0.0));
        return planner.getCostFactory().makeCost(relOptCost.getRows(), 0.0, 0.0);
    }

    private double getComplexity() {
        int complexity = 1;
        for (RexNode rexNode : this.getProjects()) {
            complexity += rexNode.toString().length();
        }
        return Math.exp(-1.0 / (double)complexity);
    }

    public Project copy(RelTraitSet traitSet, RelNode child, List<RexNode> exps, RelDataType rowType) {
        return new OlapProjectRel(this.getCluster(), traitSet, child, exps, rowType);
    }

    @Override
    public void setContext(OlapContext context) {
        this.context = context;
        ((OlapRel)this.getInput()).setContext(context);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
    }

    @Override
    public boolean pushRelInfoToContext(OlapContext context) {
        if (this.context == null && ((OlapRel)this.getInput()).pushRelInfoToContext(context)) {
            this.context = context;
            return true;
        }
        return false;
    }

    @Override
    public void implementContext(OlapRel.ContextImpl contextImpl, OlapRel.ContextVisitorState state) {
        contextImpl.fixSharedOlapTableScan((SingleRel)this);
        OlapRel.ContextVisitorState tempState = OlapRel.ContextVisitorState.init();
        contextImpl.visitChild(this.getInput(), this, tempState);
        this.subContexts.addAll(ContextUtil.collectSubContext(this.getInput()));
        if (this.context == null && this.subContexts.size() == 1 && this.getInput() == ((OlapContext)Lists.newArrayList(this.subContexts).get(0)).getTopNode() && !(this.getInput() instanceof OlapWindowRel)) {
            this.context = (OlapContext)Lists.newArrayList(this.subContexts).get(0);
            this.context.setTopNode(this);
        }
        state.merge(tempState);
    }

    @Override
    public void implementOlap(OlapRel.OlapImpl olapImpl) {
        if (this.getPermutation() != null && !this.isTopProject(olapImpl.getParentNodeStack())) {
            this.isMerelyPermutation = true;
        }
        this.beforeTopPreCalcJoin = this.context != null && this.context.isHasPreCalcJoin();
        olapImpl.visitChild(this.getInput(), this);
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null) {
            this.afterAggregate = this.context.isAfterAggregate();
            if (this == this.context.getTopNode() && !this.context.isHasAgg()) {
                ContextUtil.amendAllColsIfNoAgg(this);
            }
        } else if (this.needPushInfoToSubCtx) {
            this.updateSubContexts(this.subContexts);
        }
    }

    private boolean isTopProject(Deque<RelNode> parentNodeStack) {
        ArrayDeque<RelNode> tmpStack = new ArrayDeque<RelNode>(parentNodeStack);
        while (!tmpStack.isEmpty()) {
            RelNode parentNode = (RelNode)tmpStack.pollFirst();
            if (parentNode instanceof OlapToEnumerableConverter) {
                return true;
            }
            if (!(parentNode instanceof OlapProjectRel)) continue;
            return false;
        }
        return false;
    }

    @Override
    public void implementRewrite(OlapRel.RewriteImpl rewriteImpl) {
        rewriteImpl.visitChild(this, this.getInput());
        if (this.context == null) {
            return;
        }
        this.rewriting = true;
        if (!OlapRel.RewriteImpl.needRewrite(this.context) || this.afterAggregate || !this.context.hasPrecalculatedFields() || this.getContext().isHasJoin() && this.beforeTopPreCalcJoin) {
            this.columnRowType = this.buildColumnRowType();
            this.rewriteProjects();
            return;
        }
        ArrayList newFieldList = Lists.newArrayList();
        Map<Integer, RelDataTypeField> toBeReplacedCcMap = this.replaceGroupByExpsWithCcField(newFieldList);
        newFieldList.addAll(this.rebuildMissPreCalcField());
        ArrayList originFields = Lists.newArrayList((Iterable)this.rowType.getFieldList());
        toBeReplacedCcMap.forEach(originFields::set);
        if (!newFieldList.isEmpty()) {
            List fieldList = Stream.of(originFields, newFieldList).flatMap(Collection::stream).collect(Collectors.toList());
            this.rowType = this.getCluster().getTypeFactory().createStructType(fieldList);
        }
        this.columnRowType = this.buildColumnRowType();
        this.rewriteProjects();
        this.rewriting = false;
    }

    private void rewriteProjects() {
        OlapRel olapChild = (OlapRel)this.getInput();
        ColumnRowType inputColumnRowType = olapChild.getColumnRowType();
        List<TblColRef> allColumns = inputColumnRowType.getAllColumns();
        List ccColRefList = allColumns.stream().filter(col -> col.getColumnDesc().isComputedColumn()).collect(Collectors.toList());
        HashMap columnToIdMap = Maps.newHashMap();
        for (int i = 0; i < allColumns.size(); ++i) {
            TblColRef colRef = allColumns.get(i);
            if ("UNKNOWN_ALIAS".equalsIgnoreCase(colRef.getTableAlias())) continue;
            if (columnToIdMap.containsKey(colRef)) {
                logger.warn("duplicate TblColRef {} of computed column.", (Object)colRef);
            }
            columnToIdMap.putIfAbsent(colRef, i);
        }
        ArrayList newRewriteProjList = Lists.newArrayList();
        HashMap map = Maps.newHashMap();
        for (TblColRef tblColRef : ccColRefList) {
            map.putIfAbsent(tblColRef.getDoubleQuoteExp(), tblColRef);
        }
        HashMap<RexNode, TblColRef> nodeAndTblColMap = new HashMap<RexNode, TblColRef>();
        for (int i = 0; i < this.rewriteProjects.size(); ++i) {
            HashSet sourceCollector;
            RelDataTypeField columnField;
            String fieldName;
            RexNode rex = this.rewriteProjects.get(i);
            TblColRef column = this.translateRexNode(rex, inputColumnRowType, fieldName = (columnField = (RelDataTypeField)this.rowType.getFieldList().get(i)).getName(), sourceCollector = Sets.newHashSet(), nodeAndTblColMap);
            if (column == null) {
                throw new IllegalStateException("No TblColRef found in " + rex);
            }
            TblColRef existColRef = (TblColRef)map.get(column.toString());
            if (existColRef != null && this.getContext().getAllColumns().contains(existColRef)) {
                column = existColRef;
                List inputFieldList = this.getInput().getRowType().getFieldList();
                RelDataTypeField inputField = (RelDataTypeField)inputFieldList.get((Integer)columnToIdMap.get(column));
                RexNode newRef = inputField == null ? rex : new RexInputRef(inputField.getIndex(), inputField.getType());
                newRewriteProjList.add(newRef);
                continue;
            }
            newRewriteProjList.add(rex);
        }
        this.rewriteProjects = newRewriteProjList;
    }

    private void updateSubContexts(Set<OlapContext> subContexts) {
        if (this.isMerelyPermutation || this.rewriting || this.afterAggregate) {
            return;
        }
        ContextUtil.updateSubContexts(this.columnRowType.getSourceColumns().stream().flatMap(Collection::stream).collect(Collectors.toSet()), subContexts);
    }

    @Override
    public void setSubContexts(Set<OlapContext> contexts) {
        this.subContexts = contexts;
    }

    private Map<Integer, RelDataTypeField> replaceGroupByExpsWithCcField(List<RelDataTypeField> newFieldList) {
        HashMap toBeReplacedCCMap = Maps.newHashMap();
        HashMap posInTupleToCcCol = Maps.newHashMap();
        ColumnRowType inputColumnRowType = ((OlapRel)this.getInput()).getColumnRowType();
        AtomicInteger paramIndex = new AtomicInteger(this.rowType.getFieldList().size());
        this.context.getGroupCCColRewriteMapping().forEach((originExp, ccRef) -> {
            String replaceCCField = ccRef.getName();
            int rowIndex = this.columnRowType.getColumnIndex(this.context, replaceCCField);
            if (rowIndex >= 0) {
                return;
            }
            RelDataType ccFieldType = OlapTable.createSqlType(this.getCluster().getTypeFactory(), ccRef.getType(), true);
            int ccColInInputIndex = inputColumnRowType.getColumnIndex(this.context, replaceCCField);
            RelDataTypeField inputField = (RelDataTypeField)this.getInput().getRowType().getFieldList().get(ccColInInputIndex);
            int originExprIndex = this.findColumnRowTypePosition((TblColRef)originExp, this);
            if (originExprIndex < 0) {
                newFieldList.add((RelDataTypeField)new RelDataTypeFieldImpl(replaceCCField, paramIndex.getAndIncrement(), ccFieldType));
                ArrayList newRewriteProjects = Lists.newArrayList(this.rewriteProjects);
                newRewriteProjects.add(new RexInputRef(inputField.getIndex(), inputField.getType()));
                this.rewriteProjects = newRewriteProjects;
            } else {
                RelDataTypeFieldImpl newCcFiled = new RelDataTypeFieldImpl(replaceCCField, originExprIndex, ccFieldType);
                toBeReplacedCCMap.put(originExprIndex, newCcFiled);
                RexInputRef ccFiledRef = new RexInputRef(inputField.getIndex(), inputField.getType());
                posInTupleToCcCol.put(originExprIndex, ccFiledRef);
            }
        });
        if (!posInTupleToCcCol.isEmpty()) {
            ArrayList<RexNode> newProjects = new ArrayList<RexNode>(this.rewriteProjects);
            posInTupleToCcCol.forEach(newProjects::set);
            this.rewriteProjects = newProjects;
        }
        return toBeReplacedCCMap;
    }

    private List<RelDataTypeField> rebuildMissPreCalcField() {
        LinkedList newFieldList = Lists.newLinkedList();
        ArrayList newExpList = Lists.newArrayList();
        List inputFieldList = this.getInput().getRowType().getFieldList();
        ColumnRowType inputColumnRowType = ((OlapRel)this.getInput()).getColumnRowType();
        List<TblColRef> allColumns = this.columnRowType.getAllColumns();
        for (int i = 0; i < this.rewriteProjects.size(); ++i) {
            RexNode rexNode = this.rewriteProjects.get(i);
            if (i >= allColumns.size() || !(rexNode instanceof RexInputRef)) {
                newExpList.add(rexNode);
                continue;
            }
            String inputColumnName = inputColumnRowType.getAllColumns().get(((RexInputRef)rexNode).getIndex()).getCanonicalName();
            String currentColumnName = allColumns.get(i).getCanonicalName();
            int actualIndex = inputColumnRowType.getIndexByCanonicalName(currentColumnName);
            if (!inputColumnName.equals(currentColumnName) && actualIndex >= 0) {
                RelDataTypeField inputField = (RelDataTypeField)inputFieldList.get(actualIndex);
                RexInputRef newFieldRef = new RexInputRef(actualIndex, inputField.getType());
                newExpList.add(newFieldRef);
                continue;
            }
            newExpList.add(rexNode);
        }
        int paramIndex = this.rowType.getFieldList().size();
        for (Map.Entry<String, RelDataType> rewriteField : this.context.getRewriteFields().entrySet()) {
            int inputIndex;
            String rewriteFieldName = rewriteField.getKey();
            int rowIndex = this.columnRowType.getColumnIndex(this.context, rewriteFieldName);
            if (rowIndex >= 0 || (inputIndex = inputColumnRowType.getColumnIndex(this.context, rewriteFieldName)) < 0) continue;
            RelDataType fieldType = rewriteField.getValue();
            RelDataTypeFieldImpl newField = new RelDataTypeFieldImpl(rewriteFieldName, paramIndex++, fieldType);
            newFieldList.add(newField);
            RelDataTypeField inputField = (RelDataTypeField)inputFieldList.get(inputIndex);
            RexInputRef newFieldRef = new RexInputRef(inputField.getIndex(), inputField.getType());
            newExpList.add(newFieldRef);
        }
        this.rewriteProjects = newExpList;
        return newFieldList;
    }

    private int findColumnRowTypePosition(TblColRef colRef, OlapProjectRel rel) {
        for (int i = 0; i < rel.getColumnRowType().getAllColumns().size(); ++i) {
            if (!colRef.equals((Object)rel.getColumnRowType().getColumnByIndex(i))) continue;
            return i;
        }
        return -1;
    }

    @Generated
    public List<RexNode> getRewriteProjects() {
        return this.rewriteProjects;
    }

    @Override
    @Generated
    public OlapContext getContext() {
        return this.context;
    }

    @Override
    @Generated
    public Set<OlapContext> getSubContexts() {
        return this.subContexts;
    }

    @Override
    @Generated
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Generated
    public boolean isMerelyPermutation() {
        return this.isMerelyPermutation;
    }

    @Generated
    public boolean isNeedPushInfoToSubCtx() {
        return this.needPushInfoToSubCtx;
    }

    @Generated
    private boolean isRewriting() {
        return this.rewriting;
    }

    @Generated
    private boolean isAfterAggregate() {
        return this.afterAggregate;
    }

    @Generated
    private int getCaseCount() {
        return this.caseCount;
    }

    @Generated
    private boolean isBeforeTopPreCalcJoin() {
        return this.beforeTopPreCalcJoin;
    }

    @Generated
    public void setNeedPushInfoToSubCtx(boolean needPushInfoToSubCtx) {
        this.needPushInfoToSubCtx = needPushInfoToSubCtx;
    }
}

