/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.function;

import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.function.AbstractUniTypeFunction;

public class Substring<T>
extends AbstractUniTypeFunction<T, Substring<T>> {
    private final int offset;
    private final int length;

    private Substring(BindableColumn<T> column, int offset, int length) {
        super(column);
        this.offset = offset;
        this.length = length;
    }

    @Override
    public String renderWithTableAlias(TableAliasCalculator tableAliasCalculator) {
        return "substring(" + this.column.renderWithTableAlias(tableAliasCalculator) + ", " + this.offset + ", " + this.length + ")";
    }

    @Override
    protected Substring<T> copy() {
        return new Substring<T>(this.column, this.offset, this.length);
    }

    public static <T> Substring<T> of(BindableColumn<T> column, int offset, int length) {
        return new Substring<T>(column, offset, length);
    }
}

