/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.daemon;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.SecretKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KapGuardianHATask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(KapGuardianHATask.class);
    private final CliCommandExecutor cli = new CliCommandExecutor();
    private final String statusCmd;
    private final String startCmd;

    public KapGuardianHATask() {
        String kylinHome = KylinConfig.getKylinHome();
        String pidFile = kylinHome + "/kgid";
        String errLog = kylinHome + "/logs/shell.stderr";
        String outLog = kylinHome + "/logs/shell.stdout";
        this.statusCmd = "sh " + kylinHome + "/sbin/guardian-get-process-status.sh " + pidFile;
        this.startCmd = "nohup sh " + kylinHome + "/bin/guardian.sh start 2>>" + errLog + " | tee -a " + outLog + " &";
        this.initKGSecretKey();
    }

    private void initKGSecretKey() {
        if (KylinConfig.getInstanceFromEnv().isGuardianEnabled()) {
            try {
                SecretKeyUtil.initKGSecretKey();
            }
            catch (Exception e) {
                logger.error("init kg secret key failed!", (Throwable)e);
            }
        }
    }

    @Override
    public void run() {
        try {
            CliCommandExecutor.CliCmdExecResult result = this.cli.execute(this.statusCmd, null);
            int status = Integer.parseInt(result.getCmd().substring(0, result.getCmd().lastIndexOf(10)));
            if (0 != status) {
                if (1 == status) {
                    logger.info("Guardian Process is not running, try to start it");
                } else if (-1 == status) {
                    logger.info("Guardian Process is crashed, try to start it");
                }
                logger.info("Starting Guardian Process");
                this.cli.execute(this.startCmd, null);
                logger.info("Guardian Process started");
            } else {
                logger.info("Guardian Process is running");
            }
        }
        catch (Exception e) {
            logger.error("Failed to monitor Guardian Process!", (Throwable)e);
        }
    }
}

