/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.CancelableTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class FavoriteRuleTool
extends CancelableTask {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final String FAVORITE_RULE_DIR = "favorite_rule";
    private static final String ZIP_SUFFIX = ".zip";

    public void backup(String dir, String project) throws IOException {
        this.extractToHDFS(dir + "/" + FAVORITE_RULE_DIR, project);
    }

    public void restore(String dir, boolean afterTruncate) throws IOException {
        Path path = new Path(dir + "/" + FAVORITE_RULE_DIR);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        for (FileStatus fileStatus : fs.listStatus(path)) {
            String fileName = fileStatus.getPath().getName();
            String project = fileName.substring(0, fileName.indexOf("."));
            this.restoreProject(dir, project, afterTruncate);
        }
    }

    public void restoreProject(String dir, String project, boolean afterTruncate) throws IOException {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        Path path = new Path(dir + "/" + FAVORITE_RULE_DIR + "/" + project + ZIP_SUFFIX);
        FavoriteRuleManager manager = FavoriteRuleManager.getInstance((String)project);
        ArrayList rules = Lists.newArrayList();
        try (ZipInputStream zis = new ZipInputStream((InputStream)fs.open(path));
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)zis, StandardCharsets.UTF_8));){
            while (zis.getNextEntry() != null) {
                String value = br.readLine();
                FavoriteRule rule = (FavoriteRule)JsonUtil.readValue((String)value, FavoriteRule.class);
                rules.add(rule);
            }
        }
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)manager.getTransactionManager(), () -> {
            if (afterTruncate) {
                for (FavoriteRule favoriteRule : manager.listAll()) {
                    manager.delete(favoriteRule);
                }
            }
            for (FavoriteRule rule : rules) {
                manager.updateRule(rule);
            }
            return null;
        });
    }

    public void extractFull(File dir) throws IOException {
        List projects = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects();
        for (ProjectInstance project : projects) {
            this.extractProject(dir, project.getName());
        }
    }

    public void extractProject(File dir, String project) throws IOException {
        File projectFile = new File(dir, project);
        FavoriteRuleManager manager = FavoriteRuleManager.getInstance((String)project);
        try (OutputStream os = Files.newOutputStream(projectFile.toPath(), new OpenOption[0]);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, Charset.defaultCharset()));){
            for (FavoriteRule line : manager.getAll()) {
                try {
                    bw.write(JsonUtil.writeValueAsString((Object)line));
                    bw.newLine();
                    if (!this.isCanceled()) continue;
                    logger.info("favorite rule backup was canceled.");
                    return;
                }
                catch (Exception e) {
                    logger.error("Write error, id is {}", (Object)line.getId(), (Object)e);
                }
            }
        }
    }

    public void extractToHDFS(String dir, String project) throws IOException {
        FavoriteRuleManager manager = FavoriteRuleManager.getInstance((String)project);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        String filePathStr = StringUtils.appendIfMissing((String)dir, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + project + ZIP_SUFFIX;
        try (FSDataOutputStream fos = fs.create(new Path(filePathStr));
             ZipOutputStream zos = new ZipOutputStream((OutputStream)fos);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)zos, Charset.defaultCharset()));){
            for (FavoriteRule line : manager.getAll()) {
                zos.putNextEntry(new ZipEntry(line.getId() + ".json"));
                bw.write(JsonUtil.writeValueAsString((Object)line));
                bw.flush();
            }
        }
    }

    public void backupToLocal(String dir, String project) throws IOException {
        String extractDir = this.prepareLocalBackupDir(dir, project);
        FavoriteRuleManager manager = FavoriteRuleManager.getInstance((String)project);
        List ruleList = manager.getAll();
        for (FavoriteRule rule : ruleList) {
            String fileName = extractDir + rule.getId() + ".json";
            BufferedWriter bf = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(new File(fileName).toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                String value = JsonUtil.writeValueAsString((Object)rule);
                bf.write(value);
                bf.flush();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bf == null) continue;
                if (throwable != null) {
                    try {
                        bf.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                bf.close();
            }
        }
    }

    private String prepareLocalBackupDir(String dir, String project) throws IOException {
        String extractDirPath;
        File extractDir;
        String favoriteRuleDirPath;
        File favoriteRuleDir;
        File rootDir = new File(dir);
        if (!rootDir.exists()) {
            FileUtils.forceMkdir((File)rootDir);
        }
        if (!(favoriteRuleDir = new File(favoriteRuleDirPath = StringUtils.appendIfMissing((String)dir, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + FAVORITE_RULE_DIR)).exists()) {
            FileUtils.forceMkdir((File)favoriteRuleDir);
        }
        if (!(extractDir = new File(extractDirPath = favoriteRuleDirPath + "/" + project + "/")).exists()) {
            FileUtils.forceMkdir((File)extractDir);
        }
        return extractDirPath;
    }

    public void restoreFromLocal(String dir, boolean afterTruncate) throws IOException {
        String restorePath = dir + "/" + FAVORITE_RULE_DIR;
        File restoreDir = new File(restorePath);
        if (!restoreDir.exists()) {
            return;
        }
        File[] projectDirs = restoreDir.listFiles();
        assert (projectDirs != null);
        for (File projectDir : projectDirs) {
            String project = projectDir.getName();
            this.restoreProjectFromLocal(dir, project, afterTruncate);
        }
    }

    public void restoreProjectFromLocal(String dir, String project, boolean afterTruncate) throws IOException {
        String restoreProjectPath = dir + "/" + FAVORITE_RULE_DIR + "/" + project;
        File restoreProjectDir = new File(restoreProjectPath);
        if (!restoreProjectDir.exists()) {
            return;
        }
        File[] jsonFiles = restoreProjectDir.listFiles();
        FavoriteRuleManager manager = FavoriteRuleManager.getInstance((String)project);
        ArrayList rules = Lists.newArrayList();
        assert (jsonFiles != null);
        for (File jsonFile : jsonFiles) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(Files.newInputStream(jsonFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                String value = br.readLine();
                FavoriteRule rule = (FavoriteRule)JsonUtil.readValue((String)value, FavoriteRule.class);
                rules.add(rule);
            }
        }
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)manager.getTransactionManager(), () -> {
            if (afterTruncate) {
                for (FavoriteRule favoriteRule : manager.listAll()) {
                    manager.delete(favoriteRule);
                }
            }
            for (FavoriteRule rule : rules) {
                manager.updateRule(rule);
            }
            return null;
        });
    }
}

