/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.influxdb.com.squareup.moshi;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonAdapter;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonReader;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonWriter;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.Moshi;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.Types;

final class ArrayJsonAdapter
extends JsonAdapter<Object> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        @Override
        @Nullable
        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            Type elementType = Types.arrayComponentType(type);
            if (elementType == null) {
                return null;
            }
            if (!annotations.isEmpty()) {
                return null;
            }
            Class<?> elementClass = Types.getRawType(elementType);
            JsonAdapter<Object> elementAdapter = moshi.adapter(elementType);
            return new ArrayJsonAdapter(elementClass, elementAdapter).nullSafe();
        }
    };
    private final Class<?> elementClass;
    private final JsonAdapter<Object> elementAdapter;

    ArrayJsonAdapter(Class<?> elementClass, JsonAdapter<Object> elementAdapter) {
        this.elementClass = elementClass;
        this.elementAdapter = elementAdapter;
    }

    @Override
    public Object fromJson(JsonReader reader) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        reader.beginArray();
        while (reader.hasNext()) {
            list.add(this.elementAdapter.fromJson(reader));
        }
        reader.endArray();
        Object array = Array.newInstance(this.elementClass, list.size());
        for (int i = 0; i < list.size(); ++i) {
            Array.set(array, i, list.get(i));
        }
        return array;
    }

    @Override
    public void toJson(JsonWriter writer, Object value) throws IOException {
        writer.beginArray();
        int size = Array.getLength(value);
        for (int i = 0; i < size; ++i) {
            this.elementAdapter.toJson(writer, Array.get(value, i));
        }
        writer.endArray();
    }

    public String toString() {
        return this.elementAdapter + ".array()";
    }
}

