/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.Serializable;
import java.util.Locale;
import org.apache.gluten.backendsapi.BackendsApiManager$;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.config.GlutenConfig$;
import org.apache.gluten.sql.shims.SparkShimLoader$;
import org.apache.gluten.vectorized.NativePartitioning;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.ShuffleHandle;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.SparkSortShuffleWriterUtil$;
import org.apache.spark.shuffle.api.ShuffleExecutorComponents;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class GlutenShuffleUtils$ {
    public static GlutenShuffleUtils$ MODULE$;
    private final String SinglePartitioningShortName;
    private final String RoundRobinPartitioningShortName;
    private final String HashPartitioningShortName;
    private final String RangePartitioningShortName;

    static {
        new GlutenShuffleUtils$();
    }

    public String SinglePartitioningShortName() {
        return this.SinglePartitioningShortName;
    }

    public String RoundRobinPartitioningShortName() {
        return this.RoundRobinPartitioningShortName;
    }

    public String HashPartitioningShortName() {
        return this.HashPartitioningShortName;
    }

    public String RangePartitioningShortName() {
        return this.RangePartitioningShortName;
    }

    public int getStartPartitionId(NativePartitioning partition, int partitionId) {
        String string = partition.getShortName();
        String string2 = this.RoundRobinPartitioningShortName();
        String string3 = string;
        int n = !(string2 != null ? !string2.equals(string3) : string3 != null) ? new XORShiftRandom((long)partitionId).nextInt(partition.getNumPartitions()) : 0;
        return n;
    }

    public String getCompressionCodec(SparkConf conf) {
        String string;
        GlutenConfig glutenConfig = GlutenConfig$.MODULE$.get();
        Option option = glutenConfig.columnarShuffleCodec();
        if (option instanceof Some) {
            Some some = (Some)option;
            String codec = (String)some.value();
            String glutenCodecKey = GlutenConfig$.MODULE$.COLUMNAR_SHUFFLE_CODEC().key();
            if (glutenConfig.columnarShuffleEnableQat()) {
                GlutenShuffleUtils$.checkCodecValues$1(glutenCodecKey, codec, GlutenConfig$.MODULE$.GLUTEN_QAT_SUPPORTED_CODEC());
            } else if (glutenConfig.columnarShuffleEnableIaa()) {
                GlutenShuffleUtils$.checkCodecValues$1(glutenCodecKey, codec, GlutenConfig$.MODULE$.GLUTEN_IAA_SUPPORTED_CODEC());
            } else {
                GlutenShuffleUtils$.checkCodecValues$1(glutenCodecKey, codec, BackendsApiManager$.MODULE$.getSettings().shuffleSupportedCodec());
            }
            string = codec;
        } else if (None$.MODULE$.equals(option)) {
            String sparkCodecKey = package$.MODULE$.IO_COMPRESSION_CODEC().key();
            String codec = conf.get(sparkCodecKey, package$.MODULE$.IO_COMPRESSION_CODEC().defaultValueString()).toLowerCase(Locale.ROOT);
            GlutenShuffleUtils$.checkCodecValues$1(sparkCodecKey, codec, BackendsApiManager$.MODULE$.getSettings().shuffleSupportedCodec());
            string = codec;
        } else {
            throw new MatchError((Object)option);
        }
        return string;
    }

    public int getCompressionLevel(SparkConf conf, String codec, String compressionCodecBackend) {
        return "zstd".equals(codec) && compressionCodecBackend == null ? conf.getInt(package$.MODULE$.IO_COMPRESSION_ZSTD_LEVEL().key(), BoxesRunTime.unboxToInt((Object)package$.MODULE$.IO_COMPRESSION_ZSTD_LEVEL().defaultValue().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1))) : Integer.MIN_VALUE;
    }

    public int getSortEvictBufferSize(SparkConf conf, String codec) {
        return "lz4".equals(codec) ? GlutenShuffleUtils$.checkAndGetBufferSize$1(package$.MODULE$.IO_COMPRESSION_LZ4_BLOCKSIZE(), conf) : ("zstd".equals(codec) ? GlutenShuffleUtils$.checkAndGetBufferSize$1(package$.MODULE$.IO_COMPRESSION_ZSTD_BUFFERSIZE(), conf) : GlutenShuffleUtils$.checkAndGetBufferSize$1(package$.MODULE$.SHUFFLE_DISK_WRITE_BUFFER_SIZE(), conf));
    }

    public <K, C> Tuple2<Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>>, Object> getReaderParam(ShuffleHandle handle, int startMapIndex, int endMapIndex, int startPartition, int endPartition) {
        return SparkShimLoader$.MODULE$.getSparkShims().getShuffleReaderParam(handle, startMapIndex, endMapIndex, startPartition, endPartition);
    }

    public <K, V> ShuffleWriter<K, V> getSortShuffleWriter(ShuffleHandle handle, long mapId, TaskContext context, ShuffleWriteMetricsReporter metrics, ShuffleExecutorComponents shuffleExecutorComponents) {
        ShuffleHandle shuffleHandle = handle;
        if (!(shuffleHandle instanceof BaseShuffleHandle)) {
            throw new MatchError((Object)shuffleHandle);
        }
        BaseShuffleHandle baseShuffleHandle = (BaseShuffleHandle)shuffleHandle;
        ShuffleWriter shuffleWriter = SparkSortShuffleWriterUtil$.MODULE$.create(baseShuffleHandle, mapId, context, metrics, shuffleExecutorComponents);
        return shuffleWriter;
    }

    private static final void checkCodecValues$1(String codecConf, String codec, Set validValues) {
        if (!validValues.contains((Object)codec)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("The value of ").append(codecConf).append(" should be one of ").append(validValues.mkString(", ")).append(", but was ").append(codec).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final int checkAndGetBufferSize$1(ConfigEntry entry, SparkConf conf$1) {
        void var2_2;
        int bufferSize = (int)BoxesRunTime.unboxToLong((Object)conf$1.get(entry));
        if (bufferSize < 4) {
            throw new IllegalArgumentException(new StringBuilder(19).append(entry.key()).append(" must be >= 4, got ").append(bufferSize).toString());
        }
        return (int)var2_2;
    }

    private GlutenShuffleUtils$() {
        MODULE$ = this;
        this.SinglePartitioningShortName = "single";
        this.RoundRobinPartitioningShortName = "rr";
        this.HashPartitioningShortName = "hash";
        this.RangePartitioningShortName = "range";
    }
}

