/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import springfox.documentation.service.VendorExtension;

public class ServerVariable {
    private final String name;
    private final List<String> allowedValues = new ArrayList<String>();
    private final String defaultValue;
    private final String description;
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();

    public ServerVariable(String name, List<String> allowedValues, String defaultValue, String description, List<VendorExtension> extensions) {
        this.defaultValue = defaultValue;
        this.description = description;
        this.name = name;
        this.allowedValues.addAll(allowedValues);
        this.extensions.addAll(extensions);
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public List<VendorExtension> getExtensions() {
        return this.extensions;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerVariable that = (ServerVariable)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.allowedValues, that.allowedValues) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.description, that.description) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.allowedValues, this.defaultValue, this.description, this.extensions);
    }

    public String toString() {
        return new StringJoiner(", ", ServerVariable.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("allowedValues=" + this.allowedValues).add("defaultValue='" + this.defaultValue + "'").add("description='" + this.description + "'").add("extensions=" + this.extensions).toString();
    }
}

