/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.rest.response.OpenModelRecResponse;
import org.apache.kylin.rest.response.SuggestionResponse;

public class OpenSuggestionResponse
implements Serializable {
    @JsonProperty(value="models")
    private List<OpenModelRecResponse> models = Lists.newArrayList();
    @JsonProperty(value="error_sqls")
    private List<String> errorSqlList = Lists.newArrayList();
    @JsonProperty(value="optimal_models")
    private List<OpenModelRecResponse> optimalModels = Lists.newArrayList();

    public static List<OpenModelRecResponse> convert(List<SuggestionResponse.ModelRecResponse> response) {
        return response.stream().map(OpenModelRecResponse::convert).collect(Collectors.toList());
    }

    public static OpenSuggestionResponse from(SuggestionResponse innerResponse, List<String> sqls) {
        OpenSuggestionResponse result = new OpenSuggestionResponse();
        result.getModels().addAll(OpenSuggestionResponse.convert(innerResponse.getReusedModels().stream().filter(e -> CollectionUtils.isNotEmpty((Collection)e.getIndexes())).collect(Collectors.toList())));
        result.getModels().addAll(OpenSuggestionResponse.convert(innerResponse.getNewModels()));
        if (CollectionUtils.isNotEmpty((Collection)innerResponse.getOptimalModels())) {
            result.getOptimalModels().addAll(OpenSuggestionResponse.convert(innerResponse.getOptimalModels()));
        }
        result.fillErrorSqlList(sqls);
        return result;
    }

    private void fillErrorSqlList(List<String> inputSqlList) {
        HashSet normalRecommendedSqlSet = Sets.newHashSet();
        for (OpenModelRecResponse modelResponse : this.getModels()) {
            modelResponse.getIndexes().forEach(layoutRecDetailResponse -> {
                List sqlList = layoutRecDetailResponse.getSqlList();
                normalRecommendedSqlSet.addAll(sqlList);
            });
        }
        for (OpenModelRecResponse modelResponse : this.getOptimalModels()) {
            modelResponse.getIndexes().forEach(layoutRecDetailResponse -> {
                List sqlList = layoutRecDetailResponse.getSqlList();
                normalRecommendedSqlSet.addAll(sqlList);
            });
        }
        for (String sql : inputSqlList) {
            if (normalRecommendedSqlSet.contains(sql)) continue;
            this.getErrorSqlList().add(sql);
        }
    }

    @Generated
    public void setModels(List<OpenModelRecResponse> models) {
        this.models = models;
    }

    @Generated
    public void setErrorSqlList(List<String> errorSqlList) {
        this.errorSqlList = errorSqlList;
    }

    @Generated
    public void setOptimalModels(List<OpenModelRecResponse> optimalModels) {
        this.optimalModels = optimalModels;
    }

    @Generated
    public List<OpenModelRecResponse> getModels() {
        return this.models;
    }

    @Generated
    public List<String> getErrorSqlList() {
        return this.errorSqlList;
    }

    @Generated
    public List<OpenModelRecResponse> getOptimalModels() {
        return this.optimalModels;
    }
}

