/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import lombok.Generated;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;
import org.apache.kylin.rec.model.ModelMaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelOptProposer
extends AbstractProposer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelOptProposer.class);
    public static final String NO_COMPATIBLE_MODEL_MSG = "There is no compatible model to accelerate this sql.";

    public ModelOptProposer(AbstractContext proposeContext) {
        super(proposeContext);
    }

    @Override
    public void execute() {
        if (this.proposeContext.getModelContexts() == null) {
            return;
        }
        for (AbstractContext.ModelContext modelCtx : this.proposeContext.getModelContexts()) {
            ModelMaster modelMaster = new ModelMaster(modelCtx);
            if (modelCtx.isSnapshotSelected()) continue;
            try {
                NDataModel model = modelCtx.getTargetModel();
                model = modelMaster.proposeJoins(model);
                model = modelMaster.proposeComputedColumn(model);
                model = modelMaster.proposeScope(model);
                model = modelMaster.shrinkComputedColumn(model);
                modelCtx.setTargetModel(model);
            }
            catch (Exception e) {
                log.error("Unexpected exception occurs in initialize target model.", (Throwable)e);
                modelCtx.setTargetModel(null);
                this.proposeContext.recordException(modelCtx, e);
            }
        }
    }

    @Override
    public String getIdentifierName() {
        return "ModelOptProposer";
    }
}

