/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.runtime.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.engine.spark.utils.LogEx;
import org.apache.kylin.engine.spark.utils.LogUtils$;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableBiMap;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.gridtable.NLayoutToGridTableMapping;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.DeriveInfo;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.HybridRealization;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.query.implicits.package$;
import org.apache.kylin.query.plugin.runtime.MppOnTheFlyProvider;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.relnode.OlapTableScan;
import org.apache.kylin.query.schema.OlapTable;
import org.apache.kylin.query.util.RuntimeHelper$;
import org.apache.kylin.query.util.SparderDerivedUtil;
import org.apache.kylin.storage.StorageContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparderEnv$;
import org.apache.spark.sql.SparkInternalAgent$;
import org.apache.spark.sql.SparkOperation$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.Union$;
import org.apache.spark.sql.execution.utils.DeriveTableColumnInfo;
import org.apache.spark.sql.execution.utils.SchemaProcessor$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.manager.SparderLookupManager$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.SparderTypeUtil$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class TableScanPlan$
implements LogEx {
    public static TableScanPlan$ MODULE$;
    private final ThreadLocal<ConcurrentHashMap<String, LogicalPlan>> cachePlan;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new TableScanPlan$();
    }

    public <U> U logTime(String action, boolean debug, Function0<U> body) {
        return (U)LogEx.logTime$((LogEx)this, (String)action, (boolean)debug, body);
    }

    public <U> boolean logTime$default$2() {
        return LogEx.logTime$default$2$((LogEx)this);
    }

    public void logInfoIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logInfoIf$((LogEx)this, filter, msg);
    }

    public void logWarningIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logWarningIf$((LogEx)this, filter, msg);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ThreadLocal<ConcurrentHashMap<String, LogicalPlan>> cachePlan() {
        return this.cachePlan;
    }

    public LogicalPlan createOlapTable(OlapRel rel) {
        return (LogicalPlan)this.logTime("table scan", true, (Function0 & Serializable & scala.Serializable)() -> {
            SparkSession session = SparderEnv$.MODULE$.getSparkSession();
            OlapContext olapContext = rel.getContext();
            StorageContext storage = olapContext.getStorageContext();
            java.util.List batchSeg = storage.getBatchCandidate().getPrunedSegments();
            java.util.List streamSeg = storage.getStreamCandidate().getPrunedSegments();
            List realizations = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(olapContext.getRealization().getRealizations()).asScala()).toList();
            List plans = (List)((List)((TraversableLike)realizations.map((Function1 & Serializable & scala.Serializable)x$1 -> (NDataflow)x$1, List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)dataflow -> BoxesRunTime.boxToBoolean((boolean)TableScanPlan$.$anonfun$createOlapTable$3(storage, batchSeg, streamSeg, dataflow)))).map((Function1 & Serializable & scala.Serializable)dataflow -> dataflow.isStreaming() ? MODULE$.tableScan(rel, (NDataflow)dataflow, olapContext, session, streamSeg, storage.getStreamCandidate()) : MODULE$.tableScan(rel, (NDataflow)dataflow, olapContext, session, batchSeg, storage.getBatchCandidate()), List$.MODULE$.canBuildFrom());
            return plans.size() == 1 ? (LogicalPlan)plans.head() : new Project(((QueryPlan)plans.head()).output(), (LogicalPlan)new Union((Seq)plans, Union$.MODULE$.apply$default$2(), Union$.MODULE$.apply$default$3()));
        });
    }

    public LogicalPlan createMetadataTable(OlapRel rel) {
        SparkSession session = SparderEnv$.MODULE$.getSparkSession();
        OlapContext olapContext = rel.getContext();
        ArrayList allFields = new ArrayList();
        olapContext.getAllTableScans().forEach(tableScan -> {
            java.util.List columns = tableScan.getColumnRowType().getAllColumns();
            allFields.addAll(columns);
        });
        java.util.List dataSet = olapContext.getColValuesRange();
        ArrayList result = new ArrayList();
        dataSet.forEach(rowData -> {
            Object[] sparderData = new Object[((Object[])rowData).length];
            Predef$.MODULE$.genericArrayOps((Object)sparderData).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
                org.apache.kylin.metadata.datatype.DataType dataType = ((TblColRef)allFields.get(index)).getColumnDesc().getUpgradedType();
                sparderData$1[index] = SparderTypeUtil$.MODULE$.convertStringToResultValueBasedOnKylinSQLType(rowData[index], dataType);
            });
            result.add(Row$.MODULE$.fromSeq((Seq)Predef$.MODULE$.genericWrapArray((Object)sparderData)));
        });
        ArrayList structTypes = new ArrayList();
        allFields.forEach(col -> {
            try {
                org.apache.kylin.metadata.datatype.DataType dataType = col.getColumnDesc().getUpgradedType();
                DataType spaType = dataType.isDate() ? DataTypes.DateType : (dataType.isDateTimeFamily() ? DataTypes.TimestampType : SparderTypeUtil$.MODULE$.kylinTypeToSparkResultType(dataType));
                structTypes.add(new StructField(col.getIdentity().replace(".", "_"), spaType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
            }
            catch (IllegalArgumentException e) {
                structTypes.add(new StructField(col.getIdentity().replace(".", "_"), (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e.toString());
            }
        });
        StructType schema = StructType$.MODULE$.apply(structTypes);
        return session.createDataFrame(result, schema).queryExecution().logical();
    }

    private LogicalPlan tableScanEmptySegment(OlapRel rel) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "prunedSegments is null");
        return SparkOperation$.MODULE$.createEmptyDataFrame(StructType$.MODULE$.apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getColumnRowType().getAllColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)column -> new StructField(column.toString().replaceAll("\\.", "_"), SparderTypeUtil$.MODULE$.toSparkType(column.getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2()), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom()))).queryExecution().logical();
    }

    public boolean isSegmentsEmpty(java.util.List<NDataSegment> prunedSegments, java.util.List<NDataSegment> prunedStreamingSegments) {
        boolean isPrunedSegmentsEmpty = prunedSegments == null || prunedSegments.size() == 0;
        boolean isPrunedStreamingSegmentsEmpty = prunedStreamingSegments == null || prunedStreamingSegments.size() == 0;
        return isPrunedSegmentsEmpty && isPrunedStreamingSegmentsEmpty;
    }

    public LogicalPlan tableScan(OlapRel rel, NDataflow dataflow, OlapContext olapContext, SparkSession session, java.util.List<NDataSegment> prunedSegments, NLayoutCandidate candidate) {
        LogicalPlan logicalPlan;
        Map prunedPartitionMap = olapContext.getStorageContext().getPrunedPartitions();
        olapContext.resetSQLDigest();
        LayoutEntity cuboidLayout = candidate.getLayoutEntity();
        if (cuboidLayout.getIndex() != null && cuboidLayout.getIndex().isTableIndex()) {
            QueryContext.current().getQueryTagInfo().setTableIndex(true);
        }
        String tableName = olapContext.getFirstTableScan().getBackupAlias();
        NLayoutToGridTableMapping mapping = new NLayoutToGridTableMapping(cuboidLayout);
        Seq<String> columnNames = SchemaProcessor$.MODULE$.buildGTSchema(cuboidLayout, mapping, tableName);
        KapConfig kapConfig = KapConfig.wrap((KylinConfig)dataflow.getConfig());
        MppOnTheFlyProvider mppOnTheFly = this.getMppOnTheFlyProvider((KylinConfig)dataflow.getConfig());
        String basePath = kapConfig.getReadParquetStoragePath(dataflow.getProject());
        if (prunedSegments == null || prunedSegments.size() == 0) {
            return this.tableScanEmptySegment(rel);
        }
        Buffer fileList = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(prunedSegments).asScala()).map((Function1 & Serializable & scala.Serializable)seg -> MODULE$.toLayoutPath(dataflow, cuboidLayout.getId(), basePath, (NDataSegment)seg, prunedPartitionMap), Buffer$.MODULE$.canBuildFrom());
        String path = new StringBuilder(0).append(fileList.mkString(",")).append(olapContext.isExactlyFastBitmap()).toString();
        this.printLogInfo(basePath, dataflow.getId(), cuboidLayout.getId(), prunedSegments, prunedPartitionMap);
        String pruningInfo = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(prunedSegments).asScala()).map((Function1 & Serializable & scala.Serializable)seg -> {
            String string;
            if (prunedPartitionMap != null && CollectionUtils.isNotEmpty((Collection)((Collection)prunedPartitionMap.get(seg.getId())))) {
                java.util.List partitions = (java.util.List)prunedPartitionMap.get(seg.getId());
                string = new StringBuilder(1).append(seg.getId()).append(":").append(Joiner.on((String)"|").join((Iterable)partitions)).toString();
            } else {
                string = seg.getId();
            }
            return string;
        }, Buffer$.MODULE$.canBuildFrom())).mkString(",");
        LogicalPlan cached = this.cachePlan().get().getOrDefault(path, null);
        if (cached != null && !SparderEnv$.MODULE$.getSparkSession().sparkContext().isStopped()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Reuse plan: ").append(cuboidLayout.getId()).toString());
            logicalPlan = cached;
        } else {
            LogicalPlan newPlan = package$.MODULE$.sessionToQueryContext(session).kylin().isFastBitmapEnabled(olapContext.isExactlyFastBitmap()).bucketingEnabled(this.bucketEnabled(olapContext, cuboidLayout)).cuboidTable(dataflow, cuboidLayout, pruningInfo);
            LogicalPlan mppPlan = mppOnTheFly.computeMissingLayout(prunedSegments, cuboidLayout.getId(), session);
            LogicalPlan cuboidAndMppPlan = mppPlan == null ? newPlan : package.plans$.MODULE$.DslLogicalPlan(newPlan).union(mppPlan);
            this.cachePlan().get().put(path, cuboidAndMppPlan);
            logicalPlan = cuboidAndMppPlan;
        }
        LogicalPlan plan = logicalPlan;
        plan = SparkOperation$.MODULE$.projectAsAlias(columnNames, plan);
        Tuple2<Seq<Column>, LogicalPlan> tuple2 = this.buildSchema(plan, tableName, cuboidLayout, rel, olapContext, dataflow);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq schema = (Seq)tuple2._1();
        LogicalPlan newPlan = (LogicalPlan)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)schema, (Object)newPlan);
        Tuple2 tuple23 = tuple22;
        Seq schema2 = (Seq)tuple23._1();
        LogicalPlan newPlan2 = (LogicalPlan)tuple23._2();
        return SparkOperation$.MODULE$.project((Seq<Column>)schema2, newPlan2);
    }

    /*
     * WARNING - void declaration
     */
    private MppOnTheFlyProvider getMppOnTheFlyProvider(KylinConfig config) {
        void var2_2;
        MppOnTheFlyProvider ret = null;
        if (config.isMppOnTheFlyLayoutsEnabled()) {
            try {
                ret = (MppOnTheFlyProvider)ClassUtil.newInstance((String)config.getMppOnTheFlyLayoutsProvider());
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "failed to instantiate MppOnTheFlyProvider", e);
            }
        }
        return ret == null ? new MppOnTheFlyProvider(){

            public LogicalPlan computeMissingLayout(java.util.List<NDataSegment> prunedSegments, long layoutId, SparkSession ss) {
                return null;
            }
        } : var2_2;
    }

    public boolean bucketEnabled(OlapContext context, LayoutEntity layout) {
        if (!KylinConfig.getInstanceFromEnv().isShardingJoinOptEnabled()) {
            return false;
        }
        if (context.isHasAgg() && !context.isExactlyAggregate()) {
            return false;
        }
        return context.getOuterJoinParticipants().size() == 1 && layout.getShardByColumnRefs().size() == 1 && BoxesRunTime.equals(context.getOuterJoinParticipants().iterator().next(), layout.getShardByColumnRefs().get(0));
    }

    public Tuple2<Seq<Column>, LogicalPlan> buildSchema(LogicalPlan plan, String tableName, LayoutEntity cuboidLayout, OlapRel rel, OlapContext olapContext, NDataflow dataflow) {
        LogicalPlan newPlan = plan;
        boolean isBatchOfHybrid = olapContext.getRealization() instanceof HybridRealization && dataflow.getModel().isFusionModel() && !dataflow.isStreaming();
        NLayoutToGridTableMapping mapping = new NLayoutToGridTableMapping(cuboidLayout, isBatchOfHybrid);
        StorageContext context = olapContext.getStorageContext();
        java.util.List groups = olapContext.getSQLDigest().getGroupByColumns();
        HashSet otherDims = Sets.newHashSet((Iterable)context.getDimensions());
        otherDims.removeAll(groups);
        Set<TblColRef> groupsD = this.expandDerived(context.getCandidate(), groups);
        Set<TblColRef> otherDimsD = this.expandDerived(context.getCandidate(), otherDims);
        otherDimsD.removeAll(groupsD);
        LinkedHashSet<TblColRef> dimensionsD = new LinkedHashSet<TblColRef>();
        dimensionsD.addAll(groupsD);
        dimensionsD.addAll(otherDimsD);
        NDataModel model = context.getCandidate().getLayoutEntity().getModel();
        ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(context.getCandidate().getDerivedToHostMap()).asScala()).toList().foreach((Function1 & Serializable & scala.Serializable)m -> {
            TableScanPlan$.$anonfun$buildSchema$1(mapping, model, dimensionsD, m);
            return BoxedUnit.UNIT;
        });
        int[] gtColIdx = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mapping.getDimIndices(dimensionsD))).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mapping.getMetricsIndices((Collection)context.getMetrics()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        SparderDerivedUtil derived = new SparderDerivedUtil(tableName, dataflow.getLatestReadySegment(), gtColIdx, olapContext.getReturnTupleInfo(), context.getCandidate());
        if (derived.hasDerived()) {
            newPlan = derived.joinDerived(newPlan);
        }
        scala.collection.immutable.Map topNMapping = Predef$.MODULE$.Map().empty();
        Option topNMetric = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(context.getMetrics()).asScala()).collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends FunctionDesc, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                A1 A12 = x1;
                Object object = A12 != null && (A1 = A12).getReturnType().startsWith("topn") ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(FunctionDesc x1) {
                FunctionDesc functionDesc;
                FunctionDesc functionDesc2 = x1;
                boolean bl = functionDesc2 != null && (functionDesc = functionDesc2).getReturnType().startsWith("topn");
                return bl;
            }
        });
        if (topNMetric.isDefined()) {
            int topNFieldIndex = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mapping.getMetricsIndices((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)((FunctionDesc)topNMetric.get()), (List)Nil$.MODULE$)).asJava()))).head());
            Dataset df = SparkInternalAgent$.MODULE$.getDataFrame(SparderEnv$.MODULE$.getSparkSession(), newPlan);
            Tuple2<Dataset<Row>, scala.collection.immutable.Map<Object, Column>> tp = this.processTopN((FunctionDesc)topNMetric.get(), (Dataset<Row>)df, topNFieldIndex, olapContext.getReturnTupleInfo(), tableName);
            newPlan = ((Dataset)tp._1()).queryExecution().analyzed();
            topNMapping = (scala.collection.immutable.Map)tp._2();
        }
        int[] tupleIdx = this.getTupleIdx(dimensionsD, context.getMetrics(), olapContext.getReturnTupleInfo());
        return new Tuple2(RuntimeHelper$.MODULE$.gtSchemaToCalciteSchema(mapping.getPrimaryKey(), derived, tableName, (List<TblColRef>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getColumnRowType().getAllColumns()).asScala()).toList(), newPlan, (Tuple2<int[], int[]>)new Tuple2((Object)gtColIdx, (Object)tupleIdx), (scala.collection.immutable.Map<Object, Column>)topNMapping), (Object)newPlan);
    }

    public String toLayoutPath(NDataflow dataflow, long cuboidId, String basePath, NDataSegment seg) {
        return new StringBuilder(2).append(basePath).append(dataflow.getUuid()).append("/").append(seg.getId()).append("/").append(cuboidId).toString();
    }

    public List<String> toLayoutPath(NDataflow dataflow, long layoutId, String basePath, NDataSegment seg, Map<String, java.util.List<Long>> partitionsMap) {
        return partitionsMap == null ? new .colon.colon((Object)this.toLayoutPath(dataflow, layoutId, basePath, seg), (List)Nil$.MODULE$) : ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionsMap.get(seg.getId())).asScala()).map((Function1 & Serializable & scala.Serializable)part -> {
            Long bucketId = dataflow.getSegment(seg.getId()).getBucketId(layoutId, part);
            Long childDir = bucketId == null ? part : bucketId;
            return new StringBuilder(1).append(MODULE$.toLayoutPath(dataflow, layoutId, basePath, seg)).append("/").append(childDir).toString();
        }, Buffer$.MODULE$.canBuildFrom())).toList();
    }

    public void printLogInfo(String basePath, String dataflowId, long cuboidId, java.util.List<NDataSegment> prunedSegments, Map<String, java.util.List<Long>> partitionsMap) {
        if (partitionsMap == null) {
            String segmentIDs = LogUtils$.MODULE$.jsonArray((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(prunedSegments).asScala(), (Function1 & Serializable & scala.Serializable)e -> new StringBuilder(5).append(e.getId()).append(" [").append(e.getSegRange().getStart()).append(", ").append(e.getSegRange().getEnd()).append(")").toString(), ClassTag$.MODULE$.apply(String.class));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Path is: {\"base\":\"").append(basePath).append("\",\"dataflow\":\"").append(dataflowId).append("\",\"segments\":").append(segmentIDs).append(",\"layout\": ").append(cuboidId).toString());
        } else {
            String prunedSegmentInfo = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(partitionsMap).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String segmentId = (String)tuple2._1();
                java.util.List partitionList = (java.util.List)tuple2._2();
                String string = new StringBuilder(4).append("[").append(segmentId).append(": ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(partitionList).asScala()).mkString(",")).append("]").toString();
                return string;
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Path is: {\"base\":\"").append(basePath).append("\",\"dataflow\":\"").append(dataflowId).append("\",\"segments\":{").append(prunedSegmentInfo).append("},\"layout\": ").append(cuboidId).toString());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("size is ").append(MODULE$.cachePlan().get().size()).toString());
    }

    private Tuple2<Dataset<Row>, scala.collection.immutable.Map<Object, Column>> processTopN(FunctionDesc topNMetric, Dataset<Row> df, int topNFieldIndex, TupleInfo tupleInfo, String tableName) {
        int n;
        Option topNField = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TableScanPlan$.$anonfun$processTopN$1(x$3))))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.swap(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms()).get((Object)BoxesRunTime.boxToInteger((int)topNFieldIndex));
        Predef$.MODULE$.require(topNField.isDefined());
        String[] inlinedSelectExpr = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TableScanPlan$.$anonfun$processTopN$3(topNField, x$5))))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)new StringBuilder(8).append("inline(").append(((StructField)topNField.get()).name()).append(")").toString(), ClassTag$.MODULE$.apply(String.class));
        Dataset inlinedDF = df.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])inlinedSelectExpr));
        String[] flattenedSelectExpr = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inlinedDF.schema().fields())).dropRight(1))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$colon$plus((Object)new StringBuilder(2).append(((StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inlinedDF.schema().fields())).last()).name()).append(".*").toString(), ClassTag$.MODULE$.apply(String.class));
        Dataset flattenedDF = inlinedDF.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])flattenedSelectExpr));
        List<TblColRef> topNLiteralColumn = this.getTopNLiteralColumn(topNMetric);
        List literalTupleIdx = (List)((List)topNLiteralColumn.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)tupleInfo.hasColumn(x$1)))).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)tupleInfo.getColumnIndex(x$1)), List$.MODULE$.canBuildFrom());
        TblColRef numericCol = this.getTopNNumericColumn(topNMetric);
        if (numericCol != null) {
            FunctionDesc sumFunc = FunctionDesc.newInstance((String)"SUM", (java.util.List)Lists.newArrayList((Object[])new ParameterDesc[]{ParameterDesc.newInstance((Object)numericCol)}), (String)numericCol.getType().toString());
            n = tupleInfo.getFieldIndex(sumFunc.getRewriteFieldName());
        } else {
            FunctionDesc countFunction = FunctionDesc.newInstance((String)"COUNT", (java.util.List)Lists.newArrayList((Object[])new ParameterDesc[]{ParameterDesc.newInstance((Object)"1")}), (String)"bigint");
            n = tupleInfo.getFieldIndex(countFunction.getRewriteFieldName());
        }
        int numericTupleIdx = n;
        TblColRef[] dimCols = (TblColRef[])topNLiteralColumn.toArray(ClassTag$.MODULE$.apply(TblColRef.class));
        List dimWithType = (List)((List)literalTupleIdx.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)index -> {
            TblColRef column = dimCols[index._2$mcI$sp()];
            return new Tuple2((Object)SchemaProcessor$.MODULE$.genTopNSchema(tableName, index._1$mcI$sp(), column.getIdentity().replaceAll("\\.", "_")), (Object)SparderTypeUtil$.MODULE$.toSparkType(column.getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2()));
        }, List$.MODULE$.canBuildFrom());
        TblColRef sumCol = (TblColRef)tupleInfo.getAllColumns().get(numericTupleIdx);
        String sumColName = new StringBuilder(7).append("A_SUM_").append(sumCol.getName()).append("_").append(numericTupleIdx).toString();
        StructField measureSchema = new StructField(sumColName, (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType newSchema = StructType$.MODULE$.apply((Seq)((TraversableLike)df.schema().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TableScanPlan$.$anonfun$processTopN$9(topNField, x$8)))).$plus$plus((GenTraversableOnce)((List)dimWithType.map((Function1 & Serializable & scala.Serializable)tp -> new StructField((String)tp._1(), (DataType)tp._2(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), List$.MODULE$.canBuildFrom())).$plus$colon((Object)measureSchema, List$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom()));
        scala.collection.immutable.Map topNMapping = ((TraversableOnce)((List)((List)literalTupleIdx.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)index -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)index._1$mcI$sp()), (Object)functions$.MODULE$.col(SchemaProcessor$.MODULE$.genTopNSchema(tableName, index._1$mcI$sp(), dimCols[index._2$mcI$sp()].getIdentity().replaceAll("\\.", "_")))), List$.MODULE$.canBuildFrom())).$plus$colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)numericTupleIdx), (Object)functions$.MODULE$.col(sumColName)), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)flattenedDF.toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])newSchema.fieldNames())), (Object)topNMapping);
    }

    private List<TblColRef> getTopNLiteralColumn(FunctionDesc functionDesc) {
        java.util.List allCols = functionDesc.getColRefs();
        if (!((ParameterDesc)functionDesc.getParameters().get(0)).isColumnType()) {
            return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(allCols).asScala()).toList();
        }
        return ((TraversableOnce)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(allCols).asScala()).drop(1)).toList();
    }

    private TblColRef getTopNNumericColumn(FunctionDesc functionDesc) {
        if (((ParameterDesc)functionDesc.getParameters().get(0)).isColumnType()) {
            return (TblColRef)functionDesc.getColRefs().get(0);
        }
        return null;
    }

    public int[] getTupleIdx(Set<TblColRef> selectedDimensions, Set<FunctionDesc> selectedMetrics, TupleInfo tupleInfo) {
        ObjectRef tupleIdx = ObjectRef.create((Object)new int[selectedDimensions.size() + selectedMetrics.size()]);
        IntRef i = IntRef.create((int)0);
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(selectedDimensions).asScala()).foreach((Function1 & Serializable & scala.Serializable)dim -> {
            TableScanPlan$.$anonfun$getTupleIdx$1(tupleIdx, i, tupleInfo, dim);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(selectedMetrics).asScala()).foreach((Function1 & Serializable & scala.Serializable)metric -> {
            TableScanPlan$.$anonfun$getTupleIdx$2(tupleIdx, i, tupleInfo, metric);
            return BoxedUnit.UNIT;
        });
        return (int[])tupleIdx.elem;
    }

    public LogicalPlan createLookupTable(OlapRel rel) {
        long start = System.currentTimeMillis();
        OlapContext olapContext = rel.getContext();
        KylinConfig config = olapContext.getOlapSchema().getConfig();
        String project = olapContext.getOlapSchema().getProject();
        NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)config, (String)project);
        String lookupTableName = olapContext.getFirstTableScan().getTableName();
        String snapshotResPath = tableMetadataManager.getTableDesc(lookupTableName).getLastSnapshotPath();
        String dataFrameTableName = new StringBuilder(1).append(project).append("@").append(lookupTableName).toString();
        LogicalPlan lookupPlan = SparderLookupManager$.MODULE$.getOrCreate(dataFrameTableName, snapshotResPath, config);
        OlapTable olapTable = olapContext.getFirstTableScan().getOlapTable();
        String alisTableName = olapContext.getFirstTableScan().getBackupAlias();
        Seq newNames = (Seq)lookupPlan.output().map((Function1 & Serializable & scala.Serializable)c -> {
            void var3_3;
            DeriveTableColumnInfo gTInfoSchema = SchemaProcessor$.MODULE$.parseDeriveTableSchemaName(c.name());
            String name = SchemaProcessor$.MODULE$.generateDeriveTableSchemaName(alisTableName, gTInfoSchema.columnId(), gTInfoSchema.columnName());
            return var3_3;
        }, Seq$.MODULE$.canBuildFrom());
        LogicalPlan newNameLookupPlan = SparkOperation$.MODULE$.projectAsAlias((Seq<String>)newNames, lookupPlan);
        Buffer colIndex = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(olapTable.getSourceColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)column -> column.isComputedColumn() || column.getZeroBasedIndex() < 0 ? RuntimeHelper$.MODULE$.intOne().as(column.toString()) : functions$.MODULE$.col(SchemaProcessor$.MODULE$.generateDeriveTableSchemaName(alisTableName, column.getZeroBasedIndex(), column.getName())), Buffer$.MODULE$.canBuildFrom());
        LogicalPlan plan = SparkOperation$.MODULE$.project((Seq<Column>)colIndex, newNameLookupPlan);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Gen lookup table scan cost Time :").append(System.currentTimeMillis() - start).append(" ").toString());
        return plan;
    }

    public LogicalPlan createInternalTable(OlapRel rel) {
        SparkSession sparkSession = SparderEnv$.MODULE$.getSparkSession();
        OlapTableScan tableScan = (OlapTableScan)rel;
        String project = QueryContext.current().getProject();
        String tableIdentity = tableScan.getTableName();
        Buffer allColumns = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableScan.getOlapTable().getSourceColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)column -> column.isComputedColumn() || column.getZeroBasedIndex() < 0 ? "1" : column.getBackTickName(), Buffer$.MODULE$.canBuildFrom());
        String arg$macro$1 = allColumns.mkString(",");
        String arg$macro$2 = project;
        String arg$macro$3 = tableIdentity;
        String sql = new StringOps("select %s from INTERNAL_CATALOG.%s.%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3}));
        return sparkSession.sql(sql).queryExecution().analyzed();
    }

    /*
     * WARNING - void declaration
     */
    private Set<TblColRef> expandDerived(NLayoutCandidate layoutCandidate, Collection<TblColRef> cols) {
        void var3_3;
        HashSet expanded = new HashSet();
        NDataModel model = layoutCandidate.getLayoutEntity().getModel();
        ImmutableBiMap tblIdMap = model.getEffectiveCols().inverse();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(cols).asScala()).foreach((Function1 & Serializable & scala.Serializable)col -> {
            Boolean bl;
            DeriveInfo hostInfo = (DeriveInfo)layoutCandidate.getDerivedToHostMap().get(tblIdMap.get(col));
            if (hostInfo != null) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(hostInfo.columns).asScala()).foreach((Function1 & Serializable & scala.Serializable)hostCol -> BoxesRunTime.boxToBoolean((boolean)expanded.add(model.getColRef(hostCol))));
                bl = BoxedUnit.UNIT;
            } else {
                bl = BoxesRunTime.boxToBoolean((boolean)expanded.add(col));
            }
            return bl;
        });
        return var3_3;
    }

    public LogicalPlan createSingleRow() {
        SparkSession session = SparderEnv$.MODULE$.getSparkSession();
        List rows = (List)List$.MODULE$.fill(1, (Function0 & Serializable & scala.Serializable)() -> Row$.MODULE$.fromSeq((Seq)Nil$.MODULE$));
        RDD rdd = session.sparkContext().makeRDD((Seq)rows, session.sparkContext().makeRDD$default$2(), ClassTag$.MODULE$.apply(Row.class));
        return session.createDataFrame(rdd, StructType$.MODULE$.apply((Seq)Nil$.MODULE$)).queryExecution().logical();
    }

    public static final /* synthetic */ boolean $anonfun$createOlapTable$3(StorageContext storage$1, java.util.List batchSeg$1, java.util.List streamSeg$1, NDataflow dataflow) {
        return !dataflow.isStreaming() && !storage$1.isBatchCandidateEmpty() || dataflow.isStreaming() && !storage$1.isStreamCandidateEmpty() || MODULE$.isSegmentsEmpty(batchSeg$1, streamSeg$1);
    }

    public static final /* synthetic */ void $anonfun$buildSchema$1(NLayoutToGridTableMapping mapping$1, NDataModel model$1, LinkedHashSet dimensionsD$1, Tuple2 m) {
        block0: {
            DeriveInfo.DeriveType deriveType = ((DeriveInfo)m._2()).type;
            DeriveInfo.DeriveType deriveType2 = DeriveInfo.DeriveType.LOOKUP;
            if ((deriveType != null ? !deriveType.equals(deriveType2) : deriveType2 != null) || ((DeriveInfo)m._2()).isOneToOne) break block0;
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeriveInfo)m._2()).columns).asScala()).foreach((Function1 & Serializable & scala.Serializable)derivedId -> mapping$1.getIndexOf(model$1.getColRef(derivedId)) != -1 ? BoxesRunTime.boxToBoolean((boolean)dimensionsD$1.add(model$1.getColRef(derivedId))) : BoxedUnit.UNIT);
        }
    }

    public static final /* synthetic */ boolean $anonfun$processTopN$1(Tuple2 x$3) {
        return ((StructField)x$3._1()).dataType() instanceof ArrayType;
    }

    public static final /* synthetic */ boolean $anonfun$processTopN$3(Option topNField$1, StructField x$5) {
        StructField structField = x$5;
        Object object = topNField$1.get();
        return structField == null ? object != null : !structField.equals(object);
    }

    public static final /* synthetic */ boolean $anonfun$processTopN$9(Option topNField$1, StructField x$8) {
        String string = x$8.name();
        String string2 = ((StructField)topNField$1.get()).name();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$getTupleIdx$1(ObjectRef tupleIdx$1, IntRef i$1, TupleInfo tupleInfo$2, TblColRef dim) {
        ((int[])tupleIdx$1.elem)[i$1.elem] = tupleInfo$2.hasColumn(dim) ? tupleInfo$2.getColumnIndex(dim) : -1;
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$getTupleIdx$2(ObjectRef tupleIdx$1, IntRef i$1, TupleInfo tupleInfo$2, FunctionDesc metric) {
        if (metric.needRewrite()) {
            String rewriteFieldName = metric.getRewriteFieldName();
            ((int[])tupleIdx$1.elem)[i$1.elem] = tupleInfo$2.hasField(rewriteFieldName) ? tupleInfo$2.getFieldIndex(rewriteFieldName) : -1;
        } else {
            TblColRef col = (TblColRef)metric.getColRefs().get(0);
            ((int[])tupleIdx$1.elem)[i$1.elem] = tupleInfo$2.hasColumn(col) ? tupleInfo$2.getColumnIndex(col) : -1;
        }
        ++i$1.elem;
    }

    private TableScanPlan$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        LogEx.$init$((LogEx)this);
        this.cachePlan = new ThreadLocal<ConcurrentHashMap<String, LogicalPlan>>(){

            public ConcurrentHashMap<String, LogicalPlan> initialValue() {
                return new ConcurrentHashMap<String, LogicalPlan>();
            }
        };
    }
}

